/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Attribute;
import org.eclipse.php.core.compiler.ast.nodes.IAttributed;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ConstantDeclaration
extends Declaration
implements IPHPDocAwareDeclaration,
IAttributed {
    private final ConstantReference constant;
    private final Expression initializer;
    private final SimpleReference constantType;
    private PHPDocBlock phpDoc;
    private List<Attribute> attributes;

    public ConstantDeclaration(ConstantReference constant, Expression initializer, int start, int end, PHPDocBlock phpDoc) {
        this(constant, initializer, 0, start, end, phpDoc);
    }

    public ConstantDeclaration(ConstantReference constant, Expression initializer, int modifiers, int start, int end, PHPDocBlock phpDoc) {
        this(null, constant, initializer, modifiers, start, end, phpDoc);
    }

    public ConstantDeclaration(SimpleReference type, ConstantReference constant, Expression initializer, int modifiers, int start, int end, PHPDocBlock phpDoc) {
        super(start, end);
        assert (constant != null);
        this.constant = constant;
        this.initializer = initializer;
        this.phpDoc = phpDoc;
        this.constantType = type;
        this.setModifiers(modifiers);
        this.setName(constant.getName());
    }

    @Override
    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            if (this.attributes != null) {
                for (Attribute attr : this.attributes) {
                    attr.traverse(visitor);
                }
            }
            if (this.constantType != null) {
                this.constantType.traverse(visitor);
            }
            this.constant.traverse(visitor);
            if (this.initializer != null) {
                this.initializer.traverse(visitor);
            }
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 11;
    }

    public Expression getConstantValue() {
        return this.initializer;
    }

    public ConstantReference getConstantName() {
        return this.constant;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setPHPDoc(PHPDocBlock block) {
        this.phpDoc = block;
    }

    public SimpleReference getConstantType() {
        return this.constantType;
    }
}

