/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.BiFunctionWithException;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.exceptions.RunnableWithException;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.progress.ProgressPlugin;
import aQute.bnd.service.progress.TaskManager;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.bndtools.api.ModelListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.bnd.ui.plugins.RepositoriesViewRefresher;
import org.osgi.util.promise.PromiseFactory;

public class Central {
    public static final String BNDTOOLS_NATURE = "bndtools.core.bndnature";
    private static final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public static IFile getWorkspaceBuildFile() throws Exception {
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        IProject cnf = wsroot.getProject("cnf");
        if (cnf == null || !cnf.isAccessible()) {
            return null;
        }
        return cnf.getFile("build.bnd");
    }

    public static PromiseFactory promiseFactory() {
        return Processor.getPromiseFactory();
    }

    private static File getWorkspaceDirectory() throws CoreException {
        IWorkspaceRoot eclipseWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IProject cnfProject = eclipseWorkspace.getProject("cnf");
        if (cnfProject.exists()) {
            if (!cnfProject.isOpen()) {
                cnfProject.open(null);
            }
            return cnfProject.getLocation().toFile().getParentFile();
        }
        return null;
    }

    public static boolean isWorkspace(File directory) {
        File build = new File(directory, "cnf/build.bnd");
        return build.isFile();
    }

    public static boolean hasWorkspaceDirectory() {
        try {
            return Central.getWorkspaceDirectory() != null;
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean isChangeDelta(IResourceDelta delta) {
        if (131072 == delta.getFlags()) {
            return false;
        }
        return (delta.getKind() & 7) != 0;
    }

    public void changed(Project model) {
        model.setChanged();
        for (ModelListener m : listeners) {
            try {
                m.modelChanged(model);
            }
            catch (Exception e) {
                ILog.get().error("While notifying ModelListener " + String.valueOf(m) + " of change to project " + String.valueOf(model), (Throwable)e);
            }
        }
    }

    public void addModelListener(ModelListener m) {
        if (!listeners.contains(m)) {
            listeners.add(m);
        }
    }

    public void removeModelListener(ModelListener m) {
        listeners.remove(m);
    }

    public static IJavaProject getJavaProject(Project model) {
        return Central.getProject(model).map(JavaCore::create).filter(IJavaElement::exists).orElse(null);
    }

    public static Optional<IProject> getProject(Project model) {
        String name = model.getName();
        return Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(p -> p.getName().equals(name)).findFirst();
    }

    public static IPath toPath(File file, Workspace workspace) throws Exception {
        File absolute = file.getCanonicalFile();
        return Central.toFullPath(absolute).orElseGet(() -> {
            if (workspace != null) {
                try {
                    String workspacePath = workspace.getBase().getAbsolutePath();
                    String absolutePath = absolute.getPath();
                    if (absolutePath.startsWith(workspacePath)) {
                        return new Path(absolutePath.substring(workspacePath.length()));
                    }
                    return null;
                }
                catch (Exception e) {
                    throw Exceptions.duck((Throwable)e);
                }
            }
            return null;
        });
    }

    public static IPath toPathMustBeInEclipseWorkspace(File file) throws Exception {
        File absolute = file.getCanonicalFile();
        return Central.toFullPath(absolute).orElse(null);
    }

    private static Optional<IPath> toFullPath(File file) {
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] candidates = wsroot.findFilesForLocationURI(file.toURI());
        return Stream.of(candidates).map(IFile::getFullPath).min((a, b) -> Integer.compare(a.segmentCount(), b.segmentCount()));
    }

    public static Optional<IPath> toBestPath(IResource resource) {
        return Optional.ofNullable(resource.getLocationURI()).map(File::new).flatMap(Central::toFullPath);
    }

    public static void refresh(IPath path) {
        try {
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (r != null) {
                return;
            }
            IPath p = (IPath)path.clone();
            while (p.segmentCount() > 0) {
                p = p.removeLastSegments(1);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(p);
                if (resource == null) continue;
                resource.refreshLocal(2, null);
                return;
            }
        }
        catch (Exception e) {
            ILog.get().error("While refreshing path " + String.valueOf(path), (Throwable)e);
        }
    }

    public static void refreshPlugins(Workspace workspace) throws Exception {
        if (workspace == null) {
            return;
        }
        ArrayList<File> refreshedFiles = new ArrayList<File>();
        List rps = workspace.getPlugins(Refreshable.class);
        boolean changed = false;
        boolean repoChanged = false;
        for (Refreshable rp : rps) {
            if (!rp.refresh()) continue;
            changed = true;
            File root = rp.getRoot();
            if (root != null) {
                refreshedFiles.add(root);
            }
            if (!(rp instanceof RepositoryPlugin)) continue;
            repoChanged = true;
        }
        if (changed) {
            for (File file : refreshedFiles) {
                Central.refreshFile(file);
            }
            if (repoChanged) {
                RepositoriesViewRefresher.refreshRepositories(null);
            }
            Central.refreshProjects(workspace);
        }
    }

    public static void refreshPlugin(Workspace workspace, Refreshable plugin) throws Exception {
        Central.refreshPlugin(workspace, plugin, false);
    }

    public static void refreshPlugin(Workspace workspace, Refreshable plugin, boolean force) throws Exception {
        boolean refresh = plugin.refresh();
        if (refresh || force) {
            Central.refreshFile(plugin.getRoot());
            if (plugin instanceof RepositoryPlugin) {
                RepositoriesViewRefresher.refreshRepositories((RepositoryPlugin)plugin);
            }
            Central.refreshProjects(workspace);
        }
    }

    public static void refreshProjects(Workspace workspace) throws Exception {
        if (workspace == null) {
            return;
        }
        Collection allProjects = workspace.getAllProjects();
        for (Project p : allProjects) {
            p.setChanged();
        }
        for (Project p : allProjects) {
            for (ModelListener m : listeners) {
                try {
                    m.modelChanged(p);
                }
                catch (Exception e) {
                    ILog.get().error("While notifying ModelListener " + String.valueOf(m) + " of change to project " + String.valueOf(p), (Throwable)e);
                }
            }
        }
    }

    public static void refreshFile(File f) throws CoreException {
        Central.refreshFile(f, null, false);
    }

    public static void refreshFile(File file, IProgressMonitor monitor, boolean derived) throws CoreException {
        int depth;
        IResource target = Central.toResource(file);
        if (target == null) {
            return;
        }
        int n = depth = target.getType() == 1 ? 0 : 2;
        if (!target.isSynchronized(depth)) {
            target.refreshLocal(depth, monitor);
            if (target.exists() && target.isDerived() != derived) {
                target.setDerived(derived, monitor);
            }
        }
    }

    public static void refresh(Project p) throws Exception {
        IJavaProject jp = Central.getJavaProject(p);
        if (jp != null) {
            jp.getProject().refreshLocal(2, null);
        }
    }

    public static Project getProject(Workspace workspace, File projectDir) throws Exception {
        return workspace.getProjectFromFile(projectDir);
    }

    public static Project getProject(Workspace workspace, IProject p) throws Exception {
        return Optional.ofNullable(p.getLocation()).map(IPath::toFile).map(FunctionWithException.asFunction(f -> Central.getProject(workspace, f))).orElse(null);
    }

    public static boolean isBndProject(IProject project) {
        return Optional.ofNullable(project).map(FunctionWithException.asFunction(p -> p.getNature(BNDTOOLS_NATURE))).isPresent();
    }

    public static IResource toResource(File file) {
        if (file == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return Central.toFullPath(file).map(p -> file.isDirectory() ? root.getFolder(p) : root.getFile(p)).orElse(null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> V bndCall(BiFunctionWithException<Callable<V>, BooleanSupplier, V> lockMethod, FunctionWithException<BiConsumer<String, RunnableWithException>, V> callable, IProgressMonitor monitorOrNull) throws Exception {
        monitor = monitorOrNull == null ? new NullProgressMonitor() : monitorOrNull;
        task = new ProgressPlugin.Task(){

            public void worked(int units) {
                monitor.worked(units);
            }

            public void done(String message, Throwable e) {
            }

            public boolean isCanceled() {
                return monitor.isCanceled();
            }

            public void abort() {
                monitor.setCanceled(true);
            }
        };
        after = new ArrayList<E>();
        status = new MultiStatus(Central.class, 0, "Errors occurred while calling bndCall after actions");
        try {
            with = (Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$12(aQute.bnd.exceptions.FunctionWithException java.util.List org.eclipse.core.runtime.IProgressMonitor org.eclipse.core.runtime.MultiStatus aQute.bnd.service.progress.ProgressPlugin$Task ), ()Ljava/lang/Object;)(callable, after, (IProgressMonitor)monitor, (MultiStatus)status, (ProgressPlugin.Task)task);
            var10_8 = lockMethod.apply(with, (Object)(BooleanSupplier)LambdaMetafactory.metafactory(null, null, null, ()Z, isCanceled(), ()Z)((IProgressMonitor)monitor));
            return (V)var10_8;
        }
        finally {
            ** for (runnable : after)
        }
lbl-1000:
        // 1 sources

        {
            runnable.run();
            continue;
        }
lbl16:
        // 1 sources

        if (status.isOK() != false) return (V)var10_8;
        throw new CoreException((IStatus)status);
    }

    public static IStatus toStatus(Processor processor, String message) {
        Status status;
        int severity = 1;
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String error : processor.getErrors()) {
            status = new Status(4, "bndtools.core", error);
            statuses.add(status);
            severity = 4;
        }
        for (String warning : processor.getWarnings()) {
            status = new Status(2, "bndtools.core", warning);
            statuses.add(status);
            severity = 2;
        }
        IStatus[] array = statuses.toArray(new IStatus[0]);
        return new MultiStatus("bndtools.core", severity, array, message, null);
    }

    public static boolean refreshFiles(Reporter reporter, Collection<File> files, IProgressMonitor monitor, boolean derived) {
        AtomicInteger errors = new AtomicInteger();
        files.forEach(t -> {
            try {
                Central.refreshFile(t, monitor, derived);
            }
            catch (CoreException e) {
                errors.incrementAndGet();
                if (reporter != null) {
                    reporter.error("failed to refresh %s : %s", new Object[]{t, Exceptions.causes((Throwable)e)});
                }
                throw Exceptions.duck((Throwable)e);
            }
        });
        return errors.get() == 0;
    }

    private static /* synthetic */ Object lambda$12(FunctionWithException functionWithException, List list, IProgressMonitor iProgressMonitor, MultiStatus multiStatus, ProgressPlugin.Task task) throws Exception {
        return TaskManager.with((ProgressPlugin.Task)task, () -> functionWithException.apply((name, runnable) -> {
            boolean bl = list.add(() -> {
                block2: {
                    iProgressMonitor.subTask(name);
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        if (e instanceof OperationCanceledException) break block2;
                        multiStatus.add((IStatus)new Status(4, runnable.getClass(), "Unexpected exception in bndCall after action: " + name, (Throwable)e));
                    }
                }
            });
        }));
    }
}

