/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.net4j.internal.util.factory.MarkupNames;
import org.eclipse.net4j.internal.util.factory.PluginFactoryRegistry;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.FactoryCreationException;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;

public final class FactoryDescriptor
extends Factory
implements PluginFactoryRegistry.IFactoryDescriptor,
MarkupNames {
    private final IConfigurationElement configurationElement;

    public FactoryDescriptor(IConfigurationElement configurationElement) {
        super(FactoryDescriptor.createFactoryKey(configurationElement));
        this.configurationElement = configurationElement;
    }

    @Override
    public IFactory createFactory() {
        try {
            IConfigurationElement element = this.configurationElement;
            String name = element.getName();
            if ("type".equals(name)) {
                element = (IConfigurationElement)element.getParent();
            }
            IFactory factory = (IFactory)element.createExecutableExtension("class");
            FactoryDescriptor.adjustFactoryType(factory, this.getType());
            return factory;
        }
        catch (CoreException ex) {
            throw new FactoryCreationException(ex);
        }
    }

    public static void adjustFactoryType(IFactory factory, String type) {
        IFactoryKey key = factory.getKey();
        if (key instanceof FactoryKey && key.getType() == null) {
            ((FactoryKey)key).setType(type);
        }
    }

    private static IFactoryKey createFactoryKey(IConfigurationElement element) {
        String name = element.getName();
        if ("factory".equals(name)) {
            String productGroup = element.getAttribute("productGroup");
            String type = element.getAttribute("type");
            return new FactoryKey(productGroup, type);
        }
        if ("type".equals(name)) {
            IConfigurationElement parent = (IConfigurationElement)element.getParent();
            String productGroup = parent.getAttribute("productGroup");
            String value = element.getAttribute("value");
            return new FactoryKey(productGroup, value);
        }
        throw new IllegalStateException("Wrong configuration element: " + name);
    }
}

