/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.internal.wikitext.ui.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.Templates;
import org.eclipse.mylyn.internal.wikitext.ui.editor.help.CheatSheetContent;
import org.eclipse.mylyn.internal.wikitext.ui.editor.help.HelpContent;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.internal.wikitext.ui.registry.EclipseServiceLocator;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.mylyn.wikitext.util.ServiceLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WikiTextUiPlugin
extends AbstractUIPlugin {
    private static final String EXTENSION_POINT_CHEAT_SHEET = "cheatSheet";
    private static final String EXTENSION_POINT_CONTENT_ASSIST = "contentAssist";
    private static final String EXTENSION_POINT_TEMPLATES = "templates";
    private static final String EXTENSION_POINT_TEMPLATE = "template";
    private static final String EXTENSION_POINT_RELATIVE_FILE_PATH_HYPERLINK_DECTOR = "relativeFilePathHyperlinkDetector";
    private static final String EXTENSION_POINT_FILE_REF_REGEX = "regularExpression";
    private static WikiTextUiPlugin plugin;
    private SortedMap<String, HelpContent> cheatSheets;
    private Map<String, Templates> templates;
    private Preferences preferences;
    private IPropertyChangeListener preferencesListener;
    private Map<String, List<String>> fileRefRegexes;

    public WikiTextUiPlugin() {
        plugin = this;
        ServiceLocator.setImplementation(EclipseServiceLocator.class);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.preferencesListener = event -> {
            Preferences preferences = this.preferences = null;
        };
        this.getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.preferencesListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
            this.preferencesListener = null;
        }
        super.stop(context);
    }

    public static WikiTextUiPlugin getDefault() {
        return plugin;
    }

    public void log(Throwable e) {
        if (e instanceof CoreException) {
            CoreException ce = (CoreException)e;
            this.getLog().log(ce.getStatus());
        } else {
            this.log(4, e.getMessage(), e);
        }
    }

    public void log(int severity, String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        ILog log = this.getLog();
        IStatus status = null;
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            status = ce.getStatus();
        }
        if (status == null) {
            status = new Status(severity, this.getPluginId(), severity, message, exception);
        }
        log.log(status);
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    public IStatus createStatus(int statusCode, Throwable exception) {
        return this.createStatus(null, statusCode, exception);
    }

    public IStatus createStatus(String message, int statusCode, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getClass().getName() + ": " + exception.getMessage();
        }
        return new Status(statusCode, this.getPluginId(), statusCode, (String)message, exception);
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            Preferences prefs = new Preferences();
            prefs.load(this.getPreferenceStore());
            prefs.makeImmutable();
            this.preferences = prefs;
        }
        return this.preferences;
    }

    public SortedMap<String, HelpContent> getCheatSheets() {
        if (this.cheatSheets == null) {
            TreeMap<String, HelpContent> cheatSheets = new TreeMap<String, HelpContent>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPluginId(), EXTENSION_POINT_CHEAT_SHEET);
            if (extensionPoint != null) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String declaringPluginId = element.getDeclaringExtension().getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)declaringPluginId);
                    String markupLanguage = element.getAttribute("markupLanguage");
                    String contentLanguage = element.getAttribute("contentLanguage");
                    String resource = element.getAttribute("resource");
                    try {
                        if (markupLanguage == null) {
                            throw new Exception(Messages.WikiTextUiPlugin_markupLanguageRequired);
                        }
                        if (!WikiText.getMarkupLanguageNames().contains(markupLanguage)) {
                            throw new Exception(NLS.bind((String)Messages.WikiTextUiPlugin_invalidMarkupLanguage, (Object[])new Object[]{markupLanguage}));
                        }
                        if (resource == null || resource.length() == 0) {
                            throw new Exception(Messages.WikiTextUiPlugin_resourceRequired);
                        }
                        CheatSheetContent cheatSheet = new CheatSheetContent(bundle, resource, contentLanguage, markupLanguage);
                        HelpContent previous = cheatSheets.put(cheatSheet.getMarkupLanguageName(), cheatSheet);
                        if (previous != null) {
                            cheatSheets.put(previous.getMarkupLanguageName(), previous);
                            throw new Exception(NLS.bind((String)Messages.WikiTextUiPlugin_markupLanguageContentAlreadyDeclared, (Object[])new Object[]{previous.getMarkupLanguageName(), previous.getProvider().getSymbolicName()}));
                        }
                    }
                    catch (Exception e) {
                        this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_invalidExtension, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_CHEAT_SHEET, e.getMessage()}), e);
                    }
                    ++n2;
                }
            }
            this.cheatSheets = Collections.unmodifiableSortedMap(cheatSheets);
        }
        return this.cheatSheets;
    }

    public Map<String, Templates> getTemplates() {
        if (this.templates == null) {
            HashMap<String, Templates> templates = new HashMap<String, Templates>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPluginId(), EXTENSION_POINT_CONTENT_ASSIST);
            if (extensionPoint != null) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String declaringPluginId = element.getDeclaringExtension().getContributor().getName();
                    if (EXTENSION_POINT_TEMPLATES.equals(element.getName())) {
                        try {
                            String markupLanguage = element.getAttribute("markupLanguage");
                            if (markupLanguage == null) {
                                throw new Exception(Messages.WikiTextUiPlugin_markupLanguageRequired);
                            }
                            if (!WikiText.getMarkupLanguageNames().contains(markupLanguage)) {
                                throw new Exception(NLS.bind((String)Messages.WikiTextUiPlugin_invalidMarkupLanguage, (Object[])new Object[]{markupLanguage}));
                            }
                            Templates markupLanguageTemplates = new Templates();
                            markupLanguageTemplates.setMarkupLanguageName(markupLanguage);
                            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                            int n3 = iConfigurationElementArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IConfigurationElement templatesChild = iConfigurationElementArray2[n4];
                                if (EXTENSION_POINT_TEMPLATE.equals(templatesChild.getName())) {
                                    try {
                                        String name = templatesChild.getAttribute("name");
                                        String description = templatesChild.getAttribute("description");
                                        String content = templatesChild.getAttribute("content");
                                        String autoInsert = templatesChild.getAttribute("autoInsert");
                                        String block = templatesChild.getAttribute("block");
                                        if (name == null || name.length() == 0) {
                                            throw new Exception(NLS.bind((String)Messages.WikiTextUiPlugin_nameRequired, (Object[])new Object[]{EXTENSION_POINT_TEMPLATE}));
                                        }
                                        if (description == null || description.length() == 0) {
                                            throw new Exception(NLS.bind((String)Messages.WikiTextUiPlugin_descriptionRequired, (Object[])new Object[]{EXTENSION_POINT_TEMPLATE}));
                                        }
                                        if (content == null || content.length() == 0) {
                                            throw new Exception(NLS.bind((String)Messages.WikiTextUiPlugin_contentRequired, (Object[])new Object[]{EXTENSION_POINT_TEMPLATE}));
                                        }
                                        content = content.replace("\\t", "\t");
                                        if ((content = content.replace("\\r\\n", Text.DELIMITER).replace("\\r", Text.DELIMITER).replace("\\n", Text.DELIMITER).replace("\\\\", "\\")).endsWith("$") && !content.endsWith("\\$") && !content.endsWith("$$")) {
                                            content = content.substring(0, content.length() - 1);
                                        }
                                        if (content.startsWith("^")) {
                                            content = content.substring(1);
                                        }
                                        content = content.replace("\\$", "$$");
                                        markupLanguageTemplates.addTemplate(new Template(name, description, "org.eclipse.mylyn.wikitext.ui.editor", content, autoInsert == null || !"false".equalsIgnoreCase(autoInsert)), block != null && "true".equalsIgnoreCase(block));
                                    }
                                    catch (Exception e) {
                                        this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_invalidExtension, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_CONTENT_ASSIST, e.getMessage()}), e);
                                    }
                                } else {
                                    this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_unexpectedExtensionElement, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_CONTENT_ASSIST, templatesChild.getName()}), null);
                                }
                                ++n4;
                            }
                            Templates previous = templates.put(markupLanguageTemplates.getMarkupLanguageName(), markupLanguageTemplates);
                            if (previous != null) {
                                markupLanguageTemplates.addAll(previous);
                            }
                        }
                        catch (Exception e) {
                            this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_invalidExtension, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_TEMPLATES, e.getMessage()}), e);
                        }
                    } else {
                        this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_unexpectedExtensionElement, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_CONTENT_ASSIST, element.getName()}), null);
                    }
                    ++n2;
                }
            }
            Set<String> languageNames = WikiText.getMarkupLanguageNames();
            for (String languageName : languageNames) {
                Templates languageTemplates = (Templates)templates.get(languageName);
                if (languageTemplates != null) continue;
                languageTemplates = new Templates();
                templates.put(languageName, languageTemplates);
            }
            for (String languageName : languageNames) {
                MarkupLanguage markupLanguage = WikiText.getMarkupLanguage(languageName);
                if (markupLanguage == null || markupLanguage.getExtendsLanguage() == null) continue;
                Templates languageTemplates = (Templates)templates.get(languageName);
                Templates parentLanguageTemplates = (Templates)templates.get(markupLanguage.getExtendsLanguage());
                languageTemplates.setParent(parentLanguageTemplates);
            }
            this.templates = Collections.unmodifiableMap(templates);
        }
        return this.templates;
    }

    public Map<String, List<String>> getHyperlinkDectectorFileRefRegexes() {
        if (this.fileRefRegexes == null) {
            ImmutableMap.Builder markupLanguageToFileRefRegexes = ImmutableMap.builder();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPluginId(), EXTENSION_POINT_RELATIVE_FILE_PATH_HYPERLINK_DECTOR);
            if (extensionPoint != null) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String declaringPluginId = element.getDeclaringExtension().getContributor().getName();
                    if (EXTENSION_POINT_RELATIVE_FILE_PATH_HYPERLINK_DECTOR.equals(element.getName())) {
                        try {
                            String markupLanguage = this.validateAndGetMarkupLanguage(element);
                            List<String> regexes = this.createFielRefRegexes(element, declaringPluginId);
                            markupLanguageToFileRefRegexes.put((Object)markupLanguage, regexes);
                        }
                        catch (Exception e) {
                            this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_invalidExtension, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_RELATIVE_FILE_PATH_HYPERLINK_DECTOR, e.getMessage()}), e);
                        }
                    } else {
                        this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_unexpectedExtensionElement, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_RELATIVE_FILE_PATH_HYPERLINK_DECTOR, element.getName()}), null);
                    }
                    ++n2;
                }
            }
            this.fileRefRegexes = markupLanguageToFileRefRegexes.build();
        }
        return this.fileRefRegexes;
    }

    private List<String> createFielRefRegexes(IConfigurationElement element, String declaringPluginId) {
        ImmutableList.Builder regexes = new ImmutableList.Builder();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement fileRefRegexesChild = iConfigurationElementArray[n2];
            if (EXTENSION_POINT_FILE_REF_REGEX.equals(fileRefRegexesChild.getName())) {
                try {
                    String fileRefRegex = fileRefRegexesChild.getAttribute(EXTENSION_POINT_FILE_REF_REGEX);
                    regexes.add((Object)fileRefRegex);
                }
                catch (Exception e) {
                    this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_invalidExtension, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_RELATIVE_FILE_PATH_HYPERLINK_DECTOR, e.getMessage()}), e);
                }
            } else {
                this.log(4, NLS.bind((String)Messages.WikiTextUiPlugin_unexpectedExtensionElement, (Object[])new Object[]{declaringPluginId, EXTENSION_POINT_RELATIVE_FILE_PATH_HYPERLINK_DECTOR, fileRefRegexesChild.getName()}), null);
            }
            ++n2;
        }
        return regexes.build();
    }

    private String validateAndGetMarkupLanguage(IConfigurationElement element) throws Exception {
        String markupLanguage = element.getAttribute("markupLanguage");
        if (markupLanguage == null) {
            throw new Exception(Messages.WikiTextUiPlugin_markupLanguageRequired);
        }
        if (!WikiText.getMarkupLanguageNames().contains(markupLanguage)) {
            throw new Exception(NLS.bind((String)Messages.WikiTextUiPlugin_invalidMarkupLanguage, (Object[])new Object[]{markupLanguage}));
        }
        return markupLanguage;
    }
}

