/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.wizards.choosers;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.ChooserNode;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.ChooserNodeContentProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.EPackageDecoratingLabelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.EPackageSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class TreeChooserPage
extends WizardPage {
    private final boolean myUseCheckboxes;
    private AbstractTreeViewer myViewer;
    private final String myHelpId;
    private final String myTitle;
    private static final ITreeContentProvider CONTENT_PROVIDER = new ChooserNodeContentProvider();
    private static final ILabelProvider LABEL_PROVIDER = new EPackageDecoratingLabelProvider();
    private static final ViewerSorter VIEWER_SORTER = new EPackageSorter();

    public TreeChooserPage(String pageId, String title, boolean useCheckboxes, String helpId) {
        super(pageId);
        this.myTitle = title;
        this.myHelpId = helpId;
        this.myUseCheckboxes = useCheckboxes;
    }

    protected abstract boolean validatePage();

    protected AbstractTreeViewer createViewer(Composite parent, int style) {
        return new TreeViewer(parent, style);
    }

    protected abstract ChooserNode[] getTreeRoots();

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label firstLabel = new Label(composite, 16384);
        firstLabel.setText(this.myTitle);
        int style = 2820;
        this.myViewer = this.createViewer(composite, style);
        if (this.myViewer.getContentProvider() == null) {
            this.myViewer.setContentProvider((IContentProvider)CONTENT_PROVIDER);
        }
        if (this.myViewer.getSorter() == null) {
            this.myViewer.setSorter(VIEWER_SORTER);
        }
        if (this.myViewer.getLabelProvider() == null) {
            this.myViewer.setLabelProvider((IBaseLabelProvider)LABEL_PROVIDER);
        }
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.myViewer.getControl().setLayoutData((Object)data);
        if (this.myViewer.getInput() == null) {
            this.myViewer.setInput((Object)this.getTreeRoots());
        }
        this.setupViewer(this.myViewer);
        this.setControl((Control)composite);
        this.setPageComplete(this.validatePage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.myHelpId);
    }

    protected void setupViewer(AbstractTreeViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeChooserPage.this.setPageComplete(TreeChooserPage.this.validatePage());
                if (TreeChooserPage.this.isCurrentPage()) {
                    TreeChooserPage.this.getContainer().updateButtons();
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.myViewer.getControl().setFocus();
        }
    }

    public ISelection getSelection() {
        return this.myViewer.getSelection();
    }

    public boolean isUseCheckboxes() {
        return this.myUseCheckboxes;
    }

    protected AbstractTreeViewer getViewer() {
        return this.myViewer;
    }
}

