/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaElementsAdapterFactory
implements IAdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(JavaElementsAdapterFactory.class);
    private static final Class<?>[] ADAPTER_LIST = new Class[]{ArtifactKey.class, IPath.class, IMavenProjectFacade.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        Object object;
        if (adapterType == ArtifactKey.class) {
            Object object2 = adaptableObject;
            if (object2 instanceof IPackageFragmentRoot) {
                void fragment;
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object2;
                IPackageFragmentRoot cfr_ignored_0 = (IPackageFragmentRoot)object2;
                IProject project = fragment.getJavaProject().getProject();
                if (project.isAccessible() && fragment.isArchive()) {
                    try {
                        return adapterType.cast(this.getBuildPathManager().findArtifact(project, fragment.getPath()));
                    }
                    catch (CoreException ex) {
                        log.error("Can't find artifact for " + String.valueOf(fragment), (Throwable)ex);
                        return null;
                    }
                }
            } else {
                Object object3 = adaptableObject;
                if (object3 instanceof IJavaProject) {
                    void javaProject;
                    IJavaProject project = (IJavaProject)object3;
                    IJavaProject cfr_ignored_1 = (IJavaProject)object3;
                    return adapterType.cast(javaProject.getProject().getAdapter(ArtifactKey.class));
                }
            }
        } else if (adapterType == IPath.class) {
            Object object4 = adaptableObject;
            if (object4 instanceof IJavaElement) {
                void javaElement;
                IJavaElement fragment = (IJavaElement)object4;
                IJavaElement cfr_ignored_2 = (IJavaElement)object4;
                IResource resource = javaElement.getResource();
                if (resource != null) {
                    return adapterType.cast(resource.getLocation());
                }
            }
        } else if (adapterType == IMavenProjectFacade.class && (object = adaptableObject) instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)object;
            IJavaElement cfr_ignored_3 = (IJavaElement)object;
            IProject project = javaElement.getJavaProject().getProject();
            IMavenProjectFacade projectFacade = this.getProjectFacade(project);
            if (projectFacade != null) {
                return adapterType.cast(projectFacade);
            }
        }
        return null;
    }

    private BuildPathManager getBuildPathManager() {
        return (BuildPathManager)MavenJdtPlugin.getDefault().getBuildpathManager();
    }

    private IMavenProjectFacade getProjectFacade(IProject project) {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        return projectManager.create(project, (IProgressMonitor)new NullProgressMonitor());
    }
}

