/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.jdt.JreSystemVersion;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.ClasspathDescriptor;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.Messages;
import org.eclipse.m2e.jdt.internal.ModuleSupport;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaProjectConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    private static final IPath[] DEFAULT_INCLUSIONS = new IPath[0];
    private static final Logger log = LoggerFactory.getLogger(AbstractJavaProjectConfigurator.class);
    private static final String GOAL_COMPILE = "compile";
    private static final String GOAL_TESTCOMPILE = "testCompile";
    public static final String COMPILER_PLUGIN_ARTIFACT_ID = "maven-compiler-plugin";
    public static final String COMPILER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    protected static final List<String> RELEASES;
    protected static final List<String> SOURCES;
    protected static final List<String> TARGETS;
    private static final String GOAL_RESOURCES = "resources";
    private static final String GOAL_TESTRESOURCES = "testResources";
    private static final String RESOURCES_PLUGIN_ARTIFACT_ID = "maven-resources-plugin";
    private static final String RESOURCES_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    protected static final LinkedHashMap<String, String> ENVIRONMENTS;
    protected static final String DEFAULT_COMPILER_LEVEL = "1.5";
    private static final QualifiedName LINKED_MAVEN_RESOURCE;

    static {
        ENVIRONMENTS = new LinkedHashMap();
        Set<String> supportedExecutionEnvironmentTypes = Set.of("J2SE", "JavaSE");
        ArrayList<String> sources = new ArrayList<String>();
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("jsr14");
        ENVIRONMENTS.put("jsr14", "J2SE-1.5");
        ArrayList<String> releases = new ArrayList<String>(List.of("6", "7", "8"));
        IExecutionEnvironment[] iExecutionEnvironmentArray = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int n = iExecutionEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            String compliance;
            Map complianceOptions;
            IExecutionEnvironment ee = iExecutionEnvironmentArray[n2];
            String eeId = ee.getId();
            if (!supportedExecutionEnvironmentTypes.stream().noneMatch(eeId::startsWith) && (complianceOptions = ee.getComplianceOptions()) != null && (compliance = (String)complianceOptions.get("org.eclipse.jdt.core.compiler.compliance")) != null) {
                sources.add(compliance);
                targets.add(compliance);
                if ("enabled".equals(complianceOptions.get("org.eclipse.jdt.core.compiler.release"))) {
                    releases.add(compliance);
                }
                ENVIRONMENTS.put(compliance, eeId);
            }
            ++n2;
        }
        SOURCES = Collections.unmodifiableList(sources);
        TARGETS = Collections.unmodifiableList(targets);
        RELEASES = Collections.unmodifiableList(releases);
        LINKED_MAVEN_RESOURCE = new QualifiedName("org.eclipse.m2e.jdt", "linkedSource");
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.mavenProjectFacade().getProject();
        monitor.setTaskName(Messages.AbstractJavaProjectConfigurator_task_name + project.getName());
        this.addJavaNature(project, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        HashMap<String, String> options = new HashMap<String, String>();
        this.addJavaProjectOptions(options, request, monitor);
        ClasspathDescriptor classpath = new ClasspathDescriptor(javaProject);
        this.addProjectSourceFolders(classpath, options, request, monitor);
        String executionEnvironmentId = this.getExecutionEnvironmentId(options);
        this.addJREClasspathContainer(classpath, executionEnvironmentId);
        this.addMavenClasspathContainer(classpath);
        this.addCustomClasspathEntries(javaProject, classpath);
        IContainer classesFolder = this.getOutputLocation(request, project);
        javaProject.setRawClasspath(classpath.getEntries(), classesFolder.getFullPath(), monitor);
        this.invokeJavaProjectConfigurators(classpath, request, monitor);
        for (Map.Entry option : options.entrySet()) {
            javaProject.setOption((String)option.getKey(), (String)option.getValue());
        }
        javaProject.setRawClasspath(classpath.getEntries(), classesFolder.getFullPath(), monitor);
        MavenJdtPlugin.getDefault().getBuildpathManager().updateClasspath(project, monitor);
    }

    protected IContainer getOutputLocation(ProjectConfigurationRequest request, IProject project) throws CoreException {
        MavenProject mavenProject = request.mavenProject();
        return this.getFolder(project, mavenProject.getBuild().getOutputDirectory());
    }

    protected String getExecutionEnvironmentId(Map<String, String> options) {
        return ENVIRONMENTS.get(options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
    }

    protected void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        AbstractJavaProjectConfigurator.addNature((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
    }

    protected void addCustomClasspathEntries(IJavaProject javaProject, IClasspathDescriptor classpath) {
    }

    /*
     * WARNING - void declaration
     */
    protected void invokeJavaProjectConfigurators(IClasspathDescriptor classpath, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        ILifecycleMapping lifecycleMapping = configurationManager.getLifecycleMapping(facade);
        if (lifecycleMapping == null) {
            return;
        }
        for (AbstractProjectConfigurator configurator : lifecycleMapping.getProjectConfigurators(facade, monitor)) {
            void javaConfigurator;
            AbstractProjectConfigurator abstractProjectConfigurator = configurator;
            if (!(abstractProjectConfigurator instanceof IJavaProjectConfigurator)) continue;
            IJavaProjectConfigurator cfr_ignored_0 = (IJavaProjectConfigurator)abstractProjectConfigurator;
            IJavaProjectConfigurator cfr_ignored_1 = (IJavaProjectConfigurator)abstractProjectConfigurator;
            javaConfigurator.configureRawClasspath(request, classpath, monitor);
        }
    }

    protected void addJREClasspathContainer(IClasspathDescriptor classpath, String environmentId) {
        IClasspathAttribute[] externalAnnotations;
        IExecutionEnvironment executionEnvironment = this.getExecutionEnvironment(environmentId);
        IPath containerPath = executionEnvironment == null ? JavaRuntime.newDefaultJREContainerPath() : JavaRuntime.newJREContainerPath((IExecutionEnvironment)executionEnvironment);
        IClasspathEntry cpe = MavenClasspathHelpers.newContainerEntry(containerPath, externalAnnotations = AbstractJavaProjectConfigurator.readExternalAnnotationAttributes(classpath, p -> JavaRuntime.JRE_CONTAINER.equals(p.getPath().segment(0))));
        IClasspathEntryDescriptor cped = classpath.replaceEntry(descriptor -> JavaRuntime.JRE_CONTAINER.equals(descriptor.getPath().segment(0)), cpe);
        if (cped == null) {
            classpath.addEntry(cpe);
        }
    }

    private IExecutionEnvironment getExecutionEnvironment(String environmentId) {
        if (environmentId == null || JreSystemVersion.WORKSPACE_DEFAULT == MavenJdtPlugin.getDefault().getJreSystemVersion()) {
            return null;
        }
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment environment = manager.getEnvironment(environmentId);
        if (environment != null && environment.getCompatibleVMs().length > 0) {
            return environment;
        }
        log.error("Failed to find a compatible VM for environment id '{}', falling back to workspace default", (Object)environmentId);
        return null;
    }

    protected void addMavenClasspathContainer(IClasspathDescriptor classpath) {
        List<IClasspathEntryDescriptor> descriptors = classpath.getEntryDescriptors();
        ArrayList<IAccessRule> accessRules = new ArrayList<IAccessRule>();
        boolean isExported = false;
        for (IClasspathEntryDescriptor descriptor : descriptors) {
            if (!MavenClasspathHelpers.isMaven2ClasspathContainer(descriptor.getPath())) continue;
            isExported = descriptor.isExported();
            List<IAccessRule> previousAccessRules = descriptor.getAccessRules();
            if (previousAccessRules == null) break;
            accessRules.addAll(previousAccessRules);
            break;
        }
        IClasspathAttribute[] externalAnnotations = AbstractJavaProjectConfigurator.readExternalAnnotationAttributes(classpath, p -> MavenClasspathHelpers.MAVEN_CLASSPATH_CONTAINER_PATH.equals((Object)p.getPath()));
        IClasspathEntry cpe = MavenClasspathHelpers.getDefaultContainerEntry(externalAnnotations);
        IClasspathEntryDescriptor entryDescriptor = classpath.addEntry(cpe);
        entryDescriptor.setExported(isExported);
        for (IAccessRule accessRule : accessRules) {
            entryDescriptor.addAccessRule(accessRule);
        }
    }

    /*
     * Exception decompiling
     */
    private static IClasspathAttribute[] readExternalAnnotationAttributes(IClasspathDescriptor classpath, Predicate<IClasspathEntryDescriptor> annotationSourceEntry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void addProjectSourceFolders(IClasspathDescriptor classpath, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        this.addProjectSourceFolders(classpath, new HashMap<String, String>(), request, monitor);
    }

    protected void addProjectSourceFolders(IClasspathDescriptor classpath, Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        block25: {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
            try {
                boolean addTestFlag;
                ArrayList<Boolean> isTestResourcesSkipped;
                String testResourcesEncoding;
                IContainer testClasses;
                MavenProject mavenProject;
                IProject project;
                block27: {
                    String testSourceEncoding;
                    IPath[] exclusionTest;
                    IPath[] inclusionTest;
                    block26: {
                        project = request.mavenProjectFacade().getProject();
                        mavenProject = request.mavenProject();
                        IMavenProjectFacade projectFacade = request.mavenProjectFacade();
                        IContainer classes = this.getFolder(project, mavenProject.getBuild().getOutputDirectory());
                        testClasses = this.getFolder(project, mavenProject.getBuild().getTestOutputDirectory());
                        M2EUtils.createFolder((IContainer)classes, (boolean)true, (IProgressMonitor)mon.newChild(1));
                        M2EUtils.createFolder((IContainer)testClasses, (boolean)true, (IProgressMonitor)mon.newChild(1));
                        IPath[] inclusion = new IPath[]{};
                        IPath[] exclusion = new IPath[]{};
                        inclusionTest = new IPath[]{};
                        exclusionTest = new IPath[]{};
                        String mainSourceEncoding = null;
                        testSourceEncoding = null;
                        String mainResourcesEncoding = null;
                        testResourcesEncoding = null;
                        ArrayList<Boolean> isTestCompilationSkipped = new ArrayList<Boolean>();
                        isTestResourcesSkipped = new ArrayList<Boolean>();
                        List<MojoExecution> executions = this.getCompilerMojoExecutions(request, (IProgressMonitor)mon.newChild(1));
                        for (MojoExecution compile : executions) {
                            if (!this.isCompileExecution(compile, mavenProject, options, monitor)) continue;
                            mainSourceEncoding = (String)this.maven.getMojoParameterValue(mavenProject, compile, "encoding", String.class, monitor);
                            try {
                                inclusion = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "includes", String[].class, monitor));
                            }
                            catch (CoreException ex) {
                                log.error("Failed to determine compiler inclusions, assuming defaults", (Throwable)ex);
                            }
                            try {
                                exclusion = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "excludes", String[].class, monitor));
                            }
                            catch (CoreException ex) {
                                log.error("Failed to determine compiler exclusions, assuming defaults", (Throwable)ex);
                            }
                        }
                        for (MojoExecution compile : executions) {
                            if (!this.isTestCompileExecution(compile, mavenProject, options, monitor)) continue;
                            testSourceEncoding = (String)this.maven.getMojoParameterValue(mavenProject, compile, "encoding", String.class, monitor);
                            try {
                                inclusionTest = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "testIncludes", String[].class, monitor));
                            }
                            catch (CoreException ex) {
                                log.error("Failed to determine compiler test inclusions, assuming defaults", (Throwable)ex);
                            }
                            try {
                                exclusionTest = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "testExcludes", String[].class, monitor));
                            }
                            catch (CoreException ex) {
                                log.error("Failed to determine compiler test exclusions, assuming defaults", (Throwable)ex);
                            }
                            try {
                                isTestCompilationSkipped.add((Boolean)this.maven.getMojoParameterValue(mavenProject, compile, "skip", Boolean.class, monitor));
                            }
                            catch (Exception ex) {
                                isTestCompilationSkipped.add(Boolean.FALSE);
                            }
                        }
                        for (MojoExecution resources : projectFacade.getMojoExecutions("org.apache.maven.plugins", RESOURCES_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_RESOURCES})) {
                            mainResourcesEncoding = (String)this.maven.getMojoParameterValue(mavenProject, resources, "encoding", String.class, monitor);
                        }
                        for (MojoExecution resources : projectFacade.getMojoExecutions("org.apache.maven.plugins", RESOURCES_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_TESTRESOURCES})) {
                            testResourcesEncoding = (String)this.maven.getMojoParameterValue(mavenProject, resources, "encoding", String.class, monitor);
                            try {
                                isTestResourcesSkipped.add((Boolean)this.maven.getMojoParameterValue(mavenProject, resources, "skip", Boolean.class, monitor));
                            }
                            catch (Exception ex) {
                                isTestResourcesSkipped.add(Boolean.FALSE);
                            }
                        }
                        this.cleanLinkedSourceDirs(project, monitor);
                        this.addSourceDirs(classpath, project, mavenProject.getCompileSourceRoots(), classes.getFullPath(), inclusion, exclusion, mainSourceEncoding, (IProgressMonitor)mon.newChild(1), false);
                        this.addResourceDirs(classpath, project, mavenProject, mavenProject.getBuild().getResources(), classes.getFullPath(), mainResourcesEncoding, (IProgressMonitor)mon.newChild(1), false);
                        boolean bl = addTestFlag = !MavenClasspathHelpers.hasTestFlagDisabled(mavenProject);
                        if (isTestCompilationSkipped.isEmpty()) break block26;
                        if (isTestCompilationSkipped.stream().allMatch(Boolean.TRUE::equals)) break block27;
                    }
                    this.addSourceDirs(classpath, project, mavenProject.getTestCompileSourceRoots(), testClasses.getFullPath(), inclusionTest, exclusionTest, testSourceEncoding, (IProgressMonitor)mon.newChild(1), addTestFlag);
                }
                if (!isTestResourcesSkipped.isEmpty()) {
                    if (isTestResourcesSkipped.stream().allMatch(Boolean.TRUE::equals)) break block25;
                }
                this.addResourceDirs(classpath, project, mavenProject, mavenProject.getBuild().getTestResources(), testClasses.getFullPath(), testResourcesEncoding, (IProgressMonitor)mon.newChild(1), addTestFlag);
            }
            finally {
                mon.done();
            }
        }
    }

    protected boolean isTestCompileExecution(MojoExecution execution, MavenProject mavenProject, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        return GOAL_TESTCOMPILE.equals(execution.getGoal()) && this.isCompliant(execution, mavenProject, options, monitor);
    }

    protected boolean isCompileExecution(MojoExecution execution, MavenProject mavenProject, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        return GOAL_COMPILE.equals(execution.getGoal()) && this.isCompliant(execution, mavenProject, options, monitor);
    }

    private boolean isCompliant(MojoExecution execution, MavenProject mavenProject, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        String release = (String)this.maven.getMojoParameterValue(mavenProject, execution, "release", String.class, monitor);
        if (release != null && !this.sanitizeJavaVersion(release).equals(options.get("org.eclipse.jdt.core.compiler.compliance"))) {
            return false;
        }
        if (release == null) {
            String source = (String)this.maven.getMojoParameterValue(mavenProject, execution, "source", String.class, monitor);
            if (source != null && !this.sanitizeJavaVersion(source).equals(options.get("org.eclipse.jdt.core.compiler.source"))) {
                return false;
            }
            String target = (String)this.maven.getMojoParameterValue(mavenProject, execution, "target", String.class, monitor);
            if (target != null && !this.sanitizeJavaVersion(target).equals(options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"))) {
                return false;
            }
        }
        return true;
    }

    private IPath[] toPaths(String[] values) {
        if (values == null) {
            return new IPath[0];
        }
        IPath[] paths = new IPath[values.length];
        int i = 0;
        while (i < values.length) {
            if (values[i] != null && !"".equals(values[i].trim())) {
                paths[i] = IPath.fromOSString((String)values[i]);
            }
            ++i;
        }
        return paths;
    }

    protected void addSourceDirs(IClasspathDescriptor classpath, IProject project, List<String> sourceRoots, IPath outputPath, IPath[] inclusion, IPath[] exclusion, String sourceEncoding, IProgressMonitor monitor, boolean addTestFlag) throws CoreException {
        for (String sourceRoot : sourceRoots) {
            IClasspathEntryDescriptor enclosing;
            IContainer sourceFolder = this.getFolder(project, sourceRoot);
            if (sourceFolder == null) continue;
            sourceFolder.refreshLocal(0, monitor);
            if (sourceFolder.exists() && !sourceFolder.getProject().equals((Object)project)) continue;
            if (sourceFolder.exists() && !Objects.equals(sourceFolder.getDefaultCharset(false), sourceEncoding)) {
                sourceFolder.setDefaultCharset(sourceEncoding, monitor);
            }
            if ((enclosing = this.getEnclosingEntryDescriptor(classpath, sourceFolder.getFullPath())) == null || this.getEntryDescriptor(classpath, sourceFolder.getFullPath()) != null) {
                log.info("Adding source folder " + String.valueOf(sourceFolder.getFullPath()));
                IClasspathEntryDescriptor descriptor = classpath.addSourceEntry(sourceFolder.getFullPath(), outputPath, inclusion, exclusion, true);
                descriptor.setClasspathAttribute("test", addTestFlag ? "true" : null);
                continue;
            }
            log.info("Not adding source folder " + String.valueOf(sourceFolder.getFullPath()) + " because it overlaps with " + String.valueOf(enclosing.getPath()));
        }
    }

    private void cleanLinkedSourceDirs(IProject project, IProgressMonitor monitor) throws CoreException {
        IResource[] iResourceArray = project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFolder && "true".equals(resource.getPersistentProperty(LINKED_MAVEN_RESOURCE))) {
                resource.delete(false, monitor);
            }
            ++n2;
        }
    }

    private IClasspathEntryDescriptor getEnclosingEntryDescriptor(IClasspathDescriptor classpath, IPath fullPath) {
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (!cped.getPath().isPrefixOf(fullPath)) continue;
            return cped;
        }
        return null;
    }

    private IClasspathEntryDescriptor getEntryDescriptor(IClasspathDescriptor classpath, IPath fullPath) {
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (!cped.getPath().equals((Object)fullPath)) continue;
            return cped;
        }
        return null;
    }

    private void addResourceDirs(IClasspathDescriptor classpath, IProject project, MavenProject mavenProject, List<Resource> resources, IPath outputPath, String resourceEncoding, IProgressMonitor monitor, boolean addTestFlag) throws CoreException {
        for (Resource resource : resources) {
            String directory = resource.getDirectory();
            if (directory == null) continue;
            File resourceDirectory = null;
            try {
                resourceDirectory = new File(directory).getCanonicalFile();
            }
            catch (IOException ex) {
                resourceDirectory = new File(directory).getAbsoluteFile();
            }
            IContainer r = this.getFolder(project, resourceDirectory.getPath());
            if (r == project) {
                log.error("Skipping resource folder " + String.valueOf(r.getFullPath()));
                return;
            }
            if (project.equals((Object)r.getProject())) {
                IPath path = r.getFullPath();
                IClasspathEntryDescriptor enclosing = this.getEnclosingEntryDescriptor(classpath, path);
                if (enclosing != null && this.overlapsWithSourceFolder(path, project, mavenProject)) {
                    this.configureOverlapWithSource(classpath, enclosing, path);
                } else if (this.overlapsWithOtherResourceFolder(path, project, mavenProject)) {
                    log.info("Skipping resource folder " + String.valueOf(path) + " since it's contained by another resource folder");
                } else {
                    this.addResourceFolder(classpath, path, outputPath, addTestFlag);
                }
                if (!r.exists() || Objects.equals(r.getDefaultCharset(false), resourceEncoding)) continue;
                r.setDefaultCharset(resourceEncoding, monitor);
                continue;
            }
            log.info("Not adding resources folder " + String.valueOf(resourceDirectory));
        }
    }

    private void addResourceFolder(IClasspathDescriptor classpath, IPath resourceFolder, IPath outputPath, boolean addTestFlag) {
        log.info("Adding resource folder " + String.valueOf(resourceFolder));
        IClasspathEntryDescriptor descriptor = classpath.addSourceEntry(resourceFolder, outputPath, DEFAULT_INCLUSIONS, new IPath[]{IPath.fromOSString((String)"**")}, false);
        descriptor.setClasspathAttribute("test", addTestFlag ? "true" : null);
        descriptor.setClasspathAttribute("optional", "true");
    }

    private void configureOverlapWithSource(IClasspathDescriptor classpath, IClasspathEntryDescriptor enclosing, IPath resourceFolder) {
        log.info("Resources folder " + String.valueOf(resourceFolder) + " overlaps with sources folder " + String.valueOf(enclosing.getPath()));
        enclosing.addInclusionPattern(IPath.fromOSString((String)"**/*.java"));
        enclosing.removeExclusionPattern(IPath.fromOSString((String)"**"));
        classpath.touchEntry(resourceFolder);
    }

    private boolean overlapsWithSourceFolder(IPath path, IProject project, MavenProject mavenProject) {
        IPath relPath = path.makeRelativeTo(project.getFullPath());
        List compile = mavenProject.getCompileSourceRoots();
        List test = mavenProject.getTestCompileSourceRoots();
        return AbstractJavaProjectConfigurator.isContained(relPath, this.getSourceFolders(project, compile)) || AbstractJavaProjectConfigurator.isContained(relPath, this.getSourceFolders(project, test));
    }

    private boolean overlapsWithOtherResourceFolder(IPath path, IProject project, MavenProject mavenProject) {
        IPath relPath = path.makeRelativeTo(project.getFullPath());
        return AbstractJavaProjectConfigurator.isContained(relPath, this.getOtherResourceFolders(project, mavenProject.getResources(), relPath)) || AbstractJavaProjectConfigurator.isContained(relPath, this.getOtherResourceFolders(project, mavenProject.getTestResources(), relPath));
    }

    private Stream<IPath> getSourceFolders(IProject project, List<String> sources) {
        return sources.stream().map(string -> Path.of(string, new String[0])).map(source -> AbstractJavaProjectConfigurator.getProjectRelativePath(project, source));
    }

    private Stream<IPath> getOtherResourceFolders(IProject project, List<Resource> resources, IPath curPath) {
        return resources.stream().map(FileSet::getDirectory).map(string -> Path.of(string, new String[0])).map(res -> AbstractJavaProjectConfigurator.getProjectRelativePath(project, res)).filter(path -> !path.equals((Object)curPath));
    }

    private static boolean isContained(IPath path, Stream<IPath> otherPaths) {
        return otherPaths.anyMatch(p -> p.isPrefixOf(path));
    }

    /*
     * WARNING - void declaration
     */
    protected void addJavaProjectOptions(Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IJavaProject jp;
        String source = null;
        String target = null;
        String release = null;
        boolean generateParameters = false;
        boolean enablePreviewFeatures = false;
        for (MojoExecution execution : this.getCompilerMojoExecutions(request, monitor)) {
            release = this.getCompilerLevel(request.mavenProject(), execution, "release", release, RELEASES, monitor);
            source = this.getCompilerLevel(request.mavenProject(), execution, "source", source, SOURCES, monitor);
            target = this.getCompilerLevel(request.mavenProject(), execution, "target", target, TARGETS, monitor);
            generateParameters = generateParameters || this.isGenerateParameters(request.mavenProject(), execution, monitor);
            enablePreviewFeatures = enablePreviewFeatures || this.isEnablePreviewFeatures(request.mavenProject(), execution, monitor);
            for (Object o : (List)this.maven.getMojoParameterValue(request.mavenProject(), execution, "compilerArgs", List.class, monitor)) {
                void compilerArg;
                Object e = o;
                if (!(e instanceof String)) continue;
                String cfr_ignored_0 = (String)e;
                String cfr_ignored_1 = (String)e;
                boolean err = false;
                String[] settings = new String[]{};
                if (compilerArg.startsWith("-warn:")) {
                    settings = compilerArg.substring("-warn:".length()).split(",");
                } else if (compilerArg.startsWith("-err:")) {
                    err = true;
                    settings = compilerArg.substring("-err:".length()).split(",");
                }
                String[] stringArray = settings;
                int n = settings.length;
                int n2 = 0;
                while (n2 < n) {
                    String cliSetting = stringArray[n2];
                    if (cliSetting.length() >= 2) {
                        String severity = cliSetting.charAt(0) == '-' ? "ignore" : (err ? "error" : "warning");
                        String option = this.toCompilerOption(cliSetting = Character.isLetter(cliSetting.charAt(0)) ? cliSetting : cliSetting.substring(1));
                        if (option != null) {
                            options.put(option, severity);
                        }
                    }
                    ++n2;
                }
            }
        }
        if (release != null) {
            source = release;
            target = release;
        } else {
            if (source == null) {
                source = this.getDefaultSourceLevel();
                log.warn("Could not determine source level, using default " + source);
            }
            if (target == null) {
                target = this.getDefaultTargetLevel(source);
                log.warn("Could not determine target level, using default " + target);
            }
        }
        source = this.sanitizeJavaVersion(source);
        target = this.sanitizeJavaVersion(target);
        options.put("org.eclipse.jdt.core.compiler.source", source);
        options.put("org.eclipse.jdt.core.compiler.compliance", source);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", target);
        options.put("org.eclipse.jdt.core.compiler.release", release == null ? "disabled" : "enabled");
        if (generateParameters) {
            options.put("org.eclipse.jdt.core.compiler.codegen.methodParameters", "generate");
        }
        if ((jp = JavaCore.create((IProject)request.mavenProjectFacade().getProject())) != null && jp.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", false) == null) {
            options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "warning");
        }
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", enablePreviewFeatures ? "enabled" : "disabled");
        if (jp != null && jp.getOption("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", false) == null) {
            options.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        }
    }

    private String toCompilerOption(String problemSettingName) {
        return switch (problemSettingName) {
            case "serial" -> "org.eclipse.jdt.core.compiler.problem.missingSerialVersion";
            default -> null;
        };
    }

    private boolean isGenerateParameters(MavenProject mavenProject, MojoExecution execution, IProgressMonitor monitor) {
        Boolean generateParameters = null;
        try {
            generateParameters = (Boolean)this.maven.getMojoParameterValue(mavenProject, execution, "parameters", Boolean.class, monitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Boolean.TRUE.equals(generateParameters)) {
            try {
                List args = (List)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgs", List.class, monitor);
                if (args != null) {
                    generateParameters = args.contains("-parameters");
                }
            }
            catch (Exception args) {
                // empty catch block
            }
        }
        if (!Boolean.TRUE.equals(generateParameters)) {
            try {
                String compilerArgument = (String)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgument", String.class, monitor);
                if (compilerArgument != null) {
                    generateParameters = compilerArgument.contains("-parameters");
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return Boolean.TRUE.equals(generateParameters);
    }

    private boolean isEnablePreviewFeatures(MavenProject mavenProject, MojoExecution execution, IProgressMonitor monitor) {
        try {
            List args = (List)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgs", List.class, monitor);
            if (args != null && args.contains("--enable-preview")) {
                return true;
            }
        }
        catch (Exception args) {
            // empty catch block
        }
        try {
            String compilerArgument = (String)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgument", String.class, monitor);
            if (compilerArgument != null && compilerArgument.contains("--enable-preview")) {
                return true;
            }
        }
        catch (CoreException compilerArgument) {
            // empty catch block
        }
        try {
            Boolean enablePreview = (Boolean)this.maven.getMojoParameterValue(mavenProject, execution, "enablePreview", Boolean.class, monitor);
            if (Boolean.TRUE.equals(enablePreview)) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private String sanitizeJavaVersion(String version) {
        if (version == null) {
            return null;
        }
        return switch (version) {
            case "5", "6", "7", "8" -> "1." + version;
            default -> {
                String subVersion;
                yield version.startsWith("1.") && Integer.parseInt(subVersion = version.substring(2)) > 8 ? subVersion : version;
            }
        };
    }

    protected String getDefaultTargetLevel(String source) {
        return DEFAULT_COMPILER_LEVEL;
    }

    protected String getDefaultSourceLevel() {
        return DEFAULT_COMPILER_LEVEL;
    }

    protected List<MojoExecution> getCompilerMojoExecutions(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        return request.mavenProjectFacade().getMojoExecutions("org.apache.maven.plugins", COMPILER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_COMPILE, GOAL_TESTCOMPILE});
    }

    private String getCompilerLevel(MavenProject mavenProject, MojoExecution execution, String parameter, String prevVersion, List<String> supportedVersions, IProgressMonitor monitor) {
        try {
            String version = (String)this.maven.getMojoParameterValue(mavenProject, execution, parameter, String.class, monitor);
            if (version == null) {
                return prevVersion;
            }
            if (!"release".equals(parameter)) {
                version = this.sanitizeJavaVersion(version);
            }
            if (!supportedVersions.isEmpty() && !supportedVersions.contains(version)) {
                String highestVersion = supportedVersions.get(supportedVersions.size() - 1);
                try {
                    if (Version.valueOf((String)highestVersion).compareTo(Version.valueOf((String)version)) < 0) {
                        return highestVersion;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return prevVersion;
            }
            return JavaCore.compareJavaVersions((String)prevVersion, (String)version) < 0 ? version : prevVersion;
        }
        catch (CoreException ex) {
            log.error("Failed to determine compiler " + parameter + " setting, assuming default", (Throwable)ex);
            return prevVersion;
        }
    }

    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        super.unconfigure(request, monitor);
        this.removeMavenClasspathContainer(request.mavenProjectFacade().getProject());
    }

    private void removeMavenClasspathContainer(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                    newEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
    }

    protected IContainer getFolder(IProject project, String path) throws CoreException {
        IPath relativePath;
        Path folderPath;
        Path projectLocation = project.getLocation().toPath().toAbsolutePath();
        if (projectLocation.equals(folderPath = Path.of(path, new String[0]))) {
            return project;
        }
        if (folderPath.isAbsolute()) {
            relativePath = AbstractJavaProjectConfigurator.getProjectRelativePath(project, folderPath);
        } else {
            folderPath = projectLocation.resolve(path);
            relativePath = IPath.fromOSString((String)path);
        }
        if (!project.exists(relativePath) && Files.exists(folderPath, new LinkOption[0]) && !ResourcesPlugin.getWorkspace().getRoot().getLocation().toPath().equals(folderPath)) {
            String linkName = projectLocation.relativize(folderPath).toString().replace("/", "_");
            IFolder folder = project.getFolder(linkName);
            folder.createLink(folderPath.toUri(), 256, null);
            folder.setPersistentProperty(LINKED_MAVEN_RESOURCE, "true");
            return folder;
        }
        return project.getFolder(relativePath);
    }

    private static IPath getProjectRelativePath(IProject project, Path absolutePath) {
        Path basedir = project.getLocation().toPath().toAbsolutePath();
        if (absolutePath.equals(basedir)) {
            return IPath.fromOSString((String)".");
        }
        if (absolutePath.startsWith(basedir)) {
            return IPath.fromPath((Path)basedir.relativize(absolutePath));
        }
        return IPath.fromPath((Path)absolutePath);
    }

    private List<String> getCompilerArguments(MavenProject mavenProject, MojoExecution execution, IProgressMonitor monitor) {
        ArrayList<String> arguments = new ArrayList<String>();
        try {
            List args = (List)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgs", List.class, monitor);
            if (args != null) {
                args.stream().filter(a -> a != null).forEach(a -> {
                    boolean bl = arguments.add(a.toString());
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arguments;
    }

    private List<String> getCompilerArguments(IMavenProjectFacade facade, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> compilerArgs = new ArrayList<String>();
        List executions = facade.getMojoExecutions("org.apache.maven.plugins", COMPILER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_COMPILE, GOAL_TESTCOMPILE});
        MavenProject mavenProject = facade.getMavenProject();
        for (MojoExecution compile : executions) {
            List<String> args;
            if (!this.isCompileExecution(compile, mavenProject, options, monitor) && !this.isTestCompileExecution(compile, mavenProject, options, monitor) || (args = this.getCompilerArguments(mavenProject, compile, monitor)) == null) continue;
            compilerArgs.addAll(args);
        }
        return compilerArgs;
    }

    @Override
    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) {
        ModuleSupport.configureClasspath(facade, classpath, monitor);
    }

    @Override
    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
        if (javaProject == null || !javaProject.exists() || classpath == null) {
            return;
        }
        List<String> compilerArgs = this.getCompilerArguments(facade, javaProject.getOptions(true), monitor);
        ModuleSupport.configureRawClasspath(request, classpath, monitor, compilerArgs);
    }

    private static /* synthetic */ IClasspathAttribute[] lambda$9() {
        return new IClasspathAttribute[0];
    }
}

