/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager;

import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.converter.ConverterFactoryRegistry;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.dtmanager.DefaultDTInfoFactory;
import org.eclipse.jst.pagedesigner.dtmanager.IDTInfo;
import org.eclipse.jst.pagedesigner.dtmanager.IDTInfoFactory;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.DTTagConverterFactory;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;

public class DTManager {
    private static DTManager instance;
    private IDTInfoFactory _dtInfoFactory;

    private DTManager() {
    }

    public static synchronized DTManager getInstance() {
        if (instance == null) {
            instance = new DTManager();
        }
        return instance;
    }

    public ITagConverter getTagConverter(Element element, int mode, IDOMDocument document) {
        ITagConverter tagConverter = null;
        String nsURI = CMUtil.getElementNamespaceURI((Element)element);
        IConverterFactory tagConverterFactory = this.getTagConverterFactory(nsURI);
        if (tagConverterFactory != null) {
            tagConverter = tagConverterFactory.createConverter(element, mode);
            if (tagConverter != null) {
                tagConverter.setDestDocument(document);
            } else {
                tagConverter = ConverterFactoryRegistry.getInstance().createTagConverter(element, mode, document);
            }
        }
        return tagConverter;
    }

    protected IConverterFactory getTagConverterFactory(String nsURI) {
        return new DTTagConverterFactory();
    }

    public IDTInfo getDTInfo(Element element) {
        IDTInfo dtInfo = null;
        String nsURI = CMUtil.getElementNamespaceURI((Element)element);
        IDTInfoFactory dtInfoFactory = this.getDTInfoFactory(nsURI);
        if (dtInfoFactory != null) {
            dtInfo = dtInfoFactory.getDTInfo(element);
        }
        return dtInfo;
    }

    protected IDTInfoFactory getDTInfoFactory(String nsURI) {
        if (this._dtInfoFactory == null) {
            this._dtInfoFactory = new DefaultDTInfoFactory();
        }
        return this._dtInfoFactory;
    }
}

