/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.link;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.link.ILinkCreator;

public class ExtensionReader {
    private static Logger _log = PDPlugin.getLogger(ExtensionReader.class);
    private static List<ILinkCreator> _handlers = null;
    private static final String ATTR_CLASS = "class";

    public static synchronized List<ILinkCreator> getAllLinkHandlers() {
        if (_handlers == null) {
            _handlers = ExtensionReader.readAllLinkHandlers();
        }
        return Collections.unmodifiableList(_handlers);
    }

    private static List<ILinkCreator> readAllLinkHandlers() {
        ArrayList<ILinkCreator> result = new ArrayList<ILinkCreator>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] linkHandlers = ext.getConfigurationElements();
            int j = 0;
            while (j < linkHandlers.length) {
                if (linkHandlers[j].getName().equals("linkCreator")) {
                    linkHandlers[j].getAttribute(ATTR_CLASS);
                    try {
                        Object obj = linkHandlers[j].createExecutableExtension(ATTR_CLASS);
                        if (obj instanceof ILinkCreator) {
                            result.add((ILinkCreator)obj);
                        }
                    }
                    catch (CoreException coreException) {
                        _log.error("Log.Error.ExtensionReader.ReadLinkExtension");
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }
}

