/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.handlers.PageImport;
import org.eclipse.jst.jsp.ui.internal.java.views.TypeNameLabelProvider;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class AddImportHandler
extends AbstractHandler {
    private static final TypeNameLabelProvider LABEL_PROVIDER = new TypeNameLabelProvider();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IEditorSite site = HandlerUtil.getActiveEditor((ExecutionEvent)event).getEditorSite();
        ISelectionProvider provider = site.getSelectionProvider();
        ISelection iSelection = selection = provider != null ? provider.getSelection() : null;
        if (selection instanceof IStructuredSelection && selection instanceof ITextSelection) {
            IDOMModel model;
            INodeAdapter adapter;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            int offset = ((ITextSelection)selection).getOffset();
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IDOMNode && (adapter = (model = ((IDOMNode)firstElement).getModel()).getDocument().getAdapterFor(IJSPTranslation.class)) != null) {
                ASTNode node;
                JSPTranslationAdapter translationAdapter = (JSPTranslationAdapter)model.getDocument().getAdapterFor(IJSPTranslation.class);
                JSPTranslationExtension translation = translationAdapter.getJSPTranslation();
                translation.reconcileCompilationUnit();
                ICompilationUnit cu = translation.getCompilationUnit();
                CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)cu, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
                if (astRoot != null && (node = NodeFinder.perform((ASTNode)astRoot, (int)translation.getJavaOffset(offset), (int)0)) != null) {
                    IBinding binding;
                    SimpleName name = null;
                    if (node.getNodeType() == 42) {
                        name = (SimpleName)node;
                    } else if (node.getNodeType() == 40) {
                        name = ((QualifiedName)node).getName();
                    }
                    if (name != null && (binding = name.resolveBinding()) instanceof ITypeBinding && (binding.getJavaElement() == null || !binding.getJavaElement().exists())) {
                        ITypeBinding typeBinding = (ITypeBinding)binding;
                        IImportContainer importContainer = cu.getImportContainer();
                        if (!importContainer.getImport(typeBinding.getQualifiedName()).exists()) {
                            ArrayList typesFound = new ArrayList();
                            TypeNameMatcher collector = new TypeNameMatcher(typesFound);
                            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{cu.getJavaProject()});
                            try {
                                new SearchEngine().searchAllTypeNames(null, 8, name.getIdentifier().toCharArray(), 8, 10, scope, (TypeNameMatchRequestor)collector, 3, null);
                                int length = typesFound.size();
                                ArrayList<TypeNameMatch> elements = new ArrayList<TypeNameMatch>();
                                int i = 0;
                                while (i < length) {
                                    TypeNameMatch match = (TypeNameMatch)typesFound.get(i);
                                    int modifiers = match.getModifiers();
                                    if (!Flags.isPrivate((int)modifiers) && !Flags.isPackageDefault((int)modifiers)) {
                                        elements.add(match);
                                    }
                                    ++i;
                                }
                                TypeNameMatch match = null;
                                if (elements.size() == 1) {
                                    match = (TypeNameMatch)elements.get(0);
                                } else if (elements.size() > 1) {
                                    Object result;
                                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(site.getShell(), (ILabelProvider)LABEL_PROVIDER);
                                    dialog.setElements((Object[])elements.toArray(new TypeNameMatch[elements.size()]));
                                    dialog.setTitle(JSPUIMessages.AddImportHandler_title);
                                    dialog.setMessage(JSPUIMessages.AddImportHandler_label);
                                    if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof TypeNameMatch) {
                                        match = (TypeNameMatch)result;
                                    }
                                }
                                this.addImport(match, (IDocument)model.getStructuredDocument());
                            }
                            catch (JavaModelException e) {
                                Logger.logException("Exception while determining import.", e);
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private void addImport(TypeNameMatch match, IDocument document) {
        if (match != null) {
            new PageImport(match.getFullyQualifiedName()).add(document);
        }
    }

    private class TypeNameMatcher
    extends TypeNameMatchRequestor {
        private Collection matches;

        public TypeNameMatcher(Collection matches) {
            this.matches = matches;
        }

        private boolean isFiltered(TypeNameMatch match) {
            int accessibility = match.getAccessibility();
            switch (accessibility) {
                case 1: {
                    return "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.forbiddenReferenceCheck"));
                }
                case 2: {
                    return "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.discouragedReferenceCheck"));
                }
            }
            return false;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            if (!this.isFiltered(match)) {
                this.matches.add(match);
            }
        }
    }
}

