/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryPackage;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;

public class JSFLibraryRegistryImpl
extends EObjectImpl
implements JSFLibraryRegistry {
    public static final String copyright = "Copyright (c) 2005 Oracle Corporation";
    protected static final String DEFAULT_IMPLEMENTATION_ID_EDEFAULT = "";
    protected String defaultImplementationID = "";
    protected EList jsfLibraries;
    protected EList pluginProvidedJSFLibraries;

    protected JSFLibraryRegistryImpl() {
    }

    protected EClass eStaticClass() {
        return JSFLibraryRegistryPackage.Literals.JSF_LIBRARY_REGISTRY;
    }

    @Override
    public String getDefaultImplementationID() {
        return this.defaultImplementationID;
    }

    @Override
    public void setDefaultImplementationID(String newDefaultImplementationID) {
        String oldDefaultImplementationID = this.defaultImplementationID;
        this.defaultImplementationID = newDefaultImplementationID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldDefaultImplementationID, (Object)this.defaultImplementationID));
        }
    }

    @Override
    public EList getJSFLibraries() {
        if (this.jsfLibraries == null) {
            this.jsfLibraries = new EObjectContainmentEList(JSFLibrary.class, (InternalEObject)this, 1);
        }
        return this.jsfLibraries;
    }

    @Override
    public EList getPluginProvidedJSFLibraries() {
        if (this.pluginProvidedJSFLibraries == null) {
            this.pluginProvidedJSFLibraries = new EObjectContainmentEList(PluginProvidedJSFLibrary.class, (InternalEObject)this, 2);
        }
        return this.pluginProvidedJSFLibraries;
    }

    @Override
    public JSFLibrary getDefaultImplementation() {
        return this.getJSFLibraryByID(this.getDefaultImplementationID());
    }

    @Override
    public void setDefaultImplementation(JSFLibrary implementation) {
        if (implementation != null) {
            this.setDefaultImplementationID(implementation.getID());
        } else {
            this.setDefaultImplementationID(null);
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getJSFLibraries()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getPluginProvidedJSFLibraries()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDefaultImplementationID();
            }
            case 1: {
                return this.getJSFLibraries();
            }
            case 2: {
                return this.getPluginProvidedJSFLibraries();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDefaultImplementationID((String)newValue);
                return;
            }
            case 1: {
                this.getJSFLibraries().clear();
                this.getJSFLibraries().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getPluginProvidedJSFLibraries().clear();
                this.getPluginProvidedJSFLibraries().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDefaultImplementationID(DEFAULT_IMPLEMENTATION_ID_EDEFAULT);
                return;
            }
            case 1: {
                this.getJSFLibraries().clear();
                return;
            }
            case 2: {
                this.getPluginProvidedJSFLibraries().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return DEFAULT_IMPLEMENTATION_ID_EDEFAULT == null ? this.defaultImplementationID != null : !DEFAULT_IMPLEMENTATION_ID_EDEFAULT.equals(this.defaultImplementationID);
            }
            case 1: {
                return this.jsfLibraries != null && !this.jsfLibraries.isEmpty();
            }
            case 2: {
                return this.pluginProvidedJSFLibraries != null && !this.pluginProvidedJSFLibraries.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public JSFLibrary getJSFLibraryByID(String ID) {
        JSFLibrary library = null;
        if (ID != null) {
            for (JSFLibrary curLib : this.getAllJSFLibraries()) {
                if (!ID.equals(curLib.getID())) continue;
                library = curLib;
                break;
            }
        }
        return library;
    }

    @Override
    public EList getJSFLibrariesByName(String name) {
        BasicEList libraries = new BasicEList();
        if (name != null) {
            for (JSFLibrary curLib : this.getAllJSFLibraries()) {
                if (!name.equals(curLib.getName())) continue;
                libraries.add((Object)curLib);
            }
        }
        return libraries;
    }

    @Override
    public EList getImplJSFLibraries() {
        BasicEList implementations = new BasicEList();
        for (JSFLibrary lib : this.getAllJSFLibraries()) {
            if (!lib.isImplementation()) continue;
            implementations.add((Object)lib);
        }
        return implementations;
    }

    @Override
    public EList getNonImplJSFLibraries() {
        BasicEList nonImplementations = new BasicEList();
        for (JSFLibrary lib : this.getAllJSFLibraries()) {
            if (lib.isImplementation()) continue;
            nonImplementations.add((Object)lib);
        }
        return nonImplementations;
    }

    @Override
    public EList getAllJSFLibraries() {
        BasicEList allLibs = new BasicEList();
        allLibs.addAll((Collection)this.getJSFLibraries());
        allLibs.addAll((Collection)this.getPluginProvidedJSFLibraries());
        return allLibs;
    }

    @Override
    public boolean addJSFLibrary(JSFLibrary library) {
        boolean added = false;
        added = library instanceof PluginProvidedJSFLibrary ? this.getPluginProvidedJSFLibraries().add((Object)library) : this.getJSFLibraries().add((Object)library);
        return added;
    }

    @Override
    public boolean removeJSFLibrary(JSFLibrary library) {
        boolean removed = false;
        removed = library instanceof PluginProvidedJSFLibrary ? this.getPluginProvidedJSFLibraries().remove((Object)library) : this.getJSFLibraries().remove((Object)library);
        return removed;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (DefaultImplementationID: ");
        result.append(this.defaultImplementationID);
        result.append(')');
        return result.toString();
    }
}

