/*******************************************************************************
 * Copyright (c) 2009, 2011 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0, which accompanies this distribution
 * and is available at https://www.eclipse.org/legal/epl-2.0/.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.jpa.db.internal.driver;

import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

/**
 * Adapt the variety of catalog (and schema) configurations generated by
 * DTP-supplied drivers.
 */
interface CatalogStrategy {

	/**
	 * Return whether the DTP database has "real" catalogs (i.e. catalogs that
	 * can be specified by the user).
	 */
	boolean supportsCatalogs();

	/**
	 * Return the DTP database's catalogs. This will be empty if the database
	 * does <em>not</em> support catalogs.
	 * @see #supportsCatalogs()
	 */
	List<Catalog> getCatalogs();

	/**
	 * Return the DTP database's schemas. This will be empty if the database
	 * supports catalogs.
	 * @see #supportsCatalogs()
	 */
	List<Schema> getSchemas();
}
