/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.AbstractCDOViewProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.CDOViewProviderRegistry;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.session.CDOViewContainerImpl;
import org.eclipse.emf.internal.cdo.view.PluginContainerViewProvider;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.om.OMPlatform;

public class CDOViewProviderRegistryImpl
extends Container<CDOViewProvider>
implements CDOViewProviderRegistry {
    public static final CDOViewProviderRegistryImpl INSTANCE = new CDOViewProviderRegistryImpl();
    private static final String EXT_POINT = "viewProviders";
    private static final Comparator<CDOViewProvider> COMPARATOR = new Comparator<CDOViewProvider>(){

        @Override
        public int compare(CDOViewProvider vp1, CDOViewProvider vp2) {
            return -Integer.compare(vp1.getPriority(), vp2.getPriority());
        }
    };
    private final List<CDOViewProvider> viewProviders = new ArrayList<CDOViewProvider>();

    public CDOViewProviderRegistryImpl() {
        this.addViewProvider(PluginContainerViewProvider.INSTANCE);
    }

    @Override
    public CDOView provideView(URI uri, ResourceSet resourceSet) {
        if (uri == null) {
            return null;
        }
        CDOViewSet viewSet = null;
        CDOViewProvider[] cDOViewProviderArray = this.getViewProviders(uri);
        int n = cDOViewProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view;
            CDOViewProvider viewProvider = cDOViewProviderArray[n2];
            if (viewSet == null) {
                viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
            }
            if ((view = this.provideView(uri, resourceSet, viewSet, viewProvider)) != null) {
                CDOViewProvider provider = view.getProvider();
                if (provider != null) {
                    if (provider != viewProvider) {
                        throw new IllegalStateException("View providers don't match");
                    }
                } else {
                    view.setProvider(viewProvider);
                }
                return view;
            }
            ++n2;
        }
        return null;
    }

    private InternalCDOView provideView(URI uri, ResourceSet resourceSet, CDOViewSet viewSet, CDOViewProvider viewProvider) {
        if (viewSet != null && viewProvider instanceof CDOViewProvider.CDOViewProvider2) {
            URI viewURI;
            try {
                viewURI = ((CDOViewProvider.CDOViewProvider2)viewProvider).getViewURI(uri);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(String.valueOf(ex.getMessage()) + ": " + uri, ex);
            }
            catch (Error ex) {
                throw ex;
            }
            try {
                InternalCDOView view = (InternalCDOView)viewSet.resolveView(viewURI);
                if (view != null) {
                    return view;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            CDOViewContainerImpl.VIEW_PROVIDER.set(viewProvider);
            InternalCDOView view = (InternalCDOView)viewProvider.getView(uri, resourceSet);
            if (view != null) {
                InternalCDOView internalCDOView = view;
                return internalCDOView;
            }
        }
        finally {
            CDOViewContainerImpl.VIEW_PROVIDER.remove();
        }
        return null;
    }

    @Override
    @Deprecated
    public Pair<CDOView, CDOViewProvider> provideViewWithInfo(URI uri, ResourceSet resourceSet) {
        CDOView view = this.provideView(uri, resourceSet);
        if (view != null) {
            return Pair.create((Object)view, (Object)view.getProvider());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOViewProvider[] getViewProviders(URI uri) {
        ArrayList<CDOViewProvider> result = new ArrayList<CDOViewProvider>();
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            for (CDOViewProvider viewProvider : this.viewProviders) {
                if (!viewProvider.matchesRegex(uri)) continue;
                result.add(viewProvider);
            }
        }
        Collections.sort(result, COMPARATOR);
        return result.toArray(new CDOViewProvider[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasViewProvider(CDOViewProvider viewProvider) {
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            return this.viewProviders.contains(viewProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addViewProvider(CDOViewProvider viewProvider) {
        boolean added;
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            boolean bl = added = !this.viewProviders.contains(viewProvider);
            if (added) {
                this.viewProviders.add(viewProvider);
            }
        }
        if (added) {
            this.fireElementAddedEvent(viewProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeViewProvider(CDOViewProvider viewProvider) {
        boolean removed;
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            removed = this.viewProviders.remove(viewProvider);
        }
        if (removed) {
            this.fireElementRemovedEvent(viewProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOViewProvider[] getElements() {
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            return this.viewProviders.toArray(new CDOViewProvider[this.viewProviders.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            return this.viewProviders.isEmpty();
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (OMPlatform.INSTANCE.isOSGiRunning()) {
            try {
                this.readExtensions();
            }
            catch (Throwable t) {
                OM.LOG.error(t);
            }
        }
    }

    public void readExtensions() {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo", EXT_POINT);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                CDOViewProviderDescriptor descriptor = new CDOViewProviderDescriptor(element);
                this.addViewProvider(descriptor);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    public static final class CDOViewProviderDescriptor
    extends AbstractCDOViewProvider {
        private final IConfigurationElement element;
        private CDOViewProvider delegate;

        public CDOViewProviderDescriptor(IConfigurationElement element) {
            super(CDOViewProviderDescriptor.getRegex(element), CDOViewProviderDescriptor.getPriority(element));
            this.element = element;
            if (StringUtil.isEmpty((String)element.getAttribute("class"))) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewProviderRegistryImpl.4"), element));
            }
        }

        @Override
        public CDOView getView(URI uri, ResourceSet resourceSet) {
            CDOViewProvider viewProvider = this.getViewProvider();
            return viewProvider.getView(uri, resourceSet);
        }

        @Override
        public URI getResourceURI(CDOView view, String path) {
            CDOViewProvider viewProvider = this.getViewProvider();
            return viewProvider.getResourceURI(view, path);
        }

        @Override
        public URI getViewURI(URI uri) {
            CDOViewProvider viewProvider = this.getViewProvider();
            if (viewProvider instanceof CDOViewProvider.CDOViewProvider2) {
                return ((CDOViewProvider.CDOViewProvider2)viewProvider).getViewURI(uri);
            }
            return super.getViewURI(uri);
        }

        @Override
        public String getPath(URI uri) {
            CDOViewProvider viewProvider = this.getViewProvider();
            if (viewProvider instanceof CDOViewProvider.CDOViewProvider2) {
                return ((CDOViewProvider.CDOViewProvider2)viewProvider).getPath(uri);
            }
            return super.getPath(uri);
        }

        @Override
        protected String getDeclaredName() {
            return "CDOViewProviderDescriptor";
        }

        @Override
        protected String getActualName() {
            CDOViewProvider actualProvider = this.delegate;
            if (actualProvider != null) {
                return ReflectUtil.getSimpleClassName((Object)actualProvider);
            }
            return this.element.getAttribute("class");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CDOViewProvider getViewProvider() {
            IConfigurationElement iConfigurationElement = this.element;
            synchronized (iConfigurationElement) {
                if (this.delegate == null) {
                    try {
                        this.delegate = (CDOViewProvider)this.element.createExecutableExtension("class");
                    }
                    catch (CoreException ex) {
                        throw WrappedException.wrap((Exception)((Object)ex));
                    }
                }
                return this.delegate;
            }
        }

        private static String getRegex(IConfigurationElement element) {
            String value = element.getAttribute("regex");
            if (StringUtil.isEmpty((String)value)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewProviderRegistryImpl.6"), element));
            }
            return value;
        }

        private static int getPriority(IConfigurationElement element) {
            try {
                String value = element.getAttribute("priority");
                return Integer.parseInt(value);
            }
            catch (Exception ex) {
                return 500;
            }
        }
    }
}

