/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class CDOLabelProvider
extends AdapterFactoryLabelProvider
implements IColorProvider,
IFontProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static Color readPermissionColor;
    private Font bold;
    private CDOView view;
    private TreeViewer viewer;

    public CDOLabelProvider(AdapterFactory adapterFactory, CDOView view, TreeViewer viewer) {
        super(adapterFactory);
        this.view = view;
        this.viewer = viewer;
        Control control = viewer.getControl();
        this.bold = UIUtil.getBoldFont((Control)control);
    }

    public CDOView getView() {
        return this.view;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        this.bold.dispose();
        super.dispose();
    }

    public void notifyChanged(final Notification notification) {
        super.notifyChanged(notification);
        try {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        CDOLabelProvider.this.viewer.refresh(notification.getNotifier(), true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getImage(Object object) {
        try {
            return super.getImage(object);
        }
        catch (Exception ex) {
            return CDOLabelProvider.getErrorImage();
        }
    }

    public String getText(Object object) {
        Exception exception = null;
        try {
            String text = super.getText(object);
            if (!StringUtil.isEmpty((String)text)) {
                return text;
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        return this.getText(object, exception);
    }

    protected String getText(Object object, Exception exception) {
        String text = null;
        try {
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                EClass eClass = eObject.eClass();
                text = this.getText(eClass);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (StringUtil.isEmpty(text)) {
            text = object.getClass().getSimpleName();
        }
        return String.valueOf(text) + "  [" + this.getExceptionMessage(exception) + "]";
    }

    protected String getExceptionMessage(Exception exception) {
        String message = exception.getLocalizedMessage();
        if (StringUtil.isEmpty((String)message)) {
            message = exception.getMessage();
        }
        if (StringUtil.isEmpty((String)message)) {
            message = exception.getClass().getName();
        }
        return message;
    }

    public Color getBackground(Object object) {
        return null;
    }

    public Color getForeground(Object object) {
        return CDOLabelProvider.getColor((CDOObject)FSMUtil.adapt((Object)object, (CDOView)this.view));
    }

    public Font getFont(Object object) {
        try {
            InternalCDOObject cdoObject = FSMUtil.adapt((Object)object, (CDOView)this.view);
            if (cdoObject != null) {
                switch (cdoObject.cdoState()) {
                    case NEW: 
                    case DIRTY: 
                    case CONFLICT: {
                        return this.bold;
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public static Color getColor(CDOObject object) {
        if (object != null) {
            try {
                if (object.cdoConflict()) {
                    return CDOLabelProvider.getConflictColor();
                }
                CDOPermission permission = object.cdoPermission();
                switch (permission) {
                    case NONE: {
                        return CDOLabelProvider.getNoPermissionColor();
                    }
                    case READ: {
                        return CDOLabelProvider.getReadPermissionColor();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    static Color getNoPermissionColor() {
        return UIUtil.grayColor();
    }

    static Color getReadPermissionColor() {
        if (readPermissionColor == null) {
            readPermissionColor = UIUtil.getDisplay().getSystemColor(14);
        }
        return readPermissionColor;
    }

    static Color getConflictColor() {
        return UIUtil.redColor();
    }

    static Image getErrorImage() {
        return UIUtil.errorImage();
    }
}

