/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.transfer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

public class FileSystemTransferSystem
extends CDOTransferSystem {
    public static final FileSystemTransferSystem INSTANCE = new FileSystemTransferSystem();
    public static final String TYPE = "fs";

    public FileSystemTransferSystem() {
        super(false);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public URI getURI(IPath path) {
        return URI.createFileURI((String)path.toOSString());
    }

    @Override
    public CDOTransferElement getElement(IPath path) {
        File file = this.getFile(path);
        if (file.exists()) {
            return new Element(this, file);
        }
        return null;
    }

    @Override
    public CDOTransferElement getElement(URI uri) {
        if (uri.isFile()) {
            return this.getElement(uri.path());
        }
        return null;
    }

    @Override
    public void createFolder(IPath path) {
        File file = this.getFile(path);
        this.mkDir(file);
    }

    @Override
    public void createBinary(IPath path, InputStream source, IProgressMonitor monitor) {
        FileOutputStream target = null;
        try {
            try {
                File file = this.getFile(path);
                long length = file.length();
                int totalWork = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
                monitor.beginTask("", totalWork);
                this.mkParent(file);
                target = new FileOutputStream(file);
                IOUtil.copy((InputStream)source, (OutputStream)target);
                monitor.worked(totalWork);
            }
            catch (IOException ex) {
                throw new IORuntimeException();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(target);
            monitor.done();
            throw throwable;
        }
        IOUtil.close((Closeable)target);
        monitor.done();
    }

    @Override
    public void createText(IPath path, InputStream source, String encoding, IProgressMonitor monitor) {
        FileWriter target = null;
        try {
            try {
                File file = this.getFile(path);
                long length = file.length();
                int totalWork = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
                monitor.beginTask("", totalWork);
                this.mkParent(file);
                target = new FileWriter(file);
                IOUtil.copyCharacter((Reader)new InputStreamReader(source, encoding), (Writer)target);
                monitor.worked(totalWork);
            }
            catch (IOException ex) {
                throw new IORuntimeException();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(target);
            monitor.done();
            throw throwable;
        }
        IOUtil.close((Closeable)target);
        monitor.done();
    }

    public String toString() {
        return "File System";
    }

    protected File getFile(IPath path) {
        return new File(path.toOSString());
    }

    protected void mkParent(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            this.mkDir(parent);
        }
    }

    protected void mkDir(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IORuntimeException("Not a folder " + file);
            }
        } else if (!file.mkdirs()) {
            throw new IORuntimeException("Could not create folder " + file);
        }
    }

    private static class Element
    extends CDOTransferElement {
        private File file;

        public Element(CDOTransferSystem system, File file) {
            super(system);
            this.file = file.getAbsoluteFile();
        }

        @Override
        public Object getNativeObject() {
            return this.file;
        }

        @Override
        public IPath getPath() {
            return new Path(this.file.getPath());
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        protected CDOTransferElement[] doGetChildren() {
            File[] children = this.file.listFiles();
            CDOTransferElement[] result = new Element[children.length];
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                result[i] = new Element(this.getSystem(), child);
                ++i;
            }
            return result;
        }

        @Override
        protected InputStream doOpenInputStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
    }
}

