/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.repositories;

import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionProvider;
import org.eclipse.emf.cdo.transaction.CDOTransactionOpener;
import org.eclipse.emf.cdo.view.CDOViewOpener;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider2;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdateProvider;

public interface CDORepository
extends CDOExplorerElement,
IContainer<CDOBranch>,
IPasswordCredentialsProvider2,
IPasswordCredentialsUpdateProvider,
IManagedContainerProvider,
CDOSessionProvider,
CDOViewOpener,
CDOTransactionOpener {
    public static final String TYPE_REMOTE = "remote";
    public static final String TYPE_CLONE = "clone";
    public static final String TYPE_LOCAL = "local";

    public boolean isRemote();

    public boolean isClone();

    public boolean isLocal();

    public IManagedContainer getContainer();

    public String getConnectorType();

    public String getConnectorDescription();

    public String getName();

    public String getURI();

    public VersioningMode getVersioningMode();

    public IDGeneration getIDGeneration();

    public boolean isAuthenticating();

    public IPasswordCredentials getCredentials();

    public void setCredentials(IPasswordCredentials var1);

    public State getState();

    public boolean isConnected();

    public void connect();

    public void disconnect();

    public CDOCheckout[] getCheckouts();

    public CDOSession getSession();

    public CDOSession acquireSession();

    public void releaseSession();

    public static enum IDGeneration {
        Counter(CDOCommonRepository.IDGenerationLocation.STORE),
        UUID(CDOCommonRepository.IDGenerationLocation.CLIENT);

        private CDOCommonRepository.IDGenerationLocation location;

        private IDGeneration(CDOCommonRepository.IDGenerationLocation location) {
            this.location = location;
        }

        public CDOCommonRepository.IDGenerationLocation getLocation() {
            return this.location;
        }

        public static IDGeneration from(CDORepositoryInfo repositoryInfo) {
            if (repositoryInfo.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.CLIENT) {
                return UUID;
            }
            return Counter;
        }
    }

    public static enum State {
        Connecting,
        Connected,
        Disconnecting,
        Disconnected;

    }

    public static enum VersioningMode {
        Normal(false, false),
        Auditing(true, false),
        Branching(true, true);

        private boolean supportingAudits;
        private boolean supportingBranches;

        private VersioningMode(boolean supportingAudits, boolean supportingBranches) {
            this.supportingAudits = supportingAudits;
            this.supportingBranches = supportingBranches;
        }

        public boolean isSupportingAudits() {
            return this.supportingAudits;
        }

        public boolean isSupportingBranches() {
            return this.supportingBranches;
        }

        public static VersioningMode from(CDORepositoryInfo repositoryInfo) {
            if (repositoryInfo.isSupportingBranches()) {
                return Branching;
            }
            if (repositoryInfo.isSupportingAudits()) {
                return Auditing;
            }
            return Normal;
        }
    }
}

