/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.BreakIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Locale;
import java.util.ServiceLoader;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.text.FlowBorder;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

public class FlowUtilities {
    public static FlowUtilities INSTANCE = new FlowUtilities();
    private static final BreakIterator INTERNAL_LINE_BREAK = FlowUtilities.getLineInstance();
    private static TextLayout layout;
    static final BreakIterator LINE_BREAK;

    static {
        LINE_BREAK = FlowUtilities.getLineInstance();
    }

    private static BreakIterator getLineInstance() {
        return ServiceLoader.load(BreakIteratorProvider.class).findFirst().map(provider -> provider.getLineInstance(Locale.getDefault())).orElseGet(BreakIterator::getLineInstance);
    }

    static boolean canBreakAfter(char c) {
        boolean result;
        boolean bl = result = Character.isWhitespace(c) || c == '-';
        if (!(result || c >= 'a' && c <= 'z')) {
            LINE_BREAK.setText(c + "a");
            result = LINE_BREAK.isBoundary(1);
        }
        return result;
    }

    private static int findFirstDelimeter(String string) {
        int macNL = string.indexOf(13);
        int unixNL = string.indexOf(10);
        if (macNL == -1) {
            macNL = Integer.MAX_VALUE;
        }
        if (unixNL == -1) {
            unixNL = Integer.MAX_VALUE;
        }
        return Math.min(macNL, unixNL);
    }

    protected float getAverageCharWidth(TextFragmentBox fragment, Font font) {
        if (fragment.getWidth() > 0 && fragment.length != 0) {
            return (float)fragment.getWidth() / (float)fragment.length;
        }
        return (float)FigureUtilities.getFontMetrics(font).getAverageCharacterWidth();
    }

    /*
     * WARNING - void declaration
     */
    static int getBorderAscent(InlineFlow owner) {
        Border border = owner.getBorder();
        if (border instanceof FlowBorder) {
            void border2;
            FlowBorder flowBorder = (FlowBorder)border;
            FlowBorder cfr_ignored_0 = (FlowBorder)border;
            return border2.getInsets((IFigure)owner).top;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    static int getBorderAscentWithMargin(InlineFlow owner) {
        Border border = owner.getBorder();
        if (border instanceof FlowBorder) {
            void border2;
            FlowBorder flowBorder = (FlowBorder)border;
            FlowBorder cfr_ignored_0 = (FlowBorder)border;
            return border2.getTopMargin() + border2.getInsets((IFigure)owner).top;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    static int getBorderDescent(InlineFlow owner) {
        Border border = owner.getBorder();
        if (border instanceof FlowBorder) {
            void border2;
            FlowBorder flowBorder = (FlowBorder)border;
            FlowBorder cfr_ignored_0 = (FlowBorder)border;
            return border2.getInsets((IFigure)owner).bottom;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    static int getBorderDescentWithMargin(InlineFlow owner) {
        Border border = owner.getBorder();
        if (border instanceof FlowBorder) {
            void border2;
            FlowBorder flowBorder = (FlowBorder)border;
            FlowBorder cfr_ignored_0 = (FlowBorder)border;
            return border2.getBottomMargin() + border2.getInsets((IFigure)owner).bottom;
        }
        return 0;
    }

    static TextLayout getTextLayout() {
        if (layout == null) {
            layout = new TextLayout((Device)Display.getDefault());
        }
        layout.setOrientation(0x2000000);
        return layout;
    }

    private static void initBidi(TextFragmentBox frag, String string, Font font) {
        if (frag.requiresBidi()) {
            TextLayout textLayout = FlowUtilities.getTextLayout();
            textLayout.setFont(font);
            textLayout.setText(string);
        }
    }

    private int measureString(TextFragmentBox frag, String string, int guess, Font font) {
        if (frag.requiresBidi()) {
            return this.getTextLayoutBounds((String)string, (Font)font, (int)0, (int)(guess - 1)).width;
        }
        return this.getTextUtilities().getTextExtents((String)string.substring((int)0, (int)guess), (Font)font).width;
    }

    protected final void setupFragment(TextFragmentBox fragment, Font font, String string) {
        if (fragment.getWidth() == -1 || fragment.isTruncated()) {
            int width = string.length() == 0 || fragment.length == 0 ? 0 : (fragment.requiresBidi() ? this.getTextLayoutBounds((String)string, (Font)font, (int)0, (int)(fragment.length - 1)).width : this.getTextUtilities().getTextExtents((String)string.substring((int)0, (int)fragment.length), (Font)font).width);
            if (fragment.isTruncated()) {
                width += this.getEllipsisWidth(font);
            }
            fragment.setWidth(width);
        }
    }

    protected final int wrapFragmentInContext(TextFragmentBox frag, String string, FlowContext context, LookAhead lookahead, Font font, int wrapping) {
        boolean continueOnLine;
        int result;
        block31: {
            block34: {
                int guessSize;
                int availableWidth;
                int max;
                int min;
                block33: {
                    block32: {
                        int firstDelimiter;
                        int strLen;
                        block30: {
                            frag.setTruncated(false);
                            strLen = string.length();
                            if (strLen == 0) {
                                frag.setWidth(-1);
                                frag.length = 0;
                                this.setupFragment(frag, font, string);
                                context.addToCurrentLine(frag);
                                return 0;
                            }
                            INTERNAL_LINE_BREAK.setText(string);
                            FlowUtilities.initBidi(frag, string, font);
                            float avgCharWidth = this.getAverageCharWidth(frag, font);
                            frag.setWidth(-1);
                            int absoluteMin = 0;
                            min = 1;
                            if (wrapping == 0) {
                                absoluteMin = INTERNAL_LINE_BREAK.next();
                                while (absoluteMin > 0 && Character.isWhitespace(string.charAt(absoluteMin - 1))) {
                                    --absoluteMin;
                                }
                                min = Math.max(absoluteMin, 1);
                            }
                            if ((firstDelimiter = FlowUtilities.findFirstDelimeter(string)) == 0) {
                                max = 0;
                                min = 0;
                            } else {
                                max = Math.min(strLen, firstDelimiter) + 1;
                            }
                            availableWidth = context.getRemainingLineWidth();
                            int guess = 0;
                            guessSize = 0;
                            while (true) {
                                if (max - min <= 1) {
                                    if (min != absoluteMin || !context.isCurrentLineOccupied() || context.getContinueOnSameLine() || availableWidth >= this.measureString(frag, string, min, font) + (min == strLen && lookahead != null ? lookahead.getWidth() : 0)) break;
                                    context.endLine();
                                    availableWidth = context.getRemainingLineWidth();
                                    max = Math.min(strLen, firstDelimiter) + 1;
                                    if (max - min <= 1) break;
                                }
                                if ((guess = (int)((float)guess + (0.5f + (float)(availableWidth - guessSize) / avgCharWidth))) >= max) {
                                    guess = max - 1;
                                }
                                if (guess <= min) {
                                    guess = min + 1;
                                }
                                guessSize = this.measureString(frag, string, guess, font);
                                if (guess == strLen && lookahead != null && !FlowUtilities.canBreakAfter(string.charAt(strLen - 1)) && guessSize + lookahead.getWidth() > availableWidth) {
                                    max = guess;
                                    continue;
                                }
                                if (guessSize <= availableWidth) {
                                    min = guess;
                                    frag.setWidth(guessSize);
                                    if (guessSize != availableWidth) continue;
                                    max = guess + 1;
                                    continue;
                                }
                                max = guess;
                            }
                            result = min;
                            continueOnLine = false;
                            if (min != strLen) break block30;
                            if (string.charAt(strLen - 1) == ' ') {
                                if (frag.getWidth() == -1) {
                                    frag.length = result;
                                    frag.setWidth(this.measureString(frag, string, result, font));
                                }
                                if (lookahead.getWidth() > availableWidth - frag.getWidth()) {
                                    frag.length = result - 1;
                                    frag.setWidth(-1);
                                } else {
                                    frag.length = result;
                                }
                            } else {
                                continueOnLine = !FlowUtilities.canBreakAfter(string.charAt(strLen - 1));
                                frag.length = result;
                            }
                            break block31;
                        }
                        if (min != firstDelimiter) break block32;
                        frag.length = result++;
                        if (string.charAt(min) == '\r') {
                            if (++min < strLen && string.charAt(min) == '\n') {
                                ++result;
                            }
                        } else if (string.charAt(min) == '\n') {
                            ++result;
                        }
                        break block31;
                    }
                    if (string.charAt(min) != ' ' && !FlowUtilities.canBreakAfter(string.charAt(min - 1)) && !INTERNAL_LINE_BREAK.isBoundary(min)) break block33;
                    frag.length = min;
                    if (string.charAt(min) == ' ') {
                        ++result;
                    } else if (string.charAt(min - 1) == ' ') {
                        --frag.length;
                        frag.setWidth(-1);
                    }
                    break block31;
                }
                result = INTERNAL_LINE_BREAK.preceding(min);
                if (result != 0) break block34;
                switch (wrapping) {
                    case 2: {
                        int truncatedWidth = availableWidth - this.getEllipsisWidth(font);
                        if (truncatedWidth > 0) {
                            while (min > 0) {
                                guessSize = this.measureString(frag, string, min, font);
                                if (guessSize <= truncatedWidth) break;
                                --min;
                            }
                            frag.length = min;
                        } else {
                            frag.length = 0;
                        }
                        frag.setTruncated(true);
                        result = INTERNAL_LINE_BREAK.following(max - 1);
                        break block31;
                    }
                    default: {
                        result = min;
                    }
                }
            }
            frag.length = result;
            if (string.charAt(result - 1) == ' ') {
                --frag.length;
            }
            frag.setWidth(-1);
        }
        this.setupFragment(frag, font, string);
        context.addToCurrentLine(frag);
        context.setContinueOnSameLine(continueOnLine);
        return result;
    }

    protected Rectangle getTextLayoutBounds(String s, Font f, int start, int end) {
        TextLayout textLayout = FlowUtilities.getTextLayout();
        textLayout.setFont(f);
        textLayout.setText(s);
        return textLayout.getBounds(start, end);
    }

    protected TextUtilities getTextUtilities() {
        return TextUtilities.INSTANCE;
    }

    private int getEllipsisWidth(Font font) {
        return this.getTextUtilities().getTextExtents((String)"...", (Font)font).width;
    }

    static interface LookAhead {
        public int getWidth();
    }
}

