/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp;

import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpTransactionManager;
import org.w3c.dom.Element;

public class DbgpBaseCommands {
    public static final String ID_OPTION = "-i";
    private final IDbgpCommunicator communicator;

    public DbgpBaseCommands(IDbgpCommunicator communicator) {
        this.communicator = communicator;
    }

    public static DbgpRequest createRequest(String command) {
        DbgpRequest request = new DbgpRequest(command);
        request.addOption(ID_OPTION, DbgpBaseCommands.generateRequestId());
        return request;
    }

    public static DbgpRequest createAsyncRequest(String command) {
        DbgpRequest request = new DbgpRequest(command, true);
        request.addOption(ID_OPTION, DbgpBaseCommands.generateRequestId());
        return request;
    }

    private static int generateRequestId() {
        return DbgpTransactionManager.getInstance().generateId();
    }

    protected Element communicate(DbgpRequest request) throws DbgpException {
        return this.communicator.communicate(request);
    }

    protected void send(DbgpRequest request) throws DbgpException {
        this.communicator.send(request);
    }
}

