/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierResult;
import org.eclipse.cdt.internal.ui.refactoring.utils.Messages;
import org.eclipse.osgi.util.NLS;

public class IdentifierHelper {
    private static Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_]\\w*");
    private static Pattern INVALID_CHARACTER_PATTERN = Pattern.compile("\\W");

    public static IdentifierResult checkIdentifierName(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (IdentifierHelper.isValidIdentifier(identifier)) {
            if (IdentifierHelper.isKeyword(identifier)) {
                return new IdentifierResult(4, NLS.bind((String)Messages.IdentifierHelper_isKeyword, (Object)identifier));
            }
            return new IdentifierResult(0, NLS.bind((String)Messages.IdentifierHelper_isValid, (Object)identifier));
        }
        if (IdentifierHelper.isLeadingADigit(identifier)) {
            return new IdentifierResult(3, NLS.bind((String)Messages.IdentifierHelper_leadingDigit, (Object)identifier));
        }
        if (identifier.length() == 0) {
            return new IdentifierResult(1, Messages.IdentifierHelper_emptyIdentifier);
        }
        if (IdentifierHelper.hasIllegalCharacters(identifier)) {
            return new IdentifierResult(2, NLS.bind((String)Messages.IdentifierHelper_illegalCharacter, (Object)identifier));
        }
        return new IdentifierResult(5, NLS.bind((String)Messages.IdentifierHelper_unidentifiedMistake, (Object)identifier));
    }

    private static boolean isKeyword(String identifier) {
        Set keywords = KeywordSets.getKeywords((KeywordSetKey)KeywordSetKey.KEYWORDS, (ParserLanguage)ParserLanguage.CPP);
        return keywords.contains(identifier);
    }

    private static boolean hasIllegalCharacters(String identifier) {
        Matcher m = INVALID_CHARACTER_PATTERN.matcher(identifier);
        return m.find();
    }

    public static boolean isLeadingADigit(String identifier) {
        return identifier.length() > 0 && Character.isDigit(identifier.charAt(0));
    }

    private static boolean isValidIdentifier(String identifier) {
        Matcher m = IDENTIFIER_PATTERN.matcher(identifier);
        return m.matches();
    }
}

