/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef.header.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.actions.DimensionHeaderAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.actions.SetAlignmentColumnAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.actions.SetGrowAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.actions.SetSizeAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.ColumnEditDialog;

public class ColumnHeaderEditPart
extends DimensionHeaderEditPart<MigColumnInfo> {
    private static final String GROW_SMALL_PATH = "alignment/h/small/grow.gif";
    private static final String GROW_MENU_PATH = "alignment/h/menu/grow.gif";
    private static final String PREF_TITLE = "[pref!]";
    private static final String PREF_CODE = "pref!";
    private final MigColumnInfo m_column;

    public ColumnHeaderEditPart(MigLayoutInfo layout, MigColumnInfo column, Figure containerFigure) {
        super(layout, column, containerFigure);
        this.m_column = column;
    }

    protected Figure createFigure() {
        Figure newFigure = new Figure(){

            protected void paintClientArea(Graphics graphics) {
                Rectangle r = this.getClientArea();
                graphics.setForegroundColor(ColorConstants.buttonDarker);
                graphics.drawLine(r.x, r.y, r.x, r.bottom());
                graphics.drawLine(r.right() - 1, r.y, r.right() - 1, r.bottom());
                int index = ColumnHeaderEditPart.this.getIndex();
                String title = Integer.toString(index);
                Dimension textExtents = TextUtilities.INSTANCE.getTextExtents(title, graphics.getFont());
                if (r.width < 3 + textExtents.width + 3) {
                    return;
                }
                int titleLeft = r.x + (r.width - textExtents.width) / 2;
                int titleRight = titleLeft + textExtents.width;
                int y = r.y + (r.height - textExtents.height) / 2;
                graphics.setForegroundColor(ColorConstants.black);
                graphics.drawText(title, titleLeft, y);
                if (titleLeft - r.x > 13) {
                    Image image = ColumnHeaderEditPart.this.m_column.getAlignment(true).getSmallImageDescriptor().createImage();
                    int x = r.x + 2;
                    this.drawCentered(graphics, image, x);
                    image.dispose();
                }
                if (ColumnHeaderEditPart.this.m_column.hasGrow() && titleRight + 3 + 7 + 3 < r.right()) {
                    Image image = ColumnHeaderEditPart.this.getImage(ColumnHeaderEditPart.GROW_SMALL_PATH);
                    this.drawCentered(graphics, image, r.right() - 3 - image.getBounds().width);
                }
            }

            private void drawCentered(Graphics graphics, Image image, int x) {
                int y = (this.getBounds().height - image.getBounds().height) / 2;
                graphics.drawImage(image, x, y);
            }
        };
        newFigure.setFont(DEFAULT_FONT);
        newFigure.setOpaque(true);
        return newFigure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        Figure figure = this.getFigure();
        int index = this.getIndex();
        Interval interval = this.m_layout.getGridInfo().getColumnIntervals()[index];
        Rectangle bounds = new Rectangle(interval.begin(), 0, interval.length() + 1, ((GraphicalEditPart)this.getParent()).getFigure().getSize().height);
        bounds.performTranslate(this.getOffset().x, 0);
        figure.setBounds(bounds);
        figure.setToolTipText(this.m_column.getTooltip());
    }

    @Override
    public int getIndex() {
        return this.m_layout.getColumns().indexOf(this.m_column);
    }

    public void buildContextMenu(IMenuManager manager) {
        if (!this.m_layout.canChangeDimensions()) {
            return;
        }
        manager.add((IAction)new DimensionHeaderAction<MigColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_insertColumn){

            @Override
            protected void run(MigColumnInfo dimension, int index) throws Exception {
                ColumnHeaderEditPart.this.m_layout.insertColumn(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<MigColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_appendColumn){

            @Override
            protected void run(MigColumnInfo dimension, int index) throws Exception {
                ColumnHeaderEditPart.this.m_layout.insertColumn(index + 1);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<MigColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_deleteColumn){

            @Override
            protected void run(MigColumnInfo dimension, int index) throws Exception {
                ColumnHeaderEditPart.this.m_layout.deleteColumn(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<MigColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_clearColumn){

            @Override
            protected void run(MigColumnInfo dimension, int index) throws Exception {
                ColumnHeaderEditPart.this.m_layout.clearColumn(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<MigColumnInfo>((DimensionHeaderEditPart)this, GefMessages.ColumnHeaderEditPart_splitColumn){

            @Override
            protected void run(MigColumnInfo dimension, int index) throws Exception {
                ColumnHeaderEditPart.this.m_layout.splitColumn(index);
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SetAlignmentColumnAction(this, MigColumnInfo.Alignment.DEFAULT));
        manager.add((IAction)new SetAlignmentColumnAction(this, MigColumnInfo.Alignment.LEFT));
        manager.add((IAction)new SetAlignmentColumnAction(this, MigColumnInfo.Alignment.CENTER));
        manager.add((IAction)new SetAlignmentColumnAction(this, MigColumnInfo.Alignment.RIGHT));
        manager.add((IAction)new SetAlignmentColumnAction(this, MigColumnInfo.Alignment.FILL));
        manager.add((IAction)new SetAlignmentColumnAction(this, MigColumnInfo.Alignment.LEADING));
        manager.add((IAction)new SetAlignmentColumnAction(this, MigColumnInfo.Alignment.TRAILING));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetGrowAction<MigColumnInfo>(this, GefMessages.ColumnHeaderEditPart_grow, Activator.getImageDescriptor(GROW_MENU_PATH)));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetSizeAction<MigColumnInfo>((DimensionHeaderEditPart<MigColumnInfo>)this, GefMessages.ColumnHeaderEditPart_defaultSize, null));
        manager.add(new SetSizeAction<MigColumnInfo>(this, PREF_TITLE, PREF_CODE));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(GefMessages.ColumnHeaderEditPart_properties){

            public void run() {
                ColumnHeaderEditPart.this.editDimension();
            }
        });
    }

    @Override
    protected void editDimension() {
        new ColumnEditDialog(DesignerPlugin.getShell(), this.m_layout, this.m_column).open();
    }
}

