/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.indexer;

import java.util.Collections;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.network.indexer.MessageIndexer;

public class DefaultMessageIndexer
implements MessageIndexer {
    protected final Map<Tuple, Integer> indexer = CollectionsFactory.createMap();

    public Map<Tuple, Integer> getTuples() {
        return Collections.unmodifiableMap(this.indexer);
    }

    @Override
    public int getCount(Tuple update) {
        Integer count = this.getTuples().get(update);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public void insert(Tuple update) {
        this.update(update, 1);
    }

    @Override
    public void delete(Tuple update) {
        this.update(update, -1);
    }

    @Override
    public void update(Tuple update, int delta) {
        Integer oldCount = this.indexer.get(update);
        int newCount = (oldCount == null ? 0 : oldCount) + delta;
        if (newCount == 0) {
            this.indexer.remove(update);
        } else {
            this.indexer.put(update, newCount);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.indexer.isEmpty();
    }

    public void clear() {
        this.indexer.clear();
    }
}

