/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.PageBook;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.model.Status;
import org.eclipse.unittest.internal.model.TestCaseElement;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.model.TestSuiteElement;
import org.eclipse.unittest.internal.ui.CopyFailureListAction;
import org.eclipse.unittest.internal.ui.Messages;
import org.eclipse.unittest.internal.ui.RerunAction;
import org.eclipse.unittest.internal.ui.SelectionProviderMediator;
import org.eclipse.unittest.internal.ui.TestRunnerViewPart;
import org.eclipse.unittest.internal.ui.TestSessionLabelProvider;
import org.eclipse.unittest.internal.ui.TestSessionTableContentProvider;
import org.eclipse.unittest.internal.ui.TestSessionTreeContentProvider;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;

class TestViewer {
    private static final ViewerComparator TEST_ELEMENT_ALPHABETIC_ORDER = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            int weight2;
            int weight1 = e1 instanceof ITestSuiteElement ? 0 : 1;
            int n = weight2 = e2 instanceof ITestSuiteElement ? 0 : 1;
            if (weight1 != weight2) {
                return weight1 - weight2;
            }
            return ((TestElement)e1).getTestName().compareTo(((TestElement)e2).getTestName());
        }
    };
    private final FailuresOnlyFilter fFailuresOnlyFilter = new FailuresOnlyFilter();
    private final IgnoredOnlyFilter fIgnoredOnlyFilter = new IgnoredOnlyFilter();
    private final TestRunnerViewPart fTestRunnerPart;
    private final Clipboard fClipboard;
    private PageBook fViewerbook;
    private TreeViewer fTreeViewer;
    private TestSessionTreeContentProvider fTreeContentProvider;
    private TestSessionLabelProvider fTreeLabelProvider;
    private TableViewer fTableViewer;
    private TestSessionLabelProvider fTableLabelProvider;
    private SelectionProviderMediator fSelectionProvider;
    private TestRunnerViewPart.TestResultsLayout fLayoutMode;
    private boolean fTreeHasFilter;
    private boolean fTableHasFilter;
    private TestRunSession fTestRunSession;
    private boolean fTreeNeedsRefresh;
    private boolean fTableNeedsRefresh;
    private HashSet<ITestElement> fNeedUpdate;
    private ITestCaseElement fAutoScrollTarget;
    private LinkedList<ITestSuiteElement> fAutoClose;
    private HashSet<ITestSuiteElement> fAutoExpand;

    public TestViewer(Composite parent, Clipboard clipboard, TestRunnerViewPart runner) {
        this.fTestRunnerPart = runner;
        this.fClipboard = clipboard;
        this.fLayoutMode = TestRunnerViewPart.TestResultsLayout.HIERARCHICAL;
        this.createTestViewers(parent);
        this.registerViewersRefresh();
        this.initContextMenu();
    }

    private void createTestViewers(Composite parent) {
        this.fViewerbook = new PageBook(parent, 0);
        this.fTreeViewer = new TreeViewer((Composite)this.fViewerbook, 516);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeContentProvider = new TestSessionTreeContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeLabelProvider = new TestSessionLabelProvider(this.fTestRunnerPart, TestRunnerViewPart.TestResultsLayout.HIERARCHICAL);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTableViewer = new TableViewer((Composite)this.fViewerbook, 772);
        this.fTableViewer.setUseHashlookup(true);
        TestSessionTableContentProvider fTableContentProvider = new TestSessionTableContentProvider();
        this.fTableViewer.setContentProvider((IContentProvider)fTableContentProvider);
        this.fTableLabelProvider = new TestSessionLabelProvider(this.fTestRunnerPart, TestRunnerViewPart.TestResultsLayout.FLAT);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fTableLabelProvider);
        this.fSelectionProvider = new SelectionProviderMediator(new StructuredViewer[]{this.fTreeViewer, this.fTableViewer}, (StructuredViewer)this.fTreeViewer);
        this.fSelectionProvider.addSelectionChangedListener(new TestSelectionListener());
        TestOpenListener testOpenListener = new TestOpenListener();
        this.fTreeViewer.getTree().addSelectionListener((SelectionListener)testOpenListener);
        this.fTableViewer.getTable().addSelectionListener((SelectionListener)testOpenListener);
        this.fTestRunnerPart.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        this.fViewerbook.showPage((Control)this.fTreeViewer.getTree());
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::handleMenuAboutToShow);
        this.fTestRunnerPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fSelectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)this.fViewerbook);
        this.fTreeViewer.getTree().setMenu(menu);
        this.fTableViewer.getTable().setMenu(menu);
    }

    void handleMenuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        if (!selection.isEmpty()) {
            TestElement testElement = (TestElement)selection.getFirstElement();
            if (testElement instanceof TestSuiteElement) {
                TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
                IAction openTestAction = testSuiteElement.getTestRunSession().getTestViewSupport().getOpenTestAction(this.fTestRunnerPart.getSite().getShell(), testSuiteElement);
                if (openTestAction != null) {
                    manager.add(openTestAction);
                }
                manager.add((IContributionItem)new Separator());
                if (!this.fTestRunnerPart.lastLaunchStillRunning()) {
                    this.addRerunActions(manager, testSuiteElement);
                }
            } else {
                TestCaseElement testCaseElement = (TestCaseElement)testElement;
                IAction openTestAction = testElement.getTestRunSession().getTestViewSupport().getOpenTestAction(this.fTestRunnerPart.getSite().getShell(), testCaseElement);
                if (openTestAction != null) {
                    manager.add(openTestAction);
                }
                manager.add((IContributionItem)new Separator());
                this.addRerunActions(manager, testCaseElement);
            }
            if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ExpandAllAction());
                manager.add((IAction)new CollapseAllAction());
            }
        }
        if (this.fTestRunSession != null && this.fTestRunSession.getCurrentFailureCount() + this.fTestRunSession.getCurrentErrorCount() > 0) {
            if (this.fLayoutMode != TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new CopyFailureListAction(this.fTestRunnerPart, this.fClipboard));
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private void addRerunActions(IMenuManager manager, TestElement testCaseElement) {
        ILaunchConfiguration rerunLaunchConfiguration = testCaseElement.getTestRunSession().getTestViewSupport().getRerunLaunchConfiguration(Collections.singletonList(testCaseElement));
        if (rerunLaunchConfiguration == null) {
            return;
        }
        if (this.fTestRunnerPart.lastLaunchStillRunning()) {
            manager.add((IAction)new RerunAction(rerunLaunchConfiguration, "run"));
        } else {
            try {
                rerunLaunchConfiguration.getType().getSupportedModeCombinations().stream().filter(modes -> modes.size() == 1).flatMap(Collection::stream).forEach(mode -> manager.add((IAction)new RerunAction(rerunLaunchConfiguration, (String)mode)));
            }
            catch (CoreException e) {
                UnitTestPlugin.log(e);
            }
        }
    }

    public Control getTestViewerControl() {
        return this.fViewerbook;
    }

    public synchronized void registerActiveSession(TestRunSession testRunSession) {
        this.fTestRunSession = testRunSession;
        this.registerAutoScrollTarget(null);
        this.registerViewersRefresh();
    }

    void handleDefaultSelected() {
        IAction action;
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TestElement testElement = (TestElement)selection.getFirstElement();
        if (testElement instanceof ITestSuiteElement) {
            action = testElement.getTestRunSession().getTestViewSupport().getOpenTestAction(this.fTestRunnerPart.getSite().getShell(), (ITestSuiteElement)((Object)testElement));
        } else if (testElement instanceof ITestCaseElement) {
            action = testElement.getTestRunSession().getTestViewSupport().getOpenTestAction(this.fTestRunnerPart.getSite().getShell(), (ITestCaseElement)((Object)testElement));
        } else {
            throw new IllegalStateException(String.valueOf(testElement));
        }
        if (action != null && action.isEnabled()) {
            action.run();
        }
    }

    public synchronized void setShowTime(boolean showTime) {
        try {
            this.fViewerbook.setRedraw(false);
            this.fTreeLabelProvider.setShowTime(showTime);
            this.fTableLabelProvider.setShowTime(showTime);
        }
        finally {
            this.fViewerbook.setRedraw(true);
        }
    }

    public synchronized void setShowFailuresOrIgnoredOnly(boolean failuresOnly, boolean ignoredOnly, TestRunnerViewPart.TestResultsLayout layoutMode) {
        try {
            boolean switchLayout;
            this.fViewerbook.setRedraw(false);
            IStructuredSelection selection = null;
            boolean bl = switchLayout = layoutMode != this.fLayoutMode;
            if (switchLayout) {
                selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
                if (layoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
                    if (this.fTreeNeedsRefresh) {
                        this.clearUpdateAndExpansion();
                    }
                } else if (this.fTableNeedsRefresh) {
                    this.clearUpdateAndExpansion();
                }
                this.fLayoutMode = layoutMode;
                this.fViewerbook.showPage(this.getActiveViewer().getControl());
            }
            StructuredViewer viewer = this.getActiveViewer();
            if (failuresOnly || ignoredOnly) {
                if (this.getActiveViewerHasFilter()) {
                    viewer.removeFilter((ViewerFilter)this.fFailuresOnlyFilter);
                    viewer.removeFilter((ViewerFilter)this.fIgnoredOnlyFilter);
                }
                this.setActiveViewerHasFilter(true);
                viewer.setInput(null);
                ViewerFilter filter = this.fFailuresOnlyFilter;
                if (ignoredOnly) {
                    filter = this.fIgnoredOnlyFilter;
                }
                viewer.addFilter(filter);
                this.setActiveViewerNeedsRefresh(true);
            } else if (this.getActiveViewerHasFilter()) {
                this.setActiveViewerNeedsRefresh(true);
                this.setActiveViewerHasFilter(false);
                viewer.setInput(null);
                viewer.removeFilter((ViewerFilter)this.fIgnoredOnlyFilter);
                viewer.removeFilter((ViewerFilter)this.fFailuresOnlyFilter);
            }
            this.processChangesInUI();
            if (selection != null) {
                StructuredSelection flatSelection = new StructuredSelection(selection.toList());
                this.fSelectionProvider.setSelection((ISelection)flatSelection, true);
            }
        }
        finally {
            this.fViewerbook.setRedraw(true);
        }
    }

    private boolean getActiveViewerHasFilter() {
        if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
            return this.fTreeHasFilter;
        }
        return this.fTableHasFilter;
    }

    private void setActiveViewerHasFilter(boolean filter) {
        if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
            this.fTreeHasFilter = filter;
        } else {
            this.fTableHasFilter = filter;
        }
    }

    private StructuredViewer getActiveViewer() {
        if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
            return this.fTreeViewer;
        }
        return this.fTableViewer;
    }

    private boolean getActiveViewerNeedsRefresh() {
        if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
            return this.fTreeNeedsRefresh;
        }
        return this.fTableNeedsRefresh;
    }

    private void setActiveViewerNeedsRefresh(boolean needsRefresh) {
        if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
            this.fTreeNeedsRefresh = needsRefresh;
        } else {
            this.fTableNeedsRefresh = needsRefresh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangesInUI() {
        if (this.fTestRunSession == null) {
            this.registerViewersRefresh();
            this.fTreeNeedsRefresh = false;
            this.fTableNeedsRefresh = false;
            this.fTreeViewer.setInput(null);
            this.fTableViewer.setInput(null);
            return;
        }
        StructuredViewer viewer = this.getActiveViewer();
        if (this.getActiveViewerNeedsRefresh()) {
            this.clearUpdateAndExpansion();
            this.setActiveViewerNeedsRefresh(false);
            viewer.setInput((Object)this.fTestRunnerPart);
        } else {
            Object element;
            int n;
            Object[] objectArray;
            Object[] toUpdate;
            TestViewer testViewer = this;
            synchronized (testViewer) {
                toUpdate = this.fNeedUpdate.toArray();
                this.fNeedUpdate.clear();
            }
            if (!this.fTreeNeedsRefresh && toUpdate.length > 0) {
                if (this.fTreeHasFilter) {
                    objectArray = toUpdate;
                    n = toUpdate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        element = objectArray[n2];
                        this.updateElementInTree((TestElement)element);
                        ++n2;
                    }
                } else {
                    HashSet<Object> toUpdateWithParents = new HashSet<Object>();
                    toUpdateWithParents.addAll(Arrays.asList(toUpdate));
                    Object[] objectArray2 = toUpdate;
                    int n3 = toUpdate.length;
                    n = 0;
                    while (n < n3) {
                        Object element2 = objectArray2[n];
                        ITestSuiteElement parent = ((ITestElement)element2).getParent();
                        while (parent != null) {
                            toUpdateWithParents.add(parent);
                            parent = parent.getParent();
                        }
                        ++n;
                    }
                    this.fTreeViewer.update(toUpdateWithParents.toArray(), null);
                }
            }
            if (!this.fTableNeedsRefresh && toUpdate.length > 0) {
                if (this.fTableHasFilter) {
                    objectArray = toUpdate;
                    n = toUpdate.length;
                    int n4 = 0;
                    while (n4 < n) {
                        element = objectArray[n4];
                        this.updateElementInTable((TestElement)element);
                        ++n4;
                    }
                } else {
                    this.fTableViewer.update(toUpdate, null);
                }
            }
        }
        this.autoScrollInUI();
    }

    private void updateElementInTree(TestElement testElement) {
        if (this.isShown(testElement)) {
            this.updateShownElementInTree(testElement);
        } else {
            TestElement current = testElement;
            do {
                if (this.fTreeViewer.testFindItem((Object)current) == null) continue;
                this.fTreeViewer.remove((Object)current);
            } while (!((current = current.getParent()) instanceof ITestRunSession) && !this.isShown(current));
            while (current != null && !(current instanceof ITestRunSession)) {
                this.fTreeViewer.update((Object)current, null);
                current = current.getParent();
            }
        }
    }

    private void updateShownElementInTree(ITestElement testElement) {
        if (testElement == null || testElement instanceof ITestRunSession) {
            return;
        }
        ITestSuiteElement parent = testElement.getParent();
        this.updateShownElementInTree(parent);
        if (this.fTreeViewer.testFindItem((Object)testElement) == null) {
            this.fTreeViewer.add((Object)parent, (Object)testElement);
        } else {
            this.fTreeViewer.update((Object)testElement, null);
        }
    }

    private void updateElementInTable(TestElement element) {
        if (this.isShown(element)) {
            if (this.fTableViewer.testFindItem((Object)element) == null) {
                TableItem item;
                TestElement previous = this.getNextFailure(element, false);
                int insertionIndex = -1;
                if (previous != null && (item = (TableItem)this.fTableViewer.testFindItem((Object)previous)) != null) {
                    insertionIndex = this.fTableViewer.getTable().indexOf(item);
                }
                this.fTableViewer.insert((Object)element, insertionIndex);
            } else {
                this.fTableViewer.update((Object)element, null);
            }
        } else {
            this.fTableViewer.remove((Object)element);
        }
    }

    private boolean isShown(TestElement current) {
        return this.fFailuresOnlyFilter.select(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoScrollInUI() {
        ITestSuiteElement parent;
        if (!this.fTestRunnerPart.isAutoScroll()) {
            this.clearAutoExpand();
            this.fAutoClose.clear();
            return;
        }
        if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.FLAT) {
            if (this.fAutoScrollTarget != null) {
                this.fTableViewer.reveal((Object)this.fAutoScrollTarget);
            }
            return;
        }
        TestViewer testViewer = this;
        synchronized (testViewer) {
            for (ITestSuiteElement suite : this.fAutoExpand) {
                this.fTreeViewer.setExpandedState((Object)suite, true);
            }
            this.clearAutoExpand();
        }
        ITestCaseElement current = this.fAutoScrollTarget;
        this.fAutoScrollTarget = null;
        ITestSuiteElement iTestSuiteElement = parent = current == null ? null : (ITestSuiteElement)this.fTreeContentProvider.getParent(current);
        if (this.fAutoClose.isEmpty() || !this.fAutoClose.getLast().equals(parent)) {
            ListIterator<ITestSuiteElement> iter = this.fAutoClose.listIterator(this.fAutoClose.size());
            while (iter.hasPrevious()) {
                ITestSuiteElement previousAutoOpened = iter.previous();
                if (previousAutoOpened.equals(parent)) break;
                if (((TestElement)((Object)previousAutoOpened)).getStatus() != Status.OK) continue;
                iter.remove();
                this.fTreeViewer.collapseToLevel((Object)previousAutoOpened, -1);
            }
            while (parent != null && !this.fTestRunSession.equals(parent) && !this.fTreeViewer.getExpandedState((Object)parent)) {
                this.fAutoClose.add(parent);
                parent = (ITestSuiteElement)this.fTreeContentProvider.getParent(parent);
            }
        }
        if (current != null) {
            this.fTreeViewer.reveal((Object)current);
        }
    }

    public void selectFirstFailure() {
        TestElement firstFailure = this.getNextChildFailure(this.fTestRunSession, true);
        if (firstFailure != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)firstFailure), true);
        }
    }

    public void selectFailure(boolean showNext) {
        IStructuredSelection selection = (IStructuredSelection)this.getActiveViewer().getSelection();
        TestElement selected = (TestElement)selection.getFirstElement();
        TestElement next = selected == null ? this.getNextChildFailure(this.fTestRunSession, showNext) : this.getNextFailure(selected, showNext);
        if (next != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)next), true);
        }
    }

    private TestElement getNextFailure(TestElement selected, boolean showNext) {
        TestElement nextChild;
        if (selected instanceof TestSuiteElement && (nextChild = this.getNextChildFailure((TestSuiteElement)selected, showNext)) != null) {
            return nextChild;
        }
        return this.getNextFailureSibling(selected, showNext);
    }

    private TestElement getNextFailureSibling(TestElement current, boolean showNext) {
        int nextIndex;
        TestSuiteElement parent = current.getParent();
        if (parent == null) {
            return null;
        }
        List<TestElement> siblings = this.getSortedChildren(parent);
        if (!showNext) {
            siblings = new ReverseList<TestElement>(siblings);
        }
        int i = nextIndex = siblings.indexOf(current) + 1;
        while (i < siblings.size()) {
            TestElement sibling = siblings.get(i);
            if (sibling.getStatus().isErrorOrFailure()) {
                if (sibling instanceof ITestCaseElement) {
                    return sibling;
                }
                TestSuiteElement testSuiteElement = (TestSuiteElement)sibling;
                if (testSuiteElement.getChildren().isEmpty()) {
                    return testSuiteElement;
                }
                return this.getNextChildFailure(testSuiteElement, showNext);
            }
            ++i;
        }
        return this.getNextFailureSibling(parent, showNext);
    }

    private TestElement getNextChildFailure(TestSuiteElement root, boolean showNext) {
        List<TestElement> children = this.getSortedChildren(root);
        if (!showNext) {
            children = new ReverseList<TestElement>(children);
        }
        for (TestElement child : children) {
            if (!child.getStatus().isErrorOrFailure()) continue;
            if (child instanceof ITestCaseElement) {
                return child;
            }
            TestSuiteElement testSuiteElement = (TestSuiteElement)child;
            if (testSuiteElement.getChildren().isEmpty()) {
                return testSuiteElement;
            }
            return this.getNextChildFailure(testSuiteElement, showNext);
        }
        return null;
    }

    private List<TestElement> getSortedChildren(TestSuiteElement parent) {
        ArrayList<TestElement> siblings = new ArrayList<TestElement>(parent.getChildren());
        ViewerComparator comparator = this.fTreeViewer.getComparator();
        if (comparator != null) {
            siblings.sort((e1, e2) -> comparator.compare((Viewer)this.fTreeViewer, e1, e2));
        }
        return siblings;
    }

    public synchronized void registerViewersRefresh() {
        this.fTreeNeedsRefresh = true;
        this.fTableNeedsRefresh = true;
        this.clearUpdateAndExpansion();
    }

    private void clearUpdateAndExpansion() {
        this.fNeedUpdate = new LinkedHashSet<ITestElement>();
        this.fAutoClose = new LinkedList();
        this.fAutoExpand = new HashSet();
    }

    public synchronized void registerTestAdded(ITestElement testElement) {
        this.fTreeNeedsRefresh = true;
        this.fTableNeedsRefresh = true;
    }

    public synchronized void registerViewerUpdate(ITestElement testElement) {
        this.fNeedUpdate.add(testElement);
    }

    private synchronized void clearAutoExpand() {
        this.fAutoExpand.clear();
    }

    public void registerAutoScrollTarget(ITestCaseElement testCaseElement) {
        this.fAutoScrollTarget = testCaseElement;
    }

    public synchronized void registerFailedForAutoScroll(ITestElement testElement) {
        TestSuiteElement parent = (TestSuiteElement)this.fTreeContentProvider.getParent(testElement);
        if (parent != null) {
            this.fAutoExpand.add(parent);
        }
    }

    public void expandFirstLevel() {
        this.fTreeViewer.expandToLevel(2);
    }

    public void setAlphabeticalSort(boolean enableAlphabeticalSort) {
        this.fTreeViewer.setComparator((ViewerComparator)(enableAlphabeticalSort ? TEST_ELEMENT_ALPHABETIC_ORDER : null));
        this.fTreeViewer.refresh();
    }

    public boolean isAlphabeticalSort() {
        return this.fTreeViewer.getComparator() == TEST_ELEMENT_ALPHABETIC_ORDER;
    }

    private class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setText(Messages.CollapseAllAction_text);
            this.setToolTipText(Messages.CollapseAllAction_tooltip);
        }

        public void run() {
            TestViewer.this.fTreeViewer.collapseAll();
        }
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(Messages.ExpandAllAction_text);
            this.setToolTipText(Messages.ExpandAllAction_tooltip);
        }

        public void run() {
            TestViewer.this.fTreeViewer.expandAll();
        }
    }

    private final class FailuresOnlyFilter
    extends ViewerFilter {
        private FailuresOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select((TestElement)element);
        }

        public boolean select(TestElement testElement) {
            Status status = testElement.getStatus();
            if (status.isErrorOrFailure()) {
                return true;
            }
            return !TestViewer.this.fTestRunSession.isRunning() && status == Status.RUNNING;
        }
    }

    private final class IgnoredOnlyFilter
    extends ViewerFilter {
        private IgnoredOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select((TestElement)element);
        }

        public boolean select(TestElement testElement) {
            if (this.hasIgnoredInTestResult(testElement)) {
                return true;
            }
            return !TestViewer.this.fTestRunSession.isRunning() && testElement.getStatus() == Status.RUNNING;
        }

        private boolean hasIgnoredInTestResult(TestElement testElement) {
            if (testElement instanceof TestSuiteElement) {
                List<TestElement> children = ((TestSuiteElement)testElement).getChildren();
                for (TestElement child : children) {
                    boolean hasIgnoredTestResult = this.hasIgnoredInTestResult(child);
                    if (!hasIgnoredTestResult) continue;
                    return true;
                }
                return false;
            }
            return testElement.getTestResult(false) == ITestElement.Result.IGNORED;
        }
    }

    private static class ReverseList<E>
    extends AbstractList<E> {
        private final List<E> fList;

        public ReverseList(List<E> list) {
            this.fList = list;
        }

        @Override
        public E get(int index) {
            return this.fList.get(this.fList.size() - index - 1);
        }

        @Override
        public int size() {
            return this.fList.size();
        }
    }

    private final class TestOpenListener
    extends SelectionAdapter {
        private TestOpenListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TestViewer.this.handleDefaultSelected();
        }
    }

    private final class TestSelectionListener
    implements ISelectionChangedListener {
        private TestSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)TestViewer.this.fSelectionProvider.getSelection();
            TestElement testElement = null;
            if (selection.size() == 1) {
                testElement = (TestElement)selection.getFirstElement();
            }
            TestViewer.this.fTestRunnerPart.handleTestSelected(testElement);
        }
    }
}

