/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class ReflectionConstantAccess
extends StaticDispatch {
    private Expression constant;
    public static final ChildPropertyDescriptor CLASS_NAME_PROPERTY = new ChildPropertyDescriptor(ReflectionConstantAccess.class, "className", Expression.class, true, false);
    public static final ChildPropertyDescriptor CONSTANT_PROPERTY = new ChildPropertyDescriptor(ReflectionConstantAccess.class, "parameterType", Expression.class, true, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> properyList = new ArrayList<ChildPropertyDescriptor>(2);
        properyList.add(CLASS_NAME_PROPERTY);
        properyList.add(CONSTANT_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    @Override
    ChildPropertyDescriptor getClassNameProperty() {
        return CLASS_NAME_PROPERTY;
    }

    public ReflectionConstantAccess(int start, int end, AST ast, Expression className, Expression constant) {
        super(start, end, ast, className);
        if (constant == null) {
            throw new IllegalArgumentException();
        }
        this.setConstant(constant);
    }

    public ReflectionConstantAccess(AST ast) {
        super(ast);
    }

    public ReflectionConstantAccess(int start, int end, AST ast, Identifier name) {
        this(start, end, ast, null, name);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.getClassName().accept(visitor);
        this.constant.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getClassName().traverseTopDown(visitor);
        this.constant.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.getClassName().traverseTopDown(visitor);
        this.constant.traverseTopDown(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<ReflectionConstantAccess");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<ClassName>\n");
        this.getClassName().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</ClassName>\n");
        buffer.append("\t").append(tab).append("<Constant>\n");
        this.constant.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Constant>\n");
        buffer.append(tab).append("</ReflectionConstantAccess>");
    }

    @Override
    public int getType() {
        return 92;
    }

    public Expression getConstant() {
        return this.constant;
    }

    public void setConstant(Expression name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.constant;
        this.preReplaceChild(oldChild, name, CONSTANT_PROPERTY);
        this.constant = name;
        this.postReplaceChild(oldChild, name, CONSTANT_PROPERTY);
    }

    @Override
    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CONSTANT_PROPERTY) {
            if (get) {
                return this.getConstant();
            }
            this.setConstant((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public ASTNode getMember() {
        return this.getConstant();
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression className = ASTNode.copySubtree(target, this.getClassName());
        Expression constant = ASTNode.copySubtree(target, this.getConstant());
        ReflectionConstantAccess result = new ReflectionConstantAccess(this.getStart(), this.getEnd(), target, className, constant);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IVariableBinding resolveFieldBinding() {
        return this.ast.getBindingResolver().resolveField(this);
    }
}

