/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ua.core.toc.text.TocMarkerManager;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocFormOutlinePage;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocInputContext;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocInputContextManager;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocMessages;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocPage;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocSourcePage;
import org.eclipse.pde.internal.ua.ui.wizards.toc.RegisterTocWizard;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class TocEditor
extends MultiSourceEditor {
    private ImageHyperlink fImageHyperlinkRegisterTOC;

    protected String getEditorID() {
        return "org.eclipse.pde.ua.ui.tocEditor";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.inUiThread() && this.isShowInApplicable() && adapter == IShowInSource.class) {
            return adapter.cast(this.getShowInSource());
        }
        if (adapter == IShowInTargetList.class) {
            return adapter.cast(this.getShowInTargetList());
        }
        return (T)super.getAdapter(adapter);
    }

    private boolean inUiThread() {
        Display display = this.getSite().getWorkbenchWindow().getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            return display.getThread() == Thread.currentThread();
        }
        return false;
    }

    private boolean isShowInApplicable() {
        if (this.getSelection().isEmpty()) {
            return false;
        }
        if (this.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            for (Object obj : selection) {
                if (!(obj instanceof TocObject)) {
                    return false;
                }
                if (((TocObject)obj).getPath() != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private IShowInSource getShowInSource() {
        return () -> {
            StructuredSelection resources;
            ArrayList<IResource> resourceList = new ArrayList<IResource>();
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            if (selection.isEmpty()) {
                resources = null;
            } else {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                for (Object obj : selection) {
                    IPath pluginPath;
                    IResource resource;
                    IProject project;
                    TocModel model;
                    IResource underlyingResource;
                    IPath resourcePath;
                    if (!(obj instanceof TocObject) || ((TocObject)obj).getPath() == null || (resourcePath = IPath.fromOSString((String)((TocObject)obj).getPath())).isEmpty() || (underlyingResource = (model = (TocModel)this.getAggregateModel()).getUnderlyingResource()) == null || (project = underlyingResource.getProject()) == null || (resource = root.findMember((pluginPath = project.getFullPath()).append(resourcePath))) == null) continue;
                    resourceList.add(resource);
                }
                resources = new StructuredSelection(resourceList);
            }
            return new ShowInContext(null, resources);
        };
    }

    private IShowInTargetList getShowInTargetList() {
        return () -> new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.navigator.ProjectExplorer"};
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContextIDForSaveAs() {
        return "toc-context";
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new TocPage((FormEditor)this));
        }
        catch (PartInitException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
        this.addSourcePage("toc-context");
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new TocFormOutlinePage((PDEFormEditor)this);
    }

    protected InputContextManager createInputContextManager() {
        return new TocInputContextManager((PDEFormEditor)this);
    }

    protected void createResourceContexts(InputContextManager contexts, IFileEditorInput input) {
        contexts.putContext((IEditorInput)input, (InputContext)new TocInputContext((PDEFormEditor)this, (IEditorInput)input, true));
        contexts.monitorFile(input.getFile());
    }

    protected void createStorageContexts(InputContextManager contexts, IStorageEditorInput input) {
        contexts.putContext((IEditorInput)input, (InputContext)new TocInputContext((PDEFormEditor)this, (IEditorInput)input, true));
    }

    protected void createSystemFileContexts(InputContextManager contexts, FileStoreEditorInput input) {
        try {
            IFileStore store = EFS.getStore((URI)input.getURI());
            FileStoreEditorInput in = new FileStoreEditorInput(store);
            contexts.putContext((IEditorInput)in, (InputContext)new TocInputContext((PDEFormEditor)this, (IEditorInput)in, true));
        }
        catch (CoreException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("toc-context");
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    public ISelection getSelection() {
        IFormPage formPage = this.getActivePageInstance();
        if (formPage != null && formPage instanceof TocPage) {
            return ((TocPage)formPage).getSelection();
        }
        return super.getSelection();
    }

    public boolean canCut(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object obj : sel) {
                if (!(obj instanceof TocObject) || !((TocObject)obj).canBeRemoved()) continue;
                return this.canCopy(selection);
            }
        }
        return false;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new TocSourcePage(editor, title, name);
    }

    public void contributeToToolbar(IToolBarManager manager) {
        if (WorkspaceModelManager.isPluginProject((IProject)this.getCommonProject()) && this.getAggregateModel().isEditable()) {
            manager.add((IContributionItem)this.createUIControlConRegisterCS());
        }
    }

    private ControlContribution createUIControlConRegisterCS() {
        return new ControlContribution("Register"){

            protected Control createControl(Composite parent) {
                TocEditor.this.createUIImageHyperlinkRegisterToc(parent);
                TocEditor.this.createUIListenerImageHyperlinkRegisterToc();
                return TocEditor.this.fImageHyperlinkRegisterTOC;
            }
        };
    }

    private void createUIImageHyperlinkRegisterToc(Composite parent) {
        this.fImageHyperlinkRegisterTOC = new ImageHyperlink(parent, 0);
        this.fImageHyperlinkRegisterTOC.setText(TocMessages.TocEditor_link);
        this.fImageHyperlinkRegisterTOC.setUnderlined(true);
        this.fImageHyperlinkRegisterTOC.setForeground(this.getToolkit().getHyperlinkGroup().getForeground());
    }

    private void createUIListenerImageHyperlinkRegisterToc() {
        this.fImageHyperlinkRegisterTOC.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TocEditor.this.handleLinkActivatedRegisterTOC();
            }

            public void linkEntered(HyperlinkEvent e) {
                TocEditor.this.handleLinkEnteredRegisterTOC(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                TocEditor.this.handleLinkExitedRegisterTOC();
            }
        });
    }

    private void handleLinkEnteredRegisterTOC(String message) {
        this.fImageHyperlinkRegisterTOC.setForeground(this.getToolkit().getHyperlinkGroup().getActiveForeground());
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    private void handleLinkExitedRegisterTOC() {
        this.fImageHyperlinkRegisterTOC.setForeground(this.getToolkit().getHyperlinkGroup().getForeground());
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(null);
    }

    private void handleLinkActivatedRegisterTOC() {
        RegisterTocWizard wizard = new RegisterTocWizard((IModel)this.getAggregateModel());
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(400, 250);
        dialog.open();
    }

    public void doSave(IProgressMonitor monitor) {
        TocModel model = (TocModel)this.getAggregateModel();
        model.setMarkerRefreshNeeded(true);
        super.doSave(monitor);
        model.reconciled(model.getDocument());
    }

    public void dispose() {
        TocMarkerManager.deleteMarkers((TocModel)((TocModel)this.getAggregateModel()));
        super.dispose();
    }

    protected void createInputContexts(InputContextManager contextManager) {
        super.createInputContexts(contextManager);
        TocMarkerManager.createMarkers((TocModel)((TocModel)this.getAggregateModel()));
    }
}

