/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractCustomizable;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.Option;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.osgi.util.NLS;

public class BasicEvaluationEnvironment
extends AbstractCustomizable
implements EvaluationEnvironment.EvaluationEnvironmentExtension {
    protected final @NonNull ExecutorInternal executor;
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @Nullable EvaluationEnvironment parent;
    protected final @NonNull NamedElement executableObject;
    protected final @Nullable Object caller;
    @Deprecated
    protected final @Nullable OCLExpression callingObject;
    private final @NonNull Map<TypedElement, Object> variableValues = new HashMap<TypedElement, Object>();
    @Deprecated
    protected final @NonNull ModelManager modelManager;

    @Deprecated
    public BasicEvaluationEnvironment(@NonNull EnvironmentFactory environmentFactory, @NonNull NamedElement executableObject, @NonNull ModelManager modelManager) {
        this(((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory).createExecutor(modelManager), executableObject);
    }

    public BasicEvaluationEnvironment(@NonNull ExecutorInternal executor, @NonNull NamedElement executableObject) {
        this.executor = executor;
        this.environmentFactory = executor.getEnvironmentFactory();
        this.parent = null;
        this.executableObject = executableObject;
        this.caller = null;
        this.callingObject = null;
        this.modelManager = executor.getModelManager();
    }

    @Deprecated
    public BasicEvaluationEnvironment(@NonNull EvaluationEnvironment parent, @NonNull NamedElement executableObject) {
        this((EvaluationEnvironment.EvaluationEnvironmentExtension)parent, executableObject, null);
    }

    public BasicEvaluationEnvironment(@NonNull EvaluationEnvironment.EvaluationEnvironmentExtension parent, @NonNull NamedElement executableObject, @Nullable Object caller) {
        this.executor = parent.getExecutor();
        this.environmentFactory = parent.getEnvironmentFactory();
        this.parent = parent;
        this.executableObject = executableObject;
        this.caller = caller;
        this.callingObject = caller instanceof OCLExpression ? (OCLExpression)caller : null;
        this.modelManager = this.executor.getModelManager();
    }

    @Deprecated
    public BasicEvaluationEnvironment(@NonNull EvaluationEnvironment.EvaluationEnvironmentExtension parent, @NonNull NamedElement executableObject, @Nullable OCLExpression caller) {
        this(parent, executableObject, (Object)caller);
    }

    @Override
    public void add(@NonNull TypedElement referredVariable, @Nullable Object value) {
        Object oldValue;
        if (this.variableValues.containsKey(referredVariable) && (oldValue = this.variableValues.get(referredVariable)) != value && (oldValue == null || !oldValue.equals(value))) {
            String message = NLS.bind((String)PivotMessagesInternal.BindingExist_ERROR_, (Object)referredVariable, (Object)oldValue);
            throw new IllegalArgumentException(message);
        }
        this.variableValues.put(referredVariable, value);
    }

    @Override
    public void clear() {
        this.variableValues.clear();
    }

    @Override
    public void dispose() {
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public @NonNull NamedElement getExecutableObject() {
        return this.executableObject;
    }

    @Override
    public @NonNull ExecutorInternal getExecutor() {
        return this.executor;
    }

    @Override
    @Deprecated
    public @NonNull ModelManager getModelManager() {
        return this.executor.getModelManager();
    }

    @Override
    public @Nullable EvaluationEnvironment getParent() {
        return this.parent;
    }

    @Override
    public @Nullable EvaluationEnvironment.EvaluationEnvironmentExtension getParentEvaluationEnvironment() {
        return (EvaluationEnvironment.EvaluationEnvironmentExtension)this.parent;
    }

    @Override
    public <T> T getValue(@NonNull Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result == null) {
            EvaluationEnvironment parent2 = this.parent;
            result = parent2 != null ? parent2.getValue(option) : option.getDefaultValue();
        }
        return (T)result;
    }

    @Override
    public @Nullable Object getValueOf(@NonNull TypedElement referredVariable) {
        Object object = this.variableValues.get(referredVariable);
        if (object == null && !this.variableValues.containsKey(referredVariable)) {
            EvaluationEnvironment parent2 = this.parent;
            if (parent2 != null) {
                object = parent2.getValueOf(referredVariable);
            } else {
                throw new InvalidValueException("Undefined Variable " + referredVariable, new Object[0]);
            }
        }
        return object;
    }

    @Override
    public @NonNull Set<TypedElement> getVariables() {
        return this.variableValues.keySet();
    }

    @Override
    public @Nullable Object remove(@NonNull TypedElement referredVariable) {
        return this.variableValues.remove(referredVariable);
    }

    @Override
    public void replace(@NonNull TypedElement referredVariable, @Nullable Object value) {
        this.variableValues.put(referredVariable, value);
    }

    public String toString() {
        return this.variableValues.toString();
    }
}

