/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.wizards;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.ControlListItem;
import org.eclipse.mylyn.commons.ui.ControlListViewer;
import org.eclipse.mylyn.commons.ui.GradientCanvas;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.tasks.bugs.AbstractSupportElement;
import org.eclipse.mylyn.internal.tasks.bugs.SupportCategory;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProduct;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProvider;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.Messages;
import org.eclipse.mylyn.tasks.bugs.IProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class SelectSupportElementPage
extends WizardPage {
    private static final int TABLE_HEIGHT = 200;
    private AbstractSupportElement selectedElement;
    private ImageRegistry imageRegistry;
    private final IStructuredContentProvider contentProvider;
    private Object input;

    public SelectSupportElementPage(String pageName, IStructuredContentProvider contentProvider) {
        super(pageName);
        this.contentProvider = contentProvider;
    }

    public Image getImage(AbstractSupportElement data) {
        Image image;
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry(this.getShell().getDisplay());
        }
        if ((image = this.imageRegistry.get(data.getId())) == null && data.getIcon() != null) {
            this.imageRegistry.put(data.getId(), data.getIcon());
            image = this.imageRegistry.get(data.getId());
        }
        return image;
    }

    public void setInput(Object input) {
        this.input = input;
        if (input instanceof IProvider) {
            this.setTitle(Messages.SelectSupportElementPage_Supported_Product_Title);
            this.setMessage(Messages.SelectSupportElementPage_Support_Product_Description);
        } else {
            this.setTitle(Messages.SelectSupportElementPage_Support_Provider_Title);
            this.setMessage(Messages.SelectSupportElementPage_Support_Provider_Description);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        SupportElementViewer viewer = new SupportElementViewer(container, 2564);
        GridDataFactory.fillDefaults().grab(true, true).hint(500, 200).applyTo((Control)viewer.getControl());
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object object = selection.getFirstElement();
            this.selectedElement = object instanceof AbstractSupportElement ? (AbstractSupportElement)object : null;
            this.updatePageStatus();
        });
        viewer.addOpenListener(event -> {
            if (this.getWizard().canFinish()) {
                if (this.getWizard().performFinish()) {
                    ((WizardDialog)this.getContainer()).close();
                }
            } else {
                IWizardPage nextPage = this.getNextPage();
                if (nextPage != null) {
                    ((WizardDialog)this.getContainer()).showPage(nextPage);
                }
            }
        });
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                int cat2;
                int cat1 = this.category(o1);
                if (cat1 != (cat2 = this.category(o2))) {
                    return cat1 - cat2;
                }
                if (o1 instanceof AbstractSupportElement && o2 instanceof AbstractSupportElement) {
                    return this.getComparator().compare(((AbstractSupportElement)o1).getName(), ((AbstractSupportElement)o2).getName());
                }
                return super.compare(viewer, o1, o2);
            }

            public int category(Object element) {
                if (element instanceof SupportCategory) {
                    return ((SupportCategory)element).getWeight() * 2;
                }
                if (element instanceof SupportProvider && ((SupportProvider)element).getCategory() != null) {
                    return ((SupportProvider)element).getCategory().getWeight() * 2 + 1;
                }
                return super.category(element);
            }
        });
        viewer.setInput(this.input);
        Object[] elements = this.contentProvider.getElements(this.input);
        if (elements.length == 1) {
            viewer.setSelection((ISelection)new StructuredSelection(elements[0]));
        } else {
            this.setPageComplete(false);
        }
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    public void dispose() {
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
        }
        super.dispose();
    }

    public AbstractSupportElement getSelectedElement() {
        return this.selectedElement;
    }

    private void updatePageStatus() {
        if (this.selectedElement instanceof SupportProvider) {
            if (this.contentProvider.getElements((Object)this.selectedElement).length > 0) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(Messages.SelectSupportElementPage_No_products_Message);
                this.setPageComplete(false);
            }
        } else if (this.selectedElement instanceof SupportProduct) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(false);
        }
    }

    public IWizardPage getNextPage() {
        if (this.selectedElement instanceof SupportProvider) {
            SelectSupportElementPage page = new SelectSupportElementPage(this.selectedElement.getId(), this.contentProvider);
            page.setInput(this.selectedElement);
            page.setWizard(this.getWizard());
            return page;
        }
        return super.getNextPage();
    }

    private class SupportElementItem
    extends ControlListItem {
        private static final int ICON_GAP = 10;
        private ToolBar toolBar;
        private Label titleLabel;
        private Label iconLabel;
        private Label descriptionLabel;
        private ToolBarManager toolBarManager;
        private boolean gradientBackground;
        private GradientCanvas canvas;

        public SupportElementItem(Composite parent, int style, Object element) {
            super(parent, style, element);
            this.registerChild((Control)this.titleLabel);
            this.registerChild((Control)this.iconLabel);
            this.registerChild((Control)this.descriptionLabel);
            this.registerChild((Control)this.toolBar);
        }

        public void setGradientBackground(boolean gradientBackground) {
            this.gradientBackground = gradientBackground;
            if (gradientBackground) {
                IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
                Color colorCategoryGradientStart = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.start");
                Color colorCategoryGradientEnd = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
                this.canvas.setSeparatorVisible(true);
                this.canvas.setSeparatorAlignment(128);
                this.canvas.setBackgroundGradient(new Color[]{colorCategoryGradientStart, colorCategoryGradientEnd}, new int[]{100}, true);
                this.canvas.putColor(GradientCanvas.H_BOTTOM_KEYLINE1, colorCategoryGradientStart);
                this.canvas.putColor(GradientCanvas.H_BOTTOM_KEYLINE2, colorCategoryGradientEnd);
            }
        }

        public boolean isGradientBackground() {
            return this.gradientBackground;
        }

        protected void createContent() {
            this.setLayout((Layout)new FillLayout());
            this.canvas = new GradientCanvas((Composite)this, 0);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 3;
            layout.marginWidth = 3;
            this.canvas.setLayout((Layout)layout);
            this.iconLabel = new Label((Composite)this.canvas, 0);
            FormData fd = new FormData();
            fd.left = new FormAttachment(0);
            this.iconLabel.setLayoutData((Object)fd);
            this.titleLabel = new Label((Composite)this.canvas, 0);
            this.titleLabel.setFont(JFaceResources.getBannerFont());
            fd = new FormData();
            fd.left = new FormAttachment((Control)this.iconLabel, 10);
            this.titleLabel.setLayoutData((Object)fd);
            this.descriptionLabel = new Label((Composite)this.canvas, 64);
            this.toolBarManager = new ToolBarManager(0x800000);
            this.toolBar = this.toolBarManager.createControl((Composite)this.canvas);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.titleLabel, 5);
            fd.left = new FormAttachment((Control)this.iconLabel, 10);
            fd.right = new FormAttachment((Control)this.toolBar, -5);
            this.descriptionLabel.setLayoutData((Object)fd);
            fd = new FormData();
            fd.right = new FormAttachment(100);
            this.toolBar.setLayoutData((Object)fd);
            this.refresh();
        }

        public void dispose() {
            super.dispose();
            this.toolBarManager.dispose();
        }

        public void setBackground(Color color) {
            if (this.isGradientBackground()) {
                return;
            }
            super.setBackground(color);
        }

        public void setForeground(Color color) {
            if (this.isGradientBackground()) {
                return;
            }
            super.setForeground(color);
            if (this.isSelected()) {
                this.titleLabel.setForeground(color);
                this.descriptionLabel.setForeground(color);
            } else {
                this.titleLabel.setForeground(color);
                this.descriptionLabel.setForeground(this.getDisplay().getSystemColor(16));
            }
        }

        protected void refresh() {
            AbstractSupportElement data = (AbstractSupportElement)this.getData();
            Image image = SelectSupportElementPage.this.getImage(data);
            if (image == null) {
                ((FormData)this.titleLabel.getLayoutData()).left = new FormAttachment(0);
                ((FormData)this.descriptionLabel.getLayoutData()).left = new FormAttachment(0);
            } else {
                ((FormData)this.titleLabel.getLayoutData()).left = new FormAttachment((Control)this.iconLabel, 10);
                ((FormData)this.descriptionLabel.getLayoutData()).left = new FormAttachment((Control)this.iconLabel, 10);
            }
            this.iconLabel.setImage(image);
            this.titleLabel.setText(data.getName());
            this.descriptionLabel.setText(data.getDescription() != null ? data.getDescription() : "");
            this.toolBarManager.removeAll();
            final String url = data.getUrl();
            if (url != null) {
                Action action = new Action(){

                    public void run() {
                        BrowserUtil.openUrl((String)url, (int)128);
                    }
                };
                action.setImageDescriptor(CommonImages.INFORMATION);
                this.toolBarManager.add((IAction)action);
            }
            this.toolBarManager.update(false);
        }

        public void setHot(boolean hot) {
            super.setHot(hot);
            this.updateToolBar();
        }

        public void setSelected(boolean select) {
            super.setSelected(select);
            this.updateToolBar();
            this.canvas.redraw();
        }

        private void updateToolBar() {
            if (this.toolBar != null) {
                this.toolBar.setVisible(this.isHot() || this.isSelected());
            }
        }
    }

    public class SupportElementViewer
    extends ControlListViewer {
        public SupportElementViewer(Composite parent, int style) {
            super(parent, style);
        }

        protected ControlListItem doCreateItem(Composite parent, Object element) {
            if (element instanceof SupportCategory) {
                SupportElementItem item = new SupportElementItem(parent, 0, element);
                item.setGradientBackground(true);
                return item;
            }
            return new SupportElementItem(parent, 0, element);
        }

        protected void doCreateNoEntryArea(Composite parent) {
            parent.setLayout((Layout)new FillLayout());
            Label label = new Label(parent, 64);
            label.setText(Messages.SelectSupportElementPage_No_support_providers_Error0);
        }
    }
}

