/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class JavaUiBridge
extends AbstractContextUiBridge {
    public void open(IInteractionElement node) {
        IJavaElement javaElement = JavaCore.create((String)node.getHandleIdentifier());
        if (javaElement == null || !javaElement.exists()) {
            return;
        }
        try {
            IEditorPart part = JavaUI.openInEditor((IJavaElement)javaElement);
            JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)javaElement);
        }
        catch (JavaModelException | PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", NLS.bind((String)"Failed to open editor for: {0}", (Object)node.getHandleIdentifier()), e));
        }
    }

    public void close(IInteractionElement node) {
        block7: {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) break block7;
                ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>(4);
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    try {
                        IJavaElement input = (IJavaElement)reference.getEditorInput().getAdapter(IJavaElement.class);
                        if (input != null && node.getHandleIdentifier().equals(input.getHandleIdentifier())) {
                            toClose.add(reference);
                        }
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                    ++n2;
                }
                if (toClose.size() > 0) {
                    page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not auto close editor", t));
            }
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return editorPart instanceof JavaEditor;
    }

    /*
     * WARNING - void declaration
     */
    public IInteractionElement getElement(IEditorInput input) {
        Object adapter = input.getAdapter(IJavaElement.class);
        Object object = adapter;
        if (object instanceof IJavaElement) {
            void javaElement;
            IJavaElement iJavaElement = (IJavaElement)object;
            IJavaElement cfr_ignored_0 = (IJavaElement)object;
            String handle = ContextCore.getStructureBridge((Object)javaElement).getHandleIdentifier((Object)javaElement);
            return ContextCore.getContextManager().getElement(handle);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<TreeViewer> getContentOutlineViewers(IEditorPart editorPart) {
        if (editorPart == null) {
            return null;
        }
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        Object out = editorPart.getAdapter(IContentOutlinePage.class);
        Object object = out;
        if (object instanceof Page) {
            ISelectionProvider provider;
            IPageSite site;
            void page;
            Page page2 = (Page)object;
            Page cfr_ignored_0 = (Page)object;
            if (page.getControl() != null && (site = page.getSite()) != null && (provider = site.getSelectionProvider()) instanceof TreeViewer) {
                viewers.add((TreeViewer)provider);
            }
        }
        return viewers;
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        if (editor instanceof JavaEditor) {
            TextSelection textSelection = selection;
            try {
                if (selection != null) {
                    return SelectionConverter.resolveEnclosingElement((JavaEditor)((JavaEditor)editor), (ITextSelection)textSelection);
                }
                Object element = ((JavaEditor)editor).getEditorInput().getAdapter(IJavaElement.class);
                if (element instanceof IJavaElement) {
                    return element;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getContentType() {
        return "java";
    }
}

