/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.extension.ui.actions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.kdm.source.extension.ui.Activator;
import org.eclipse.modisco.kdm.source.extension.ui.adapters.SourceAccessAdapter;
import org.eclipse.modisco.kdm.source.extension.ui.adapters.SourceAccessAdapterFactory;
import org.eclipse.modisco.kdm.source.extension.ui.utils.BrowseCodeUtils;
import org.eclipse.modisco.omg.kdm.source.SourceRegion;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ActionBrowseCodeInTextEditor
implements IActionDelegate {
    private static final String DEBUG_ID = "org.eclipse.modisco.kdm.source.extension.ui/debug/ActionBrowseCodeInTextEditor/debug";
    static final boolean DEBUG = Activator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.modisco.kdm.source.extension.ui/debug/ActionBrowseCodeInTextEditor/debug")) != false;

    public void run(IAction action) {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            EObject eObject = null;
            if (firstElement != null) {
                if (firstElement instanceof EObject) {
                    eObject = (EObject)firstElement;
                    if (DEBUG) {
                        System.out.println("\nEObject Casted : " + String.valueOf(eObject));
                    }
                } else {
                    eObject = (EObject)Platform.getAdapterManager().getAdapter(firstElement, EObject.class);
                    if (DEBUG) {
                        System.out.println("\nEObject Adapted : " + String.valueOf(eObject));
                    }
                }
            }
            if (eObject != null) {
                BrowseCodeUtils.openAndSelectEObjectInSourceFile(eObject);
            } else {
                MoDiscoLogger.logWarning((String)"Cannot browse this element", (Plugin)Activator.getDefault());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (DEBUG) {
            System.out.println("ActionBrowseCodeInTextEditor.selectionChanged()");
        }
        if (selection instanceof IStructuredSelection) {
            SourceAccessAdapterFactory adapterFactory;
            SourceAccessAdapter sourceAccessAdapter;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            EObject eObject = null;
            if (firstElement != null && firstElement instanceof EObject && (sourceAccessAdapter = (SourceAccessAdapter)(adapterFactory = new SourceAccessAdapterFactory()).adapt((Notifier)(eObject = (EObject)firstElement), EObject.class)) != null) {
                SourceRegion sourceRegion = sourceAccessAdapter.getSourceRegion();
                if (sourceRegion == null) {
                    action.setEnabled(false);
                } else {
                    sourceAccessAdapter.setSourceRegion(sourceRegion);
                    action.setEnabled(true);
                }
            }
        }
    }
}

