/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.Messages;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class QueryContextHelp
extends PopupDialog {
    IAnnotatedObjectDescriptor query;
    Rectangle bounds;
    StyledText helpText;
    IQueryContext queryContext;

    public QueryContextHelp(Shell shell, IAnnotatedObjectDescriptor queryDescriptor, Rectangle helpBounds) {
        this(shell, queryDescriptor, null, helpBounds);
    }

    public QueryContextHelp(Shell parent, IAnnotatedObjectDescriptor query, IQueryContext queryContext, Rectangle bounds) {
        super(parent, 540676, false, false, false, false, false, null, null);
        this.query = query;
        this.bounds = bounds;
        this.queryContext = queryContext;
    }

    protected Point getInitialLocation(Point initialSize) {
        return new Point(this.bounds.x, this.bounds.y);
    }

    protected Point getInitialSize() {
        return new Point(this.bounds.width, this.bounds.height);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo(composite);
        Composite textComposite = new Composite(composite, 0);
        textComposite.setLayout((Layout)new FormLayout());
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        StringBuilder buf = new StringBuilder(128);
        if (this.query.getHelp() != null) {
            buf.append(this.query.getHelp());
        }
        boolean first = true;
        for (ArgumentDescriptor argument : this.query.getArguments()) {
            String help = argument.getHelp();
            if (help == null) continue;
            if (first) {
                first = false;
                String heading = "\n\n" + Messages.QueryContextHelp_Arguments + "\n";
                ranges.add(new StyleRange(buf.length(), heading.length(), null, null, 1));
                buf.append(heading);
            }
            buf.append("\n");
            String name = argument.getFlag() != null ? "-" + argument.getFlag() : argument.getName();
            ranges.add(new StyleRange(buf.length(), name.length(), null, null, 1));
            buf.append(name).append("\n");
            buf.append(help);
        }
        if (this.queryContext != null) {
            String heading = "\n\n" + Messages.QueryContextHelp_Usage + "\n";
            ranges.add(new StyleRange(buf.length(), heading.length(), null, null, 1));
            buf.append(heading);
            String usage = this.query.getUsage(this.queryContext);
            buf.append("\n");
            buf.append(usage);
        }
        this.helpText = new StyledText(textComposite, 72);
        this.helpText.setText(buf.toString());
        this.helpText.setStyleRanges(ranges.toArray(new StyleRange[0]));
        Point p = this.helpText.computeSize(this.bounds.width - 10, -1);
        this.bounds.height = p.y + 10;
        this.helpText.setLayoutData((Object)new FormData(this.bounds.width, this.bounds.height));
        return textComposite;
    }

    public IAnnotatedObjectDescriptor getQuery() {
        return this.query;
    }

    protected void configureShell(Shell shell) {
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(5, 5).applyTo((Composite)shell);
    }

    public void resize(Rectangle rectangle) {
        boolean resizing = false;
        if (this.bounds.x != rectangle.x || this.bounds.y != rectangle.y) {
            this.bounds.x = rectangle.x;
            this.bounds.y = rectangle.y;
            this.getShell().setLocation(this.bounds.x, this.bounds.y);
            resizing = true;
        }
        if (this.bounds.width != rectangle.width) {
            this.bounds.width = rectangle.width;
            Point p = this.helpText.computeSize(this.bounds.width - 10, -1);
            this.bounds.height = p.y + 10;
            this.helpText.setLayoutData((Object)new FormData(this.bounds.width, this.bounds.height));
            this.getShell().setSize(this.bounds.width, this.bounds.height);
            resizing = true;
        }
        if (resizing) {
            this.getShell().layout();
        }
    }

    public boolean close() {
        if (this.helpText != null) {
            this.helpText.dispose();
            this.helpText = null;
        }
        this.queryContext = null;
        this.query = null;
        return super.close();
    }
}

