/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMField;
import org.eclipse.m2m.atl.engine.vm.ASMInstruction;
import org.eclipse.m2m.atl.engine.vm.ASMInstructionWithOperand;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMParameter;
import org.eclipse.m2m.atl.engine.vm.ASMXMLWriter;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;

public class ASMEmitter
extends ASMOclAny {
    public static ASMOclType myType = new ASMOclSimpleType("ASMEmitter", ASMEmitter.getOclAnyType());
    private ASMOperation currentOperation;
    private ASM asm;
    private String version = "1.0";

    public ASMEmitter() {
        super(myType);
    }

    public void newASM(String name) {
        this.asm = new ASM(name);
    }

    public void newUnnamedASM() {
        this.asm = new ASM();
    }

    public void setName(String name) {
        this.asm.setName(name);
    }

    public void addField(String name, String type) {
        this.asm.addField(new ASMField(name, type));
    }

    public void finishOperation() {
        if (this.currentOperation != null) {
            this.currentOperation.endLocalVariableEntry("self");
            Iterator i = this.currentOperation.getParameters().iterator();
            while (i.hasNext()) {
                ASMParameter p = (ASMParameter)i.next();
                int slot = this.currentOperation.endLocalVariableEntry(p.getName());
                p.setName("" + slot);
            }
            this.currentOperation = null;
        }
    }

    public void addOperation(String name) {
        this.finishOperation();
        this.currentOperation = new ASMOperation(this.asm, name);
        this.asm.addOperation(this.currentOperation);
        this.currentOperation.beginLocalVariableEntry("self", "self");
    }

    public void addOperationWithoutLVE(String name) {
        this.currentOperation = new ASMOperation(this.asm, name);
        this.asm.addOperation(this.currentOperation);
    }

    public void setContext(String type) {
        this.currentOperation.setContext(type);
    }

    public void addParameter(String name, String type) {
        this.currentOperation.addParameter(new ASMParameter(name, type));
        this.currentOperation.beginLocalVariableEntry(name, name);
    }

    public void addParameterWithoutLVE(String name, String type) {
        this.currentOperation.addParameter(new ASMParameter(name, type));
    }

    public void beginLineNumberEntry(String id) {
        this.currentOperation.beginLineNumberEntry(id);
    }

    public void endLineNumberEntry(String id) {
        this.currentOperation.endLineNumberEntry(id);
    }

    public void addLineNumberEntry(String id, int begin, int end) {
        this.currentOperation.addLineNumberEntry(id, begin, end);
    }

    public void beginLocalVariableEntry(String id, String name) {
        this.currentOperation.beginLocalVariableEntry(id, name);
    }

    public void endLocalVariableEntry(String id) {
        this.currentOperation.endLocalVariableEntry(id);
    }

    public void addLocalVariableEntry(int slot, String name, int begin, int end) {
        this.currentOperation.addLocalVariableEntry(slot, name, begin, end);
    }

    public void emitSimple(String mnemonic) {
        if (!mnemonic.equals("nop")) {
            this.currentOperation.addInstruction(new ASMInstruction(mnemonic));
        }
    }

    public void emit(String mnemonic, String param) {
        if (!mnemonic.equals("nop")) {
            if (mnemonic.equals("if") || mnemonic.equals("goto")) {
                this.currentOperation.addLabeledInstruction(new ASMInstructionWithOperand(mnemonic, null), param);
            } else if (mnemonic.equals("label")) {
                this.currentOperation.addLabel(param);
            } else if (mnemonic.equals("store") || mnemonic.equals("load")) {
                this.currentOperation.addVariableInstruction(new ASMInstructionWithOperand(mnemonic, null), param);
            } else {
                this.currentOperation.addInstruction(new ASMInstructionWithOperand(mnemonic, param));
            }
        }
    }

    public void emitWithoutLabel(String mnemonic, String param) {
        if (!mnemonic.equals("nop")) {
            this.currentOperation.addInstruction(new ASMInstructionWithOperand(mnemonic, param));
        }
    }

    public ASM getASM() {
        return this.asm;
    }

    public void dumpASM(String fileName) {
        this.finishOperation();
        try {
            PrintWriter out = new PrintWriter(new FileWriter(fileName));
            new ASMXMLWriter(out, false).print(this.asm);
            out.close();
        }
        catch (IOException ioe) {
            ATLLogger.log((Level)Level.SEVERE, (String)ioe.getLocalizedMessage(), (Throwable)ioe);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

