/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.jdt.docker.launcher;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.jdt.docker.launcher.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JavaImageTab
extends AbstractLaunchConfigurationTab {
    private ComboViewer connCmb;
    private ComboViewer imageCmb;
    private org.eclipse.swt.widgets.List directoryList;
    private Button addButton;
    private Button removeButton;
    private IDockerConnection selectedConnection;
    private IDockerImage selectedImage;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label connLbl = new Label(composite, 0);
        connLbl.setText(Messages.ImageSelectionDialog_connection_label);
        this.connCmb = new ComboViewer(composite, 8);
        this.connCmb.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        this.connCmb.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                for (IDockerConnection conn : DockerConnectionManager.getInstance().getAllConnections()) {
                    try {
                        ((DockerConnection)conn).open(false);
                    }
                    catch (DockerException dockerException) {}
                }
                return DockerConnectionManager.getInstance().getAllConnections().stream().filter(c -> c.isOpen()).toArray(IDockerConnection[]::new);
            }
        });
        this.connCmb.setInput((Object)"place_holder");
        Label imageLbl = new Label(composite, 0);
        imageLbl.setText(Messages.ImageSelectionDialog_image_label);
        this.imageCmb = new ComboViewer(composite, 8);
        this.imageCmb.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        this.imageCmb.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                IDockerConnection conn = (IDockerConnection)inputElement;
                if (conn == null || conn.getImages() == null) {
                    return new Object[0];
                }
                return conn.getImages().stream().filter(i -> !((String)i.repoTags().get(0)).equals("<none>:<none>")).toArray(IDockerImage[]::new);
            }
        });
        this.imageCmb.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IDockerImage img = (IDockerImage)element;
                return (String)img.repoTags().get(0);
            }
        });
        this.imageCmb.setInput(null);
        this.connCmb.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDockerConnection conn;
                IStructuredSelection sel = event.getStructuredSelection();
                JavaImageTab.this.selectedConnection = conn = (IDockerConnection)sel.getFirstElement();
                JavaImageTab.this.imageCmb.setInput((Object)conn);
                JavaImageTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.imageCmb.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDockerImage img;
                IStructuredSelection sel = event.getStructuredSelection();
                JavaImageTab.this.selectedImage = img = (IDockerImage)sel.getFirstElement();
                JavaImageTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group dirGroup = new Group(composite, 0);
        dirGroup.setText(Messages.JavaImageTab_additional_dirs);
        dirGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        dirGroup.setLayout((Layout)new GridLayout(2, false));
        this.directoryList = new org.eclipse.swt.widgets.List((Composite)dirGroup, 516);
        this.directoryList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.directoryList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaImageTab.this.removeButton.setEnabled(true);
            }
        });
        this.addButton = this.createPushButton((Composite)dirGroup, Messages.JavaImageTab_button_add, null);
        this.addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(JavaImageTab.this.getShell());
                String directory = dialog.open();
                if (directory != null && !JavaImageTab.listContains(JavaImageTab.this.directoryList, directory)) {
                    JavaImageTab.this.directoryList.add(directory);
                    JavaImageTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.removeButton = this.createPushButton((Composite)dirGroup, Messages.JavaImageTab_button_remove, null);
        this.removeButton.setLayoutData((Object)new GridData(4, 128, false, true));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = JavaImageTab.this.directoryList.getSelectionIndex();
                if (i >= 0) {
                    JavaImageTab.this.directoryList.remove(i);
                    JavaImageTab.this.updateLaunchConfigurationDialog();
                }
                if (JavaImageTab.this.directoryList.getItemCount() == 0) {
                    JavaImageTab.this.removeButton.setEnabled(false);
                }
            }
        });
        this.removeButton.setEnabled(false);
        this.setControl((Control)composite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.jdt.docker.launcher.connection.uri", (String)null);
        configuration.setAttribute("org.eclipse.linuxtools.jdt.docker.launcher.image.id", (String)null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String connUri = configuration.getAttribute("org.eclipse.linuxtools.jdt.docker.launcher.connection.uri", (String)null);
            if (connUri != null) {
                this.connCmb.getCombo().setText(connUri);
                DockerConnection conn = (DockerConnection)DockerConnectionManager.getInstance().getConnectionByUri(connUri);
                String imageId = configuration.getAttribute("org.eclipse.linuxtools.jdt.docker.launcher.image.id", (String)null);
                if (imageId != null && conn != null) {
                    this.selectedConnection = conn;
                    this.imageCmb.setInput((Object)conn);
                    IDockerImage img = conn.getImage(imageId);
                    if (img != null) {
                        String repoTag = (String)img.repoTags().get(0);
                        this.imageCmb.getCombo().setText(repoTag);
                        this.selectedImage = img;
                    }
                }
            }
            List dirs = configuration.getAttribute("org.eclipse.linuxtools.jdt.docker.launcher.directories", Arrays.asList(new String[0]));
            this.directoryList.setItems(dirs.toArray(new String[0]));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.selectedConnection != null) {
            configuration.setAttribute("org.eclipse.linuxtools.jdt.docker.launcher.connection.uri", this.selectedConnection.getUri());
        }
        if (this.selectedImage != null) {
            configuration.setAttribute("org.eclipse.linuxtools.jdt.docker.launcher.image.id", this.selectedImage.id());
        }
        if (this.directoryList.getItemCount() > 0) {
            String[] directories = this.directoryList.getItems();
            configuration.setAttribute("org.eclipse.linuxtools.jdt.docker.launcher.directories", Arrays.asList(directories));
        }
    }

    public boolean canSave() {
        return this.selectedConnection != null && this.selectedImage != null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.canSave();
    }

    public String getName() {
        return Messages.JavaImageTab_image_tab_title;
    }

    private static boolean listContains(org.eclipse.swt.widgets.List list, String target) {
        String[] items;
        for (String item : items = list.getItems()) {
            if (!item.equals(target)) continue;
            return true;
        }
        return false;
    }
}

