/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.jdt.docker.launcher;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.jdt.docker.launcher.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ImageSelectionDialog
extends SelectionDialog {
    private IDockerConnection connection;
    private IDockerImage image;

    public ImageSelectionDialog() {
        this(Display.getDefault().getActiveShell());
    }

    protected ImageSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(Messages.ImageSelectionDialog_title);
    }

    public void create() {
        super.create();
        if (this.getInitialElementSelections().isEmpty()) {
            this.getOkButton().setEnabled(false);
        }
        Shell shell = this.getShell();
        shell.setSize(shell.getSize().x + 100, shell.getSize().y);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label connLbl = new Label(composite, 0);
        connLbl.setText(Messages.ImageSelectionDialog_connection_label);
        ComboViewer connCmb = new ComboViewer(composite, 8);
        connCmb.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        connCmb.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                for (IDockerConnection conn : DockerConnectionManager.getInstance().getAllConnections()) {
                    try {
                        ((DockerConnection)conn).open(false);
                    }
                    catch (DockerException dockerException) {}
                }
                return DockerConnectionManager.getInstance().getAllConnections().stream().filter(c -> c.isOpen()).toArray(IDockerConnection[]::new);
            }
        });
        connCmb.setInput((Object)"place_holder");
        Label imageLbl = new Label(composite, 0);
        imageLbl.setText(Messages.ImageSelectionDialog_image_label);
        final ComboViewer imageCmb = new ComboViewer(composite, 8);
        imageCmb.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        imageCmb.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                IDockerConnection conn = (IDockerConnection)inputElement;
                return conn.getImages().stream().filter(i -> !((String)i.repoTags().get(0)).equals("<none>:<none>")).toArray(IDockerImage[]::new);
            }
        });
        imageCmb.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IDockerImage img = (IDockerImage)element;
                return (String)img.repoTags().get(0);
            }
        });
        imageCmb.setInput(null);
        connCmb.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDockerConnection conn;
                IStructuredSelection sel = event.getStructuredSelection();
                ImageSelectionDialog.this.connection = conn = (IDockerConnection)sel.getFirstElement();
                imageCmb.setInput((Object)conn);
            }
        });
        imageCmb.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDockerImage img;
                IStructuredSelection sel = event.getStructuredSelection();
                ImageSelectionDialog.this.image = img = (IDockerImage)sel.getFirstElement();
                ImageSelectionDialog.this.getOkButton().setEnabled(true);
            }
        });
        return composite;
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public IDockerImage getImage() {
        return this.image;
    }
}

