/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.launchbar.ui.controls.internal.Activator;
import org.eclipse.launchbar.ui.controls.internal.LaunchBarControl;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;

public class LaunchBarInjector {
    @Inject
    MApplication application;
    @Inject
    IEventBroker eventBroker;

    @Execute
    void execute() {
        if (this.application == null) {
            return;
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean enabled = store.getBoolean("enableLaunchBar");
        this.injectIntoAll(enabled);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/basic/TrimmedWindow/trimBars/*", event -> {
            MTrimBar trimBar;
            if (!UIEvents.isADD((Event)event)) {
                return;
            }
            Object newValue = event.getProperty("NewValue");
            if (newValue instanceof MTrimBar && (trimBar = (MTrimBar)newValue).getSide() == SideValue.TOP) {
                IPreferenceStore store1 = Activator.getDefault().getPreferenceStore();
                boolean enabled1 = store1.getBoolean("enableLaunchBar");
                this.injectLaunchBar(trimBar, enabled1);
            }
        });
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(event -> {
            IPreferenceStore store1;
            boolean enabled2;
            if (event.getProperty().equals("enableLaunchBar")) {
                boolean enabled1 = Boolean.parseBoolean(event.getNewValue().toString());
                this.injectIntoAll(enabled1);
            }
            if ((event.getProperty().equals("alwaysTargetSelector") || event.getProperty().equals("enableBuildButton")) && (enabled2 = (store1 = Activator.getDefault().getPreferenceStore()).getBoolean("enableLaunchBar"))) {
                this.injectIntoAll(false);
                this.injectIntoAll(true);
            }
        });
    }

    private void injectIntoAll(boolean enabled) {
        for (MWindow window : this.application.getChildren()) {
            if (!(window instanceof MTrimmedWindow)) continue;
            for (MTrimBar trimBar : ((MTrimmedWindow)window).getTrimBars()) {
                if (trimBar.getSide() != SideValue.TOP) continue;
                this.injectLaunchBar(trimBar, enabled);
            }
        }
    }

    private void injectLaunchBar(MTrimBar trimBar, boolean enabled) {
        MToolControl launchBarElement = null;
        for (MTrimElement trimElement : trimBar.getChildren()) {
            if (!"org.eclipse.launchbar".equals(trimElement.getElementId())) continue;
            launchBarElement = (MToolControl)trimElement;
            break;
        }
        if (launchBarElement != null) {
            if (!LaunchBarControl.CLASS_URI.equals(launchBarElement.getContributionURI())) {
                launchBarElement.setContributionURI(LaunchBarControl.CLASS_URI);
            }
            if (!enabled) {
                trimBar.getChildren().remove(launchBarElement);
                Widget widget = (Widget)launchBarElement.getWidget();
                widget.dispose();
            }
            return;
        }
        if (enabled) {
            MToolControl launchBar = MMenuFactory.INSTANCE.createToolControl();
            launchBar.setElementId("org.eclipse.launchbar");
            launchBar.setContributionURI(LaunchBarControl.CLASS_URI);
            trimBar.getChildren().add(0, launchBar);
        }
    }
}

