/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.Messages;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;

public abstract class JarFactoryContainer
extends FactoryContainer {
    private static final String[] AUTOLOAD_SERVICES = new String[]{"com.sun.mirror.apt.AnnotationProcessorFactory", "javax.annotation.processing.Processor"};

    public abstract File getJarFile();

    @Override
    public boolean exists() {
        block3: {
            try {
                File jarFile = this.getJarFile();
                if (jarFile != null) break block3;
                return false;
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return this.getJarFile().exists();
    }

    @Override
    protected Map<String, String> loadFactoryNames() throws IOException {
        return JarFactoryContainer.getServiceClassnamesFromJar(this.getJarFile());
    }

    protected static Map<String, String> getServiceClassnamesFromJar(File jar) throws IOException {
        LinkedHashMap<String, String> classNames = new LinkedHashMap<String, String>();
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(jar);
                String[] stringArray = AUTOLOAD_SERVICES;
                int n = AUTOLOAD_SERVICES.length;
                int n2 = 0;
                while (n2 < n) {
                    String serviceName = stringArray[n2];
                    String providerName = "META-INF/services/" + serviceName;
                    JarEntry provider = jarFile.getJarEntry(providerName);
                    if (provider != null) {
                        InputStream is = jarFile.getInputStream(provider);
                        JarFactoryContainer.readServiceProvider(is, serviceName, classNames);
                    }
                    ++n2;
                }
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, Messages.AnnotationProcessorFactoryLoader_ioError + jar.getAbsolutePath());
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return classNames;
    }

    protected static void readServiceProvider(InputStream is, String serviceName, Map<String, String> classNames) throws IOException {
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = rd.readLine();
            while (line != null) {
                String[] tokens;
                int iComment = line.indexOf(35);
                if (iComment >= 0) {
                    line = line.substring(0, iComment);
                }
                if ((tokens = line.split("\\s", 2))[0].length() > 0) {
                    classNames.put(tokens[0], serviceName);
                }
                line = rd.readLine();
            }
            rd.close();
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

