/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.internal.Internal;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class LayoutAction
extends Action
implements IMenuCreator {
    private final PaletteViewerPreferences prefs;
    private final List<LayoutChangeAction> actions;

    public LayoutAction(PaletteViewerPreferences prefs) {
        this(prefs, false);
    }

    public LayoutAction(PaletteViewerPreferences prefs, boolean hasIcon) {
        super(PaletteMessages.LAYOUT_MENU_LABEL);
        this.prefs = prefs;
        this.actions = this.createActions();
        this.setMenuCreator(this);
        if (hasIcon) {
            this.setImageDescriptor(ImageDescriptor.createFromFile(Internal.class, (String)"icons/palette_layout.gif"));
        }
        this.setToolTipText(PaletteMessages.LAYOUT_MENU_LABEL);
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    protected List<LayoutChangeAction> createActions() {
        int[] modes;
        ArrayList<LayoutChangeAction> list = new ArrayList<LayoutChangeAction>();
        int[] nArray = modes = this.prefs.getSupportedLayoutModes();
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            int mode = nArray[n2];
            switch (mode) {
                case 1: {
                    LayoutChangeAction action = new LayoutChangeAction(1);
                    action.setText(PaletteMessages.SETTINGS_COLUMNS_VIEW_LABEL);
                    list.add(action);
                    break;
                }
                case 0: {
                    LayoutChangeAction action = new LayoutChangeAction(0);
                    action.setText(PaletteMessages.SETTINGS_LIST_VIEW_LABEL);
                    list.add(action);
                    break;
                }
                case 2: {
                    LayoutChangeAction action = new LayoutChangeAction(2);
                    action.setText(PaletteMessages.SETTINGS_ICONS_VIEW_LABEL_CAPS);
                    list.add(action);
                    break;
                }
                case 3: {
                    LayoutChangeAction action = new LayoutChangeAction(3);
                    action.setText(PaletteMessages.SETTINGS_DETAILS_VIEW_LABEL);
                    list.add(action);
                    break;
                }
            }
            ++n2;
        }
        return list;
    }

    public void dispose() {
    }

    private Menu fillMenu(Menu menu) {
        for (LayoutChangeAction action : this.actions) {
            action.setChecked(this.prefs.getLayoutSetting() == action.getLayoutSetting());
            this.addActionToMenu(menu, (IAction)action);
        }
        this.setEnabled(!this.actions.isEmpty());
        return menu;
    }

    public Menu getMenu(Control parent) {
        return this.fillMenu(new Menu(parent));
    }

    public Menu getMenu(Menu parent) {
        return this.fillMenu(new Menu(parent));
    }

    private class LayoutChangeAction
    extends Action {
        private final int value;

        public LayoutChangeAction(int layoutSetting) {
            this.value = layoutSetting;
        }

        public int getLayoutSetting() {
            return this.value;
        }

        public void run() {
            LayoutAction.this.prefs.setLayoutSetting(this.value);
        }
    }
}

