/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;

public class DBDefinitionFilterRegistry {
    private static DBDefinitionFilterRegistry _instance = null;
    private ArrayList _dbdefs = null;

    private DBDefinitionFilterRegistry() {
    }

    public static DBDefinitionFilterRegistry getInstance() {
        if (_instance == null) {
            _instance = new DBDefinitionFilterRegistry();
        }
        return _instance;
    }

    public synchronized ArrayList getFilteredDefinitions() {
        if (this._dbdefs == null) {
            this._dbdefs = new ArrayList();
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.sqltools.sqlscrapbook", "dbdeffilter");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getName().equals("dbdefinition")) {
                        String product = configElements[j].getAttribute("product");
                        String version = configElements[j].getAttribute("version");
                        DatabaseVendorDefinitionId id = new DatabaseVendorDefinitionId(product, version);
                        this._dbdefs.add(id);
                    }
                    ++j;
                }
                ++i;
            }
            Collection configs = SQLToolsFacade.getSupportedDBDefinitionNames();
            for (String name : configs) {
                DatabaseVendorDefinitionId id = new DatabaseVendorDefinitionId(name);
                if (!this._dbdefs.contains(id)) continue;
                this._dbdefs.remove(id);
            }
        }
        return this._dbdefs;
    }
}

