/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.connectivity.oda.util.manifest.Relationship;

public class DataSetType {
    private String m_id;
    private String m_displayName;
    private Hashtable<Integer, DataTypeMapping> m_dataTypeMappingsByNativeCode;
    private Hashtable<String, DataTypeMapping> m_dataTypeMappingsByNativeName;
    private Property[] m_properties = null;
    private Properties m_propsVisibility;
    private IConfigurationElement m_configElement;
    private List<Relationship> m_relationships;

    DataSetType(IConfigurationElement dataSetElement) throws OdaException {
        this.init(dataSetElement);
    }

    protected DataSetType() {
    }

    protected void init(IConfigurationElement dataSetElement) throws OdaException {
        this.m_id = dataSetElement.getAttribute("id");
        assert (this.m_id != null);
        this.m_displayName = ManifestExplorer.getElementDisplayName(dataSetElement);
        this.m_dataTypeMappingsByNativeCode = new Hashtable();
        this.m_dataTypeMappingsByNativeName = new Hashtable();
        IConfigurationElement[] typeMappings = dataSetElement.getChildren("dataTypeMapping");
        int numOfTypeMappings = typeMappings.length;
        if (numOfTypeMappings == 0) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_DATA_TYPE_MAPPINGS_DEFINED, (Object)this.m_id));
        }
        int i = 0;
        while (i < numOfTypeMappings) {
            IConfigurationElement typeMapping = typeMappings[i];
            DataTypeMapping dataTypeMap = new DataTypeMapping(typeMapping, this.m_id);
            this.m_dataTypeMappingsByNativeCode.put(dataTypeMap.getNativeTypeCode(), dataTypeMap);
            this.m_dataTypeMappingsByNativeName.put(dataTypeMap.getNativeType(), dataTypeMap);
            ++i;
        }
        IConfigurationElement[] propertiesElements = dataSetElement.getChildren("properties");
        if (propertiesElements.length > 0) {
            IConfigurationElement propertiesElement = propertiesElements[propertiesElements.length - 1];
            ArrayList<Property> extensionProps = ExtensionManifest.getPropertyDefinitions(propertiesElement);
            this.m_properties = extensionProps.toArray(new Property[extensionProps.size()]);
            this.m_propsVisibility = ExtensionManifest.getPropertyVisibilities(propertiesElement);
        }
        this.m_relationships = Relationship.createInstances(dataSetElement);
        this.m_configElement = dataSetElement;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.m_configElement;
    }

    public String getID() {
        return this.m_id;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public DataTypeMapping getDataTypeMapping(int nativeDataTypeCode) {
        Integer typeCode = nativeDataTypeCode;
        return this.m_dataTypeMappingsByNativeCode.get(typeCode);
    }

    public DataTypeMapping getDataTypeMapping(String nativeDataTypeName) {
        return this.m_dataTypeMappingsByNativeName.get(nativeDataTypeName);
    }

    public DataTypeMapping[] getDataTypeMappings() {
        Collection<DataTypeMapping> typeMappings = this.m_dataTypeMappingsByNativeCode.values();
        int count = typeMappings.size();
        return typeMappings.toArray(new DataTypeMapping[count]);
    }

    public int getDefaultOdaDataTypeCode(int nativeDataTypeCode) {
        DataTypeMapping mapping = this.getDataTypeMapping(nativeDataTypeCode);
        if (mapping != null) {
            return mapping.getOdaScalarDataTypeCode();
        }
        if (nativeDataTypeCode == 0) {
            return 1;
        }
        return 0;
    }

    public Property[] getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new Property[0];
        }
        return this.m_properties;
    }

    public Property[] getVisibleProperties() {
        return ManifestUtil.getVisiblePropertiesDefn(this.getProperties(), this.getPropertiesVisibility());
    }

    public Property[] getHiddenProperties() {
        return ManifestUtil.getHiddenPropertiesDefn(this.getProperties(), this.getPropertiesVisibility());
    }

    public Property getProperty(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return null;
        }
        Property[] props = this.getProperties();
        int i = 0;
        while (i < props.length) {
            if (propertyName.equals(props[i].getName())) {
                return props[i];
            }
            ++i;
        }
        return null;
    }

    public Properties getPropertiesVisibility() {
        if (this.m_propsVisibility == null) {
            this.m_propsVisibility = new Properties();
        }
        return this.m_propsVisibility;
    }

    public boolean isDeprecated() {
        List<Relationship> replacedBy = this.getRelationships(1);
        return replacedBy != null && !replacedBy.isEmpty();
    }

    public boolean isWrapper() {
        List<Relationship> wrappersOf = this.getRelationships(2);
        return wrappersOf != null && !wrappersOf.isEmpty();
    }

    public String getRelatedDataSetId() {
        List<Relationship> relationships = this.getRelationships(1);
        if (relationships == null) {
            return null;
        }
        Relationship replacedBy = relationships.get(0);
        return replacedBy != null ? replacedBy.getRelatedId() : null;
    }

    public List<Relationship> getRelationships(int relationshipType) {
        if (this.m_relationships == null || this.m_relationships.isEmpty()) {
            return null;
        }
        Vector<Relationship> matchingRelationships = new Vector<Relationship>(this.m_relationships.size());
        for (Relationship aRelationship : this.m_relationships) {
            if (aRelationship.getType() != relationshipType) continue;
            matchingRelationships.add(aRelationship);
        }
        return matchingRelationships.isEmpty() ? null : matchingRelationships;
    }
}

