/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.JoinTokens;

final class ImmutableJoinTokens
implements JoinTokens {
    private final String worker;
    private final String manager;

    private ImmutableJoinTokens(String worker, String manager) {
        this.worker = worker;
        this.manager = manager;
    }

    @Override
    @JsonProperty(value="Worker")
    public String worker() {
        return this.worker;
    }

    @Override
    @JsonProperty(value="Manager")
    public String manager() {
        return this.manager;
    }

    public final ImmutableJoinTokens withWorker(String value) {
        String newValue = Objects.requireNonNull(value, "worker");
        if (this.worker.equals(newValue)) {
            return this;
        }
        return new ImmutableJoinTokens(newValue, this.manager);
    }

    public final ImmutableJoinTokens withManager(String value) {
        String newValue = Objects.requireNonNull(value, "manager");
        if (this.manager.equals(newValue)) {
            return this;
        }
        return new ImmutableJoinTokens(this.worker, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJoinTokens && this.equalTo((ImmutableJoinTokens)another);
    }

    private boolean equalTo(ImmutableJoinTokens another) {
        return this.worker.equals(another.worker) && this.manager.equals(another.manager);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.worker.hashCode();
        h += (h << 5) + this.manager.hashCode();
        return h;
    }

    public String toString() {
        return "JoinTokens{worker=" + this.worker + ", manager=" + this.manager + "}";
    }

    public static ImmutableJoinTokens copyOf(JoinTokens instance) {
        if (instance instanceof ImmutableJoinTokens) {
            return (ImmutableJoinTokens)instance;
        }
        return ImmutableJoinTokens.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_WORKER = 1L;
        private static final long INIT_BIT_MANAGER = 2L;
        private long initBits = 3L;
        private String worker;
        private String manager;

        private Builder() {
        }

        public final Builder from(JoinTokens instance) {
            Objects.requireNonNull(instance, "instance");
            this.worker(instance.worker());
            this.manager(instance.manager());
            return this;
        }

        @JsonProperty(value="Worker")
        public final Builder worker(String worker) {
            this.worker = Objects.requireNonNull(worker, "worker");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Manager")
        public final Builder manager(String manager) {
            this.manager = Objects.requireNonNull(manager, "manager");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableJoinTokens build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJoinTokens(this.worker, this.manager);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("worker");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("manager");
            }
            return "Cannot build JoinTokens, some of required attributes are not set " + attributes;
        }
    }
}

