/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.service.policy.ui;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.ws.internal.service.policy.ui.BaseOperationImpl;
import org.eclipse.wst.ws.internal.service.policy.ui.QuickFixActionInfoImpl;
import org.eclipse.wst.ws.service.internal.policy.DescriptorImpl;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.ui.IQuickFixActionInfo;
import org.eclipse.wst.ws.service.policy.ui.ServicePolicyActivatorUI;
import org.eclipse.wst.ws.service.policy.utils.RegistryUtils;

public class ServicePolicyRegistryUI {
    private final String SERVICE_POLICY_ID = "org.eclipse.wst.ws.service.policy.ui.servicepolicyui";

    public void load(Map<String, BaseOperationImpl> operationMap, Map<String, List<IQuickFixActionInfo>> quickFixes) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.ws.service.policy.ui.servicepolicyui");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementName = element.getName().toLowerCase(Locale.ENGLISH);
            if (elementName.equals("servicepolicyui")) {
                IConfigurationElement[] children;
                IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    String name = child.getName().toLowerCase(Locale.ENGLISH);
                    if (name.equals("operation")) {
                        this.loadServicePolicyui(child, operationMap);
                    } else if (name.equals("quickfix")) {
                        this.loadQuickFix(child, quickFixes);
                    } else {
                        this.error("Undefined service policy ui element, " + name + " found.");
                    }
                    ++n4;
                }
            } else {
                this.error("Undefined service policy ui element, " + elementName + " found.");
            }
            ++n2;
        }
    }

    private void loadServicePolicyui(IConfigurationElement element, Map<String, BaseOperationImpl> operationMap) {
        String id = RegistryUtils.getAttribute((IConfigurationElement)element, (String)"id");
        String policyPattern = RegistryUtils.getAttribute((IConfigurationElement)element, (String)"policypattern");
        String workspaceOnly = RegistryUtils.getAttribute((IConfigurationElement)element, (String)"workspaceonly");
        String useDefaultString = RegistryUtils.getAttribute((IConfigurationElement)element, (String)"defaultdata");
        IConfigurationElement[] children = element.getChildren();
        DescriptorImpl descriptor = null;
        String enumId = null;
        String defaultItem = null;
        boolean selection = false;
        boolean icon = false;
        boolean multiSelect = false;
        IConfigurationElement enabledElement = null;
        IConfigurationElement launchElement = null;
        boolean error = false;
        boolean useDefaultData = true;
        if (useDefaultString != null) {
            useDefaultData = useDefaultString.equals("true");
        }
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getName().toLowerCase(Locale.ENGLISH);
            if (name.equals("descriptor")) {
                descriptor = RegistryUtils.loadDescriptor((IConfigurationElement)child);
            } else if (name.equals("enumeration")) {
                enumId = RegistryUtils.getAttribute((IConfigurationElement)child, (String)"id");
                defaultItem = RegistryUtils.getAttribute((IConfigurationElement)child, (String)"defaultitem");
                if (enumId == null) {
                    this.error("Service policy ui enumeration element is missing id attribute.");
                    error = true;
                }
            } else if (name.equals("selection")) {
                String iconValue = RegistryUtils.getAttribute((IConfigurationElement)child, (String)"icon");
                selection = true;
                if (iconValue != null && iconValue.equalsIgnoreCase("true")) {
                    icon = true;
                    useDefaultData = true;
                }
                if ((defaultItem = RegistryUtils.getAttribute((IConfigurationElement)child, (String)"defaultitem")) != null && !defaultItem.equals("org.eclipse.wst.false") && !defaultItem.equals("org.eclipse.wst.true")) {
                    this.error("The defaultItem attribute of a selection element must be: org.eclipse.wst.true or org.eclipse.wst.false.");
                    error = true;
                }
            } else if (name.equals("complex")) {
                String launchClass = RegistryUtils.getAttribute((IConfigurationElement)child, (String)"launchclass");
                if (launchClass == null) {
                    this.error("Service policy ui enumeration element is missing id attribute.");
                    error = true;
                }
                launchElement = child;
            } else if (name.equals("enabled")) {
                String enabledClass;
                String multiSelectValue = RegistryUtils.getAttribute((IConfigurationElement)child, (String)"multiselect").toLowerCase(Locale.ENGLISH);
                if (multiSelectValue != null && multiSelectValue.equals("true")) {
                    multiSelect = true;
                }
                if ((enabledClass = RegistryUtils.getAttribute((IConfigurationElement)child, (String)"enabledclass")) != null) {
                    enabledElement = child;
                }
            } else {
                this.error("Undefined service policy ui element, " + name + " found.");
                error = true;
            }
            ++n2;
        }
        if (descriptor == null) {
            this.error("Service policy operation element must have a descriptor element defined.");
            error = true;
        }
        if (id == null) {
            this.error("Id attribute not specified in service policy ui operation element.");
            error = true;
        }
        if (policyPattern == null) {
            this.error("Id attribute not specified in service policy ui operation element.");
            error = true;
        }
        if (enumId == null && !selection && launchElement == null || enumId != null && (selection || launchElement != null) || selection && (enumId != null || launchElement != null) || launchElement != null && selection && enumId != null) {
            this.error("Service policy operation element must have either an enumeration element or a selection element or a complex element");
            error = true;
        }
        if (!error) {
            BaseOperationImpl operation = new BaseOperationImpl();
            boolean workspaceOnlyValue = workspaceOnly != null && workspaceOnly.equals("true");
            operation.setId(id);
            operation.setPolicyIdPattern(policyPattern);
            operation.setDescriptor((IDescriptor)descriptor);
            operation.setMultiSelect(multiSelect);
            operation.setEnumerationId(enumId);
            operation.setWorkspaceOnly(workspaceOnlyValue);
            operation.setUseDefaultData(useDefaultData);
            if (defaultItem != null) {
                operation.setDefaultItem(defaultItem);
            }
            if (selection) {
                operation.setEnumerationId("org.eclipse.wst.service.policy.booleanEnum");
                operation.setSelection(icon);
            }
            if (launchElement != null) {
                operation.setComplexElement(launchElement);
            }
            if (enabledElement != null) {
                operation.setEnabledElement(enabledElement);
            }
            operationMap.put(id, operation);
        }
    }

    private void loadQuickFix(IConfigurationElement element, Map<String, List<IQuickFixActionInfo>> quickFixes) {
        IConfigurationElement[] children = element.getChildren("action");
        String pluginId = RegistryUtils.getAttribute((IConfigurationElement)element, (String)"pluginid");
        String code = RegistryUtils.getAttribute((IConfigurationElement)element, (String)"code");
        Vector<IQuickFixActionInfo> fixList = new Vector<IQuickFixActionInfo>();
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.loadAction(child, fixList);
            ++n2;
        }
        if (pluginId == null) {
            this.error("Missing pluginId attribute for Service policy UI quick fix extension");
            return;
        }
        if (code == null) {
            this.error("Missing code attribute for Service policy UI quick fix extension");
            return;
        }
        if (fixList.size() == 0) {
            this.error("Missing action element for Service policy UI quick fix extension");
            return;
        }
        String key = String.valueOf(pluginId) + ":" + code;
        quickFixes.put(key, fixList);
    }

    private void loadAction(IConfigurationElement element, List<IQuickFixActionInfo> fixList) {
        IConfigurationElement[] descElem = element.getChildren("descriptor");
        String clazz = RegistryUtils.getAttribute((IConfigurationElement)element, (String)"class");
        if (descElem == null) {
            this.error("Missing descriptor element for Service policy UI quick fix extension");
            return;
        }
        if (clazz == null) {
            this.error("Missing class attribute for Service policy UI quick fix extension");
            return;
        }
        DescriptorImpl descriptor = RegistryUtils.loadDescriptor((IConfigurationElement)element);
        QuickFixActionInfoImpl action = new QuickFixActionInfoImpl(element, (IDescriptor)descriptor);
        fixList.add(action);
    }

    private void error(String message) {
        ServicePolicyActivatorUI.logError(message, null);
    }
}

