/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.jsts;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.jsts.TypeScriptPlugin;
import org.eclipse.wildwebdeveloper.jsts.ui.preferences.JSTSPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.jsts.ui.preferences.javascript.JavaScriptPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.jsts.ui.preferences.typescript.TypeScriptPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.ui.preferences.ProcessStreamConnectionProviderWithPreference;

public class JSTSLanguageServer
extends ProcessStreamConnectionProviderWithPreference {
    private static final String JSTS_LANGUAGE_SERVER_ID = "org.eclipse.wildwebdeveloper.jsts";
    private static final String[] SUPPORTED_SECTIONS = new String[]{"typescript", "javascript"};
    private static String tsserverPath;

    public JSTSLanguageServer() {
        super(JSTS_LANGUAGE_SERVER_ID, Activator.getDefault().getPreferenceStore(), SUPPORTED_SECTIONS);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/typescript-language-server/lib/cli.mjs"));
            File nodeModules = new File(url.getPath()).getParentFile().getParentFile().getParentFile();
            tsserverPath = new File(nodeModules, "typescript/lib/tssserver.js").getAbsolutePath();
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
            URL nodeDependencies = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/"));
            this.setWorkingDirectory(nodeDependencies.getPath());
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    public Object getInitializationOptions(URI rootUri) {
        String maxTsServerMemory;
        HashMap<String, Object> options = new HashMap<String, Object>();
        ArrayList<TypeScriptPlugin> plugins = new ArrayList<TypeScriptPlugin>();
        try {
            plugins.add(new TypeScriptPlugin("typescript-plugin-css-modules"));
            plugins.add(new TypeScriptPlugin("typescript-lit-html-plugin"));
            options.put("plugins", plugins.stream().map(TypeScriptPlugin::toMap).toArray());
            if (!"Project version".equals(JSTSPreferenceServerConstants.getTypeScriptVersion())) {
                HashMap<String, String> tsServer = new HashMap<String, String>();
                tsServer.put("path", tsserverPath);
                options.put("tsserver", tsServer);
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        if ((maxTsServerMemory = System.getProperty("org.eclipse.wildwebdeveloper.maxTsServerMemory")) != null) {
            options.put("maxTsServerMemory", maxTsServerMemory);
        }
        return options;
    }

    @Override
    protected Object createSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.putAll(JavaScriptPreferenceServerConstants.getGlobalSettings());
        settings.putAll(TypeScriptPreferenceServerConstants.getGlobalSettings());
        return settings;
    }

    /*
     * WARNING - void declaration
     */
    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        Message message2 = message;
        if (message2 instanceof ResponseMessage) {
            void responseMessage;
            ResponseMessage responseMessage2 = (ResponseMessage)message2;
            ResponseMessage cfr_ignored_0 = (ResponseMessage)message2;
            if (responseMessage.getResult() instanceof InitializeResult) {
                DidChangeConfigurationParams params = new DidChangeConfigurationParams(this.createSettings());
                languageServer.getWorkspaceService().didChangeConfiguration(params);
            }
        }
    }
}

