/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.utils;

import java.net.URL;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.IClassLoaderInitializer;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.osgi.framework.Bundle;

public final class ResourceManagerClassLoaderInitializer
implements IClassLoaderInitializer {
    public static final IClassLoaderInitializer INSTANCE = new ResourceManagerClassLoaderInitializer();

    private ResourceManagerClassLoaderInitializer() {
    }

    public void initialize(final ClassLoader classLoader) {
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                Class<?> managerClass = classLoader.loadClass("org.eclipse.wb.swt.ResourceManager");
                Class<?> providerClass = classLoader.loadClass("org.eclipse.wb.swt.ResourceManager$PluginResourceProvider");
                ResourceManagerClassLoaderInitializer.this.initialize_ResourceManager(classLoader, managerClass, providerClass);
            }
        });
    }

    public void deinitialize(ClassLoader classLoader) {
    }

    private void initialize_ResourceManager(ClassLoader classLoader, Class<?> managerClass, Class<?> providerClass) throws Exception {
        Object provider = this.createProvider(classLoader, providerClass);
        ReflectionUtils.setField(managerClass, (String)"m_designTimePluginResourceProvider", (Object)provider);
    }

    private Object createProvider(ClassLoader classLoader, Class<?> providerClass) {
        try {
            return new ByteBuddy().subclass(providerClass).method((ElementMatcher)ElementMatchers.named((String)"getEntry")).intercept((Implementation)InvocationHandlerAdapter.of((proxy, method, args) -> {
                String symbolicName = (String)args[0];
                String fullPath = (String)args[1];
                return this.getEntry(symbolicName, fullPath);
            })).make().load(classLoader).getLoaded().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DesignerException(313, (Throwable)e, new String[0]);
        }
    }

    private URL getEntry(String symbolicName, String fullPath) throws Exception {
        IResource underlyingResource;
        IPluginModelBase modelBase = PluginRegistry.findModel((String)symbolicName);
        String installLocation = modelBase.getInstallLocation();
        if (!StringUtils.isEmpty((String)installLocation) && installLocation.toLowerCase().endsWith(".jar")) {
            Object urlPath = "jar:file:/" + installLocation + "!/" + fullPath;
            urlPath = FilenameUtils.normalize((String)urlPath, (boolean)true);
            return new URL((String)urlPath);
        }
        IPluginModelBase pluginModel = PluginRegistry.findModel((String)symbolicName);
        if (pluginModel != null && (underlyingResource = pluginModel.getUnderlyingResource()) != null) {
            IProject project = underlyingResource.getProject();
            return project.getFile((IPath)new Path(fullPath)).getLocationURI().toURL();
        }
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null) {
            return bundle.getEntry(fullPath);
        }
        return null;
    }
}

