/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ClassLoaderLocalMap;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.util.ParseTools;

public final class ScriptUtils {
    private static final Map<String, Object> m_compiledExpressions = new MapMaker().weakValues().makeMap();

    public static Object evaluate(ClassLoader contextClassLoader, String script) {
        Map<String, Object> variables = Collections.emptyMap();
        return ScriptUtils.evaluate(contextClassLoader, script, variables);
    }

    public static Object evaluate(ClassLoader contextClassLoader, String script, String name_1, Object value_1) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(name_1, value_1);
        return ScriptUtils.evaluate(contextClassLoader, script, variables);
    }

    public static Object evaluate(ClassLoader contextClassLoader, String script, String name_1, Object value_1, String name_2, Object value_2) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(name_1, value_1);
        variables.put(name_2, value_2);
        return ScriptUtils.evaluate(contextClassLoader, script, variables);
    }

    public static Object evaluate(ClassLoader contextClassLoader, String script, Map<String, Object> variables) {
        Map<String, Object> contextCache = ScriptUtils.getContextCache(contextClassLoader);
        try {
            Object expression = ScriptUtils.compile(contextCache, script, contextClassLoader);
            Object object = ScriptUtils.evaluate(expression, variables);
            return object;
        }
        finally {
            ScriptUtils.clearMemoryLeaks();
        }
    }

    public static Object evaluate(String script) {
        return ScriptUtils.evaluate(script, new HashMap<String, Object>());
    }

    public static Object evaluate(String script, Object ctx) {
        Object expression = ScriptUtils.compile(script);
        return MVEL.executeExpression((Object)expression, (Object)ctx);
    }

    public static Object evaluate(String script, String name_1, Object value_1) {
        Object expression = ScriptUtils.compile(script);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(name_1, value_1);
        return ScriptUtils.evaluate(expression, variables);
    }

    public static Object evaluate(String script, String name_1, Object value_1, String name_2, Object value_2) {
        Object expression = ScriptUtils.compile(script);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(name_1, value_1);
        variables.put(name_2, value_2);
        return ScriptUtils.evaluate(expression, variables);
    }

    public static Object evaluate(String script, Map<String, Object> variables) {
        Object expression = ScriptUtils.compile(script);
        return ScriptUtils.evaluate(expression, variables);
    }

    private static Object evaluate(Object expression, Map<String, Object> _variables) {
        HashMap variables = Maps.newHashMap(_variables);
        return MVEL.executeExpression((Object)expression, (Map)variables);
    }

    public static void clearMemoryLeaks() {
        ExecutionUtils.runLog(new RunnableEx(){

            @Override
            public void run() throws Exception {
                this.clearCaches(ParseTools.class);
                this.clearCaches(PropertyAccessor.class);
            }

            private void clearCaches(Class<?> clazz) throws Exception {
                Field[] fields;
                Field[] fieldArray = fields = clazz.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (field.getName().endsWith("_CACHE") && Map.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        Map map = (Map)field.get(0);
                        if (map != null) {
                            map.clear();
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    private static Map<String, Object> getContextCache(ClassLoader context) {
        Class<ScriptUtils> key = ScriptUtils.class;
        HashMap cache = (HashMap)ClassLoaderLocalMap.get(context, key);
        if (cache == null) {
            cache = new HashMap();
            ClassLoaderLocalMap.put(context, key, cache);
        }
        return cache;
    }

    private static Object compile(String script) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return ScriptUtils.compile(m_compiledExpressions, script, contextClassLoader);
    }

    private static Object compile(Map<String, Object> cache, String script, ClassLoader contextClassLoader) {
        Object expression = cache.get(script);
        if (expression == null) {
            ParserConfiguration parserConfiguration = new ParserConfiguration();
            parserConfiguration.setClassLoader(contextClassLoader);
            ParserContext context = new ParserContext(parserConfiguration);
            context.addImport("ReflectionUtils", ReflectionUtils.class);
            expression = MVEL.compileExpression((String)script, (ParserContext)context);
            cache.put(script, expression);
        }
        return expression;
    }
}

