/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model;

import java.lang.reflect.Method;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.WrappedObjectAssociation;
import org.eclipse.wb.internal.core.model.AbstractWrapper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodControlCreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodLiveCreationSupport;
import org.eclipse.wb.internal.core.model.description.AbstractInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.WrapperMethodControlVariableSupport;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class WrapperByMethod
extends AbstractWrapper {
    protected Method m_method;

    public WrapperByMethod(JavaInfo host, String methodName) {
        super(host);
        this.setControlMethodName(methodName);
    }

    public WrapperByMethod(JavaInfo host) {
        this(host, JavaInfoUtils.getParameter(host, "Wrapper.method"));
    }

    public final void setControlMethodName(String methodName) {
        Class<?> componentClass = this.m_wrapperInfo.getDescription().getComponentClass();
        this.m_method = ReflectionUtils.getMethodBySignature(componentClass, (String)(methodName + "()"));
        Assert.isNotNull((Object)this.m_method, (String)("Viewer control access method \"" + methodName + "\" not found for viewer class " + ReflectionUtils.getFullyQualifiedName(componentClass, (boolean)false)));
    }

    public Method getControlMethod() {
        return this.m_method;
    }

    @Override
    public Class<?> getWrappedType() {
        return this.getControlMethod().getReturnType();
    }

    @Override
    protected CreationSupport newWrappedCreationSupport() throws Exception {
        return new WrapperMethodLiveCreationSupport(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWrappedInfo(ASTNode node) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            return invocation.arguments().isEmpty() && invocation.getName().getIdentifier().equals(this.m_method.getName()) && this.m_wrapperInfo.isRepresentedBy((ASTNode)invocation.getExpression());
        }
        return false;
    }

    public void configureWrapper(AbstractInvocationDescription methodDescription, JavaInfo[] argumentInfos) throws Exception {
        for (ParameterDescription parameter : methodDescription.getParameters()) {
            JavaInfo parameterJavaInfo = argumentInfos[parameter.getIndex()];
            if (parameter.isParent() && this.isParameterWithWrapped(parameter)) {
                this.m_wrappedInfo = parameterJavaInfo;
            }
            this.configureParameter(parameter, parameterJavaInfo);
        }
    }

    protected void configureParameter(ParameterDescription parameter, JavaInfo parameterJavaInfo) throws Exception {
        if (parameter.isParent() && !this.isParameterWithWrapped(parameter)) {
            this.configureHierarchy(parameterJavaInfo);
        }
    }

    private boolean isParameterWithWrapped(ParameterDescription parameter) {
        return parameter.hasTrueTag("Wrapper.wrapped");
    }

    public void configureHierarchy(JavaInfo parent) throws Exception {
        if (this.m_wrappedInfo == null) {
            this.m_wrappedInfo = JavaInfoUtils.createJavaInfo(this.m_wrapperInfo.getEditor(), this.getWrappedType(), this.newControlCreationSupport());
            this.m_wrappedInfo.setVariableSupport(this.newControlVariableSupport(this.m_wrappedInfo));
            this.m_wrappedInfo.setAssociation(this.newControlAssociation());
        }
        this.configureHierarchy(parent, this.m_wrappedInfo);
    }

    protected CreationSupport newControlCreationSupport() {
        return new WrapperMethodControlCreationSupport(this);
    }

    protected VariableSupport newControlVariableSupport(JavaInfo control) {
        return new WrapperMethodControlVariableSupport(control, this);
    }

    protected Association newControlAssociation() {
        return new WrappedObjectAssociation(this);
    }

    protected void configureHierarchy(JavaInfo parent, JavaInfo control) throws Exception {
        WrapperByMethod.softAddChild(parent, control);
        WrapperByMethod.softAddChild(control, this.m_wrapperInfo);
    }

    protected static final void softAddChild(ObjectInfo parent, ObjectInfo child) throws Exception {
        if (!parent.getChildren().contains(child)) {
            parent.addChild(child);
        }
    }
}

