/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.remote.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.IRemoteProcessTerminalService;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.tm.internal.terminal.control.ITerminalListener3;
import org.eclipse.tm.internal.terminal.emulator.VT100Emulator;
import org.eclipse.tm.internal.terminal.emulator.VT100TerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.connector.remote.IRemoteTerminalParser;
import org.eclipse.tm.terminal.connector.remote.internal.Activator;
import org.eclipse.tm.terminal.connector.remote.internal.ArgumentParser;
import org.eclipse.tm.terminal.connector.remote.internal.RemoteConnector;
import org.eclipse.tm.terminal.connector.remote.nls.Messages;

public class RemoteConnectionManager
extends Job {
    private static final String PARSERS_EXTENSION_POINT = "parsers";
    private static final String PARSER_ELEMENT = "parser";
    private static int fgNo;
    private final ITerminalControl control;
    private final RemoteConnector connector;
    private IRemoteTerminalParser parser;
    private IRemoteProcess remoteProcess;

    protected RemoteConnectionManager(RemoteConnector conn, ITerminalControl control) {
        super("Remote Terminal-" + fgNo++);
        this.control = control;
        this.connector = conn;
        this.setSystem(true);
        this.loadParserExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IRemoteConnection remoteConnection = null;
        try {
            IRemoteServicesManager svcMgr = Activator.getService(IRemoteServicesManager.class);
            String connTypeId = this.connector.getRemoteSettings().getConnectionTypeId();
            IRemoteConnectionType connType = svcMgr.getConnectionType(connTypeId);
            if (connType != null) {
                remoteConnection = connType.getConnection(this.connector.getRemoteSettings().getConnectionName());
            }
            if (remoteConnection == null) {
                Status status = new Status(4, Activator.getUniqueIdentifier(), NLS.bind((String)Messages.RemoteConnectionManager_0, (Object)this.connector.getRemoteSettings().getConnectionName()));
                return status;
            }
            if (!remoteConnection.isOpen()) {
                remoteConnection.open(monitor);
                if (!remoteConnection.isOpen()) {
                    Status status = new Status(4, Activator.getUniqueIdentifier(), NLS.bind((String)Messages.RemoteConnectionManager_1, (Object)this.connector.getRemoteSettings().getConnectionName()));
                    return status;
                }
            }
            if (this.parser != null) {
                this.remoteProcess = this.parser.initialize(remoteConnection);
            }
            if (this.remoteProcess == null) {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(Activator.getUniqueIdentifier());
                String terminalShellCommand = prefs.get("TERMINAL_SHELL_COMMAND", "");
                if ("".equals(terminalShellCommand) && remoteConnection.hasService(IRemoteCommandShellService.class)) {
                    IRemoteCommandShellService cmdShellSvc = (IRemoteCommandShellService)remoteConnection.getService(IRemoteCommandShellService.class);
                    RemoteConnectionManager remoteConnectionManager = this;
                    synchronized (remoteConnectionManager) {
                        this.remoteProcess = cmdShellSvc.getCommandShell(1);
                    }
                } else if (remoteConnection.hasService(IRemoteProcessService.class)) {
                    if ("".equals(terminalShellCommand)) {
                        terminalShellCommand = "/bin/bash -l";
                    }
                    IRemoteProcessService procSvc = (IRemoteProcessService)remoteConnection.getService(IRemoteProcessService.class);
                    IRemoteProcessBuilder processBuilder = procSvc.getProcessBuilder(new ArgumentParser(terminalShellCommand).getTokenList());
                    this.remoteProcess = processBuilder.start(1);
                } else {
                    Status status = new Status(4, Activator.getUniqueIdentifier(), Messages.RemoteConnectionManager_2);
                    return status;
                }
            }
            try {
                this.control.setVT100LineWrapping(true);
                this.connector.setInputStream(this.remoteProcess.getInputStream());
                this.control.setState(TerminalState.CONNECTED);
                this.control.setTerminalTitle(remoteConnection.getName(), ITerminalListener3.TerminalTitleRequestor.OTHER);
                this.connector.setOutputStream(this.remoteProcess.getOutputStream());
                VT100Emulator text = ((VT100TerminalControl)this.control).getTerminalText();
                text.fontChanged();
                this.readData(this.connector.getInputStream());
            }
            catch (IOException e) {
                Status status = new Status(4, Activator.getUniqueIdentifier(), e.getMessage());
                return status;
            }
            catch (RemoteConnectionException e) {
                Status status = new Status(4, Activator.getUniqueIdentifier(), e.getMessage());
                return status;
            }
        }
        finally {
            this.connector.disconnect();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canceling() {
        super.canceling();
        RemoteConnectionManager remoteConnectionManager = this;
        synchronized (remoteConnectionManager) {
            if (this.remoteProcess != null && !this.remoteProcess.isCompleted()) {
                this.remoteProcess.destroy();
            }
        }
    }

    public void setTerminalSize(int cols, int rows, int width, int height) {
        IRemoteProcessTerminalService termSvc;
        if (this.remoteProcess != null && (termSvc = (IRemoteProcessTerminalService)this.remoteProcess.getService(IRemoteProcessTerminalService.class)) != null) {
            termSvc.setTerminalSize(cols, rows, width, height);
        }
    }

    private void readData(InputStream in) throws IOException {
        int n;
        byte[] buf = new byte[32768];
        while ((n = in.read(buf, 0, buf.length)) >= 0) {
            if (n == 0 || this.parser != null && !this.parser.parse(buf)) continue;
            this.control.getRemoteToTerminalOutputStream().write(buf, 0, n);
        }
    }

    private void loadParserExtension() {
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(Activator.getUniqueIdentifier(), PARSERS_EXTENSION_POINT);
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (PARSER_ELEMENT.equals(element.getName())) {
                        try {
                            this.parser = (IRemoteTerminalParser)element.createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

