/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.dltk.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.dltk.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathUtils;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.php.internal.ui.wizards.types.Messages;
import org.eclipse.php.internal.ui.wizards.types.NewPHPTypePage;
import org.eclipse.php.internal.ui.wizards.types.PHPFullPathLabelProvider;
import org.eclipse.php.internal.ui.wizards.types.StatusLineLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewPHPClassPage
extends NewPHPTypePage {
    protected Text superClassName;
    private Label superPath;
    private IType superClassData;
    private Button browseSuperBtn;
    private static final String[] CLASS_CHECKBOXES_PHP5;
    public static final String[] CLASS_MODIFIERS;
    public static final int VALIDATE_SUPER_CLASS = 5;
    protected StatusInfo superClassStatus;
    private String previousSourceFolder;

    static {
        String[] stringArray = new String[8];
        stringArray[0] = "require_once";
        stringArray[1] = "Constructor";
        stringArray[2] = "PHPDoc Blocks";
        stringArray[4] = "Destructor";
        stringArray[5] = "TODOs";
        stringArray[7] = "Inherited abstract methods";
        CLASS_CHECKBOXES_PHP5 = stringArray;
        CLASS_MODIFIERS = new String[]{"none", "final", "abstract"};
    }

    public NewPHPClassPage() {
        super(Messages.NewPHPClassPage_3);
        this.fTypeKind = 1;
        this.setMessage(Messages.NewPHPClassPage_4);
        this.setDescription(Messages.NewPHPClassPage_4);
        this.setTitle(Messages.NewPHPClassPage_6);
        this.superClassStatus = new StatusInfo();
        this.interfacesStatus = new StatusInfo();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        super.createControl(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createLocationSection(composite);
        this.createElementSection(composite);
        this.setControl((Control)composite);
        this.initValues();
    }

    @Override
    protected void initValues() {
        super.initValues();
        if (this.superClassData != null) {
            this.superClassName.setText(this.superClassData.getElementName());
        }
        this.previousSourceFolder = this.getSourceText();
    }

    @Override
    protected void validatePageValues(int validationCode) {
        super.validatePageValues(validationCode);
        IProject currentProject = this.getCurrentProject();
        if (currentProject != null) {
            IScriptProject model = DLTKCore.create((IProject)currentProject);
            if (this.superClassName != null && this.superClassName.getText().length() > 0 && model != null) {
                this.validateSuperClass(this.getSuperclassName());
            }
        }
    }

    private void createElementSection(Composite composite) {
        Composite elementSection = new Composite(composite, 0);
        GridLayout layout = new GridLayout(3, false);
        elementSection.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        elementSection.setLayoutData((Object)gd);
        this.addElementNameText(elementSection, Messages.NewPHPClassPage_7);
        if (this.phpVersion != PHPVersion.PHP5) {
            this.addNamespaceText(elementSection);
        }
        this.addElementModifiers(elementSection, CLASS_MODIFIERS);
        this.addElementSuperClass(elementSection);
        this.createSuperInterfacesControls(elementSection);
        if (this.phpVersion != null && this.phpVersion.isGreaterThan(PHPVersion.PHP5_3)) {
            this.createTraitsControls(elementSection);
        }
        this.addCheckboxesCreation(elementSection, CLASS_CHECKBOXES_PHP5);
    }

    private void addElementSuperClass(Composite elementSection) {
        GridData gd = new GridData();
        Label superclassLabel = new Label(elementSection, 0);
        superclassLabel.setText(Messages.NewPHPClassPage_8);
        superclassLabel.setLayoutData((Object)gd);
        this.superClassName = new Text(elementSection, 2052);
        gd = new GridData(768);
        this.superClassName.setLayoutData((Object)gd);
        this.superClassName.addModifyListener(e -> {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = this.getProjectName(this.getSourceText());
            if (projectName != null && projectName.length() > 0) {
                IProject currentProject = workspaceRoot.getProject(projectName);
                IScriptProject model = DLTKCore.create((IProject)currentProject);
                String superClassName = ((Text)e.getSource()).getText().trim();
                if (model != null) {
                    if (this.superClassData != null && !superClassName.equalsIgnoreCase(this.superClassData.getElementName())) {
                        this.superClassData = null;
                    }
                    this.validateSuperClass(superClassName);
                }
            }
        });
        this.browseSuperBtn = new Button(elementSection, 8);
        this.browseSuperBtn.setText(Messages.NewPHPClassPage_9);
        gd = new GridData();
        gd.widthHint = SWTUtil.getButtonWidthHint(this.browseSuperBtn);
        this.browseSuperBtn.setLayoutData((Object)gd);
        this.browseSuperBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType result;
                NewPHPClassPage.this.superClassData = result = NewPHPClassPage.this.chooseSuperClass();
                if (result != null) {
                    NewPHPClassPage.this.superClassName.setText(result.getElementName());
                }
                NewPHPClassPage.this.changeButtonEnableStatus();
            }
        });
        new Label(elementSection, 0);
        this.superPath = new Label(elementSection, 0);
        gd = new GridData(768);
        this.superPath.setLayoutData((Object)gd);
        new Label(elementSection, 0);
    }

    @Override
    protected void sourceFolderChanged() {
        super.sourceFolderChanged();
        if (this.browseSuperBtn == null) {
            return;
        }
        if (this.sourceFolderStatus.getCode() != 0) {
            this.browseSuperBtn.setEnabled(false);
        } else {
            this.browseSuperBtn.setEnabled(true);
        }
        String sourcePath = this.getSourceText();
        Path projPath = new Path(sourcePath);
        if (projPath.segmentCount() != 1) {
            return;
        }
        String projectPath = projPath.segment(0);
        if (projectPath == null || projectPath.length() == 0) {
            return;
        }
        if (!sourcePath.equals(this.previousSourceFolder)) {
            String superclassName = this.getSuperclassName();
            this.superClassData = null;
            if (superclassName.length() > 0) {
                this.validateSuperClass(superclassName);
            }
        }
        IScriptProject model = this.getProject();
        if (this.getInterfaces().size() > 0) {
            this.validateInterfaces(model);
        }
        if (this.getTraits().size() > 0) {
            this.validateTraits(model);
        }
        this.previousSourceFolder = sourcePath;
    }

    private void validateSuperClass(String superclassName) {
        IType[] types;
        this.superPath.setText("");
        this.superClassStatus = new StatusInfo();
        if (superclassName.length() == 0) {
            this.superClassData = null;
            this.changeButtonEnableStatus();
            this.updateStatus(this.findMostSevereStatus());
            return;
        }
        if (this.superClassData == null) {
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)this.getProject());
            types = PHPModelAccess.getDefault().findTypes(superclassName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        } else {
            types = new IType[]{this.superClassData};
        }
        String error = null;
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            int modifiers = 0;
            try {
                modifiers = type.getFlags();
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            if (PHPFlags.isInterface((int)modifiers)) {
                error = NLS.bind((String)"Not a class: ''{0}''", (Object)superclassName);
            } else if (PHPFlags.isFinal((int)modifiers)) {
                error = NLS.bind((String)"Class ''{0}'' is final", (Object)superclassName);
            } else {
                this.superClassData = type;
                IPath relativeLocation = IncludePathUtils.getRelativeLocationFromIncludePath(type.getScriptProject(), (IModelElement)type);
                this.superPath.setText(relativeLocation.toString());
            }
            ++n2;
        }
        if (this.superClassData == null) {
            this.superPath.setText("");
            if (error != null) {
                this.superClassStatus.setError(error);
            } else {
                this.superClassStatus.setError(NLS.bind((String)"Cannot find: ''{0}''", (Object)superclassName));
            }
        }
        this.updateStatus(this.findMostSevereStatus());
        this.changeButtonEnableStatus();
    }

    public String getSuperclassName() {
        return this.superClassName.getText().trim();
    }

    protected IType chooseSuperClass() {
        Object[] resultArray;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(this.getProjectName(this.sourceText.getText()));
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createSearchScope((IModelElement)DLTKCore.create((IProject)project)), 0, new TypeSelectionExtension(){

            public ITypeInfoFilterExtension getFilterExtension() {
                return typeInfoRequestor -> {
                    int modifiers = typeInfoRequestor.getModifiers();
                    return !PHPFlags.isFinal((int)modifiers) && !PHPFlags.isInterface((int)modifiers) && !PHPFlags.isNamespace((int)modifiers) && !PHPFlags.isTrait((int)modifiers);
                };
            }
        }, PHPLanguageToolkit.getDefault());
        dialog.setListLabelProvider((ILabelProvider)new PHPFullPathLabelProvider());
        dialog.setListSelectionLabelDecorator((ILabelDecorator)new PHPFullPathLabelProvider());
        dialog.setDetailsLabelProvider((ILabelProvider)new StatusLineLabelProvider());
        dialog.setTitle(Messages.NewPHPClassPage_0);
        dialog.setMessage(Messages.NewPHPClassPage_15);
        dialog.setInitialPattern("", 2);
        if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
            return (IType)resultArray[0];
        }
        return null;
    }

    public boolean isCreateModifierChecked(int checkBoxIndex) {
        Control[] btns;
        boolean result = false;
        if (this.modifiers != null && (btns = this.modifiers.getChildren()).length > checkBoxIndex) {
            Button btn = (Button)btns[checkBoxIndex];
            result = btn.getSelection();
        }
        return result;
    }

    public IType getSuperClassData() {
        return this.superClassData;
    }

    @Override
    protected IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.elementNameStatus, this.sourceFolderStatus, this.newFileStatus, this.existingFileStatus, this.superClassStatus, this.interfacesStatus, this.namespaceStatus});
    }

    @Override
    protected IModelElement getInitialPHPElement(IStructuredSelection selection) {
        int type;
        IModelElement codeData = super.getInitialPHPElement(selection);
        if (codeData != null && PHPToolkitUtil.isPHPElement((IModelElement)codeData) && (type = codeData.getElementType()) == 7 && !PHPFlags.isInterface((int)type) && !PHPFlags.isNamespace((int)type)) {
            this.superClassData = (IType)codeData;
        }
        return codeData;
    }

    @Override
    protected void changeButtonEnableStatus() {
        super.changeButtonEnableStatus();
        Button button = this.getButton("Inherited abstract methods");
        if (button != null) {
            button.setEnabled(!this.fSuperInterfacesDialogField.getElements().isEmpty() || this.superClassData != null);
        }
    }

    @Override
    protected boolean requireOnceShouldEnabled() {
        return super.requireOnceShouldEnabled() || this.superClassData != null;
    }
}

