// DO NOT EDIT
// Generated by JFlex 1.9.1 http://jflex.de/
// source: ast_scanner.flex

/*******************************************************************************
 * Copyright (c) 2006, 2017 Zend Corporation and IBM Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php55;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;

import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.util.collections.StateStack;

import java_cup.sym;
import java_cup.runtime.Symbol;

//@SuppressWarnings({"unused", "nls"})


@SuppressWarnings("fallthrough")
public class PHPAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SCRIPTING = 2;
  public static final int ST_DOUBLE_QUOTES = 4;
  public static final int ST_SINGLE_QUOTE = 6;
  public static final int ST_BACKQUOTE = 8;
  public static final int ST_HEREDOC = 10;
  public static final int ST_NOWDOC = 12;
  public static final int ST_START_HEREDOC = 14;
  public static final int ST_START_NOWDOC = 16;
  public static final int ST_END_HEREDOC = 18;
  public static final int ST_LOOKING_FOR_PROPERTY = 20;
  public static final int ST_LOOKING_FOR_VARNAME = 22;
  public static final int ST_VAR_OFFSET = 24;
  public static final int ST_COMMENT = 26;
  public static final int ST_DOCBLOCK = 28;
  public static final int ST_ONE_LINE_COMMENT = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\37\u0200\1\u0300\266\u0200\10\u0400\40\u0200\u1000\u0500";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\1\1\4"+
    "\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\10\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\1\73\1\74"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\75\1\76\1\77\1\100\1\0\260\66"+
    "\2\45\115\66\1\57\u01aa\66\1\47\325\66\u0100\101\u0100\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[1536];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\2\1\11\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\2\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\25\34\1\35\1\36"+
    "\1\37\1\40\1\34\1\41\1\42\1\43\1\44\1\45"+
    "\1\1\1\46\3\3\1\47\1\50\1\3\1\1\2\3"+
    "\1\51\1\3\2\1\3\3\1\1\2\52\2\53\1\3"+
    "\2\54\1\55\1\56\1\57\1\60\1\5\1\61\1\11"+
    "\1\12\1\14\1\16\1\17\1\21\1\22\1\23\2\62"+
    "\1\25\1\27\1\30\1\31\1\32\1\63\1\40\1\64"+
    "\1\65\1\43\1\66\1\4\1\67\3\4\3\70\2\67"+
    "\1\71\1\0\1\72\1\73\1\74\1\0\1\75\3\0"+
    "\1\76\1\77\1\100\1\101\1\102\14\0\1\103\1\104"+
    "\1\105\1\106\1\107\1\110\1\111\1\112\1\113\1\114"+
    "\3\0\1\115\1\0\1\116\1\117\1\74\1\120\1\121"+
    "\1\122\1\123\1\124\3\34\1\125\1\0\6\34\1\126"+
    "\13\34\1\127\6\34\1\130\15\34\1\131\1\34\1\132"+
    "\1\133\3\0\2\134\1\76\1\135\1\136\1\134\1\0"+
    "\1\137\3\0\2\134\3\0\1\1\2\134\1\1\1\140"+
    "\2\0\1\141\2\0\1\142\2\0\1\143\2\0\1\144"+
    "\1\145\1\0\1\146\1\147\1\0\1\150\13\0\1\151"+
    "\1\0\1\152\1\0\2\111\2\0\1\153\1\154\1\155"+
    "\1\34\1\156\1\34\1\0\11\34\1\157\10\34\1\160"+
    "\12\34\1\161\11\34\1\162\1\34\1\163\1\164\1\34"+
    "\1\165\10\34\1\0\1\166\1\167\1\1\1\170\1\1"+
    "\2\62\13\0\1\171\5\0\4\34\1\172\10\34\1\173"+
    "\1\174\6\34\1\175\5\34\1\176\5\34\1\177\26\34"+
    "\10\0\1\200\11\0\2\201\1\34\1\202\1\203\1\34"+
    "\1\204\1\205\1\206\1\207\5\34\1\210\2\34\1\211"+
    "\3\34\1\212\10\34\1\213\1\34\1\214\7\34\1\215"+
    "\1\216\1\217\1\220\1\221\10\34\1\222\2\223\3\0"+
    "\1\224\4\0\1\225\5\0\5\34\1\226\1\227\1\34"+
    "\1\230\6\34\1\231\10\34\1\232\1\34\1\233\1\234"+
    "\1\235\10\34\1\236\4\0\1\237\2\0\3\34\1\240"+
    "\1\241\4\34\1\242\1\243\1\244\2\34\1\245\4\34"+
    "\1\246\1\34\1\247\1\34\1\250\6\34\1\251\1\252"+
    "\4\0\1\253\1\254\1\255\3\34\1\256\1\257\11\34"+
    "\1\260\2\34\1\261\2\34\2\0\2\34\1\262\3\34"+
    "\1\263\1\264\1\265\1\266\1\34\1\267\4\34\2\0"+
    "\1\270\1\271\1\272\1\34\1\273\3\34\1\274\1\34"+
    "\3\0\5\34\2\0\1\275\1\276\1\277\2\34\1\300"+
    "\1\34\1\301\1\34\1\302";

  private static int [] zzUnpackAction() {
    int [] result = new int[681];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\102\0\204\0\306\0\u0108\0\u014a\0\u018c\0\u01ce"+
    "\0\u0210\0\u0252\0\u0294\0\u02d6\0\u0318\0\u035a\0\u039c\0\u03de"+
    "\0\u0420\0\u0462\0\u04a4\0\u04e6\0\u0528\0\u056a\0\u04a4\0\u05ac"+
    "\0\u05ee\0\u0630\0\u0672\0\u06b4\0\u04a4\0\u06f6\0\u0738\0\u04a4"+
    "\0\u077a\0\u07bc\0\u07fe\0\u0840\0\u0882\0\u08c4\0\u04a4\0\u0906"+
    "\0\u0948\0\u098a\0\u09cc\0\u04a4\0\u0a0e\0\u0a50\0\u0a92\0\u0ad4"+
    "\0\u0b16\0\u0b58\0\u0b9a\0\u0bdc\0\u0c1e\0\u0c60\0\u0ca2\0\u0ce4"+
    "\0\u0d26\0\u0d68\0\u0daa\0\u0dec\0\u0e2e\0\u0e70\0\u0eb2\0\u0ef4"+
    "\0\u0f36\0\u04a4\0\u04a4\0\u04a4\0\u0f78\0\u0fba\0\u04a4\0\u04a4"+
    "\0\u0ffc\0\u04a4\0\u04a4\0\u103e\0\u04a4\0\u1080\0\u10c2\0\u1104"+
    "\0\u1146\0\u04a4\0\u1188\0\u11ca\0\u120c\0\u124e\0\u04a4\0\u1290"+
    "\0\u12d2\0\u1314\0\u1356\0\u1398\0\u13da\0\u141c\0\u04a4\0\u145e"+
    "\0\u04a4\0\u14a0\0\u14e2\0\u04a4\0\u1524\0\u1566\0\u04a4\0\u15a8"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u15ea\0\u162c\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u166e\0\u16b0\0\u04a4\0\u16f2\0\u1734\0\u1776\0\u04a4\0\u17b8"+
    "\0\u17fa\0\u04a4\0\u1776\0\u183c\0\u187e\0\u18c0\0\u1902\0\u056a"+
    "\0\u04a4\0\u1944\0\u1986\0\u19c8\0\u1a0a\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u04a4\0\u0672\0\u1a4c\0\u06b4\0\u1a8e\0\u1ad0\0\u1b12\0\u1b54"+
    "\0\u1b96\0\u1bd8\0\u1c1a\0\u1c5c\0\u1c9e\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u1ce0\0\u04a4\0\u1d22\0\u04a4\0\u1d64"+
    "\0\u1da6\0\u1de8\0\u04a4\0\u1e2a\0\u1e6c\0\u04a4\0\u04a4\0\u1eae"+
    "\0\u04a4\0\u04a4\0\u1ef0\0\u04a4\0\u1f32\0\u1f74\0\u1fb6\0\u0bdc"+
    "\0\u1ff8\0\u203a\0\u207c\0\u20be\0\u2100\0\u2142\0\u2184\0\u0bdc"+
    "\0\u21c6\0\u2208\0\u224a\0\u228c\0\u22ce\0\u2310\0\u2352\0\u2394"+
    "\0\u23d6\0\u2418\0\u245a\0\u0bdc\0\u249c\0\u24de\0\u2520\0\u2562"+
    "\0\u25a4\0\u25e6\0\u0bdc\0\u2628\0\u266a\0\u26ac\0\u26ee\0\u2730"+
    "\0\u2772\0\u27b4\0\u27f6\0\u2838\0\u287a\0\u28bc\0\u28fe\0\u2940"+
    "\0\u04a4\0\u2982\0\u04a4\0\u04a4\0\u29c4\0\u10c2\0\u2a06\0\u04a4"+
    "\0\u29c4\0\u2a48\0\u04a4\0\u04a4\0\u2a06\0\u2a8a\0\u04a4\0\u2acc"+
    "\0\u124e\0\u2b0e\0\u2acc\0\u2b0e\0\u2b50\0\u1398\0\u2b92\0\u2bd4"+
    "\0\u2b50\0\u2b92\0\u2c16\0\u04a4\0\u145e\0\u2c58\0\u04a4\0\u14a0"+
    "\0\u2c9a\0\u04a4\0\u14e2\0\u2cdc\0\u04a4\0\u2d1e\0\u2d60\0\u04a4"+
    "\0\u04a4\0\u1776\0\u04a4\0\u04a4\0\u2da2\0\u04a4\0\u2de4\0\u2e26"+
    "\0\u2e68\0\u2eaa\0\u2eec\0\u2f2e\0\u2f70\0\u2fb2\0\u2ff4\0\u3036"+
    "\0\u3078\0\u30ba\0\u30fc\0\u1d64\0\u313e\0\u313e\0\u1de8\0\u3180"+
    "\0\u31c2\0\u04a4\0\u04a4\0\u04a4\0\u3204\0\u0bdc\0\u3246\0\u3288"+
    "\0\u32ca\0\u330c\0\u334e\0\u3390\0\u33d2\0\u3414\0\u3456\0\u3498"+
    "\0\u34da\0\u0bdc\0\u351c\0\u355e\0\u35a0\0\u35e2\0\u3624\0\u3666"+
    "\0\u36a8\0\u36ea\0\u372c\0\u376e\0\u37b0\0\u37f2\0\u3834\0\u3876"+
    "\0\u38b8\0\u38fa\0\u393c\0\u397e\0\u39c0\0\u0bdc\0\u3a02\0\u3a44"+
    "\0\u3a86\0\u3ac8\0\u3b0a\0\u3b4c\0\u3b8e\0\u3bd0\0\u3c12\0\u0bdc"+
    "\0\u3c54\0\u0bdc\0\u0bdc\0\u3c96\0\u0bdc\0\u3cd8\0\u3d1a\0\u3d5c"+
    "\0\u3d9e\0\u3de0\0\u3e22\0\u3e64\0\u3ea6\0\u3ee8\0\u04a4\0\u04a4"+
    "\0\u3f2a\0\u04a4\0\u3f6c\0\u2d1e\0\u2d60\0\u3fae\0\u3ff0\0\u4032"+
    "\0\u4074\0\u40b6\0\u40f8\0\u413a\0\u417c\0\u41be\0\u4200\0\u4242"+
    "\0\u04a4\0\u4284\0\u42c6\0\u4308\0\u434a\0\u438c\0\u43ce\0\u4410"+
    "\0\u4452\0\u4494\0\u0bdc\0\u44d6\0\u4518\0\u455a\0\u459c\0\u45de"+
    "\0\u4620\0\u4662\0\u46a4\0\u0bdc\0\u46e6\0\u4728\0\u476a\0\u47ac"+
    "\0\u47ee\0\u4830\0\u4872\0\u0bdc\0\u48b4\0\u48f6\0\u4938\0\u497a"+
    "\0\u49bc\0\u0bdc\0\u49fe\0\u4a40\0\u4a82\0\u4ac4\0\u4b06\0\u0bdc"+
    "\0\u4b48\0\u4b8a\0\u4bcc\0\u4c0e\0\u4c50\0\u4c92\0\u4cd4\0\u4d16"+
    "\0\u4d58\0\u4d9a\0\u4ddc\0\u4e1e\0\u4e60\0\u4ea2\0\u4ee4\0\u4f26"+
    "\0\u4f68\0\u4faa\0\u4fec\0\u502e\0\u5070\0\u50b2\0\u50f4\0\u5136"+
    "\0\u5178\0\u51ba\0\u51fc\0\u523e\0\u5280\0\u52c2\0\u04a4\0\u5304"+
    "\0\u5346\0\u5388\0\u53ca\0\u540c\0\u544e\0\u5490\0\u54d2\0\u5514"+
    "\0\u04a4\0\u5556\0\u5598\0\u0bdc\0\u0bdc\0\u55da\0\u0bdc\0\u0bdc"+
    "\0\u0bdc\0\u0bdc\0\u561c\0\u565e\0\u56a0\0\u56e2\0\u5724\0\u0bdc"+
    "\0\u5766\0\u57a8\0\u0bdc\0\u57ea\0\u582c\0\u586e\0\u58b0\0\u58f2"+
    "\0\u5934\0\u5976\0\u59b8\0\u59fa\0\u5a3c\0\u5a7e\0\u5ac0\0\u0bdc"+
    "\0\u5b02\0\u0bdc\0\u5b44\0\u5b86\0\u5bc8\0\u5c0a\0\u5c4c\0\u5c8e"+
    "\0\u5cd0\0\u0bdc\0\u0bdc\0\u0bdc\0\u0bdc\0\u0bdc\0\u5d12\0\u5d54"+
    "\0\u5d96\0\u5dd8\0\u5e1a\0\u5e5c\0\u5e9e\0\u5ee0\0\u04a4\0\u04a4"+
    "\0\u5f22\0\u5f64\0\u5fa6\0\u5fe8\0\u04a4\0\u602a\0\u606c\0\u60ae"+
    "\0\u60f0\0\u04a4\0\u6132\0\u6174\0\u61b6\0\u61f8\0\u623a\0\u627c"+
    "\0\u62be\0\u6300\0\u6342\0\u6384\0\u0bdc\0\u0bdc\0\u63c6\0\u6408"+
    "\0\u644a\0\u648c\0\u64ce\0\u6510\0\u6552\0\u6594\0\u0bdc\0\u65d6"+
    "\0\u6618\0\u665a\0\u669c\0\u66de\0\u6720\0\u6762\0\u67a4\0\u0bdc"+
    "\0\u67e6\0\u0bdc\0\u0bdc\0\u0bdc\0\u6828\0\u686a\0\u68ac\0\u68ee"+
    "\0\u6930\0\u6972\0\u69b4\0\u69f6\0\u04a4\0\u6a38\0\u6a7a\0\u6abc"+
    "\0\u6afe\0\u04a4\0\u6b40\0\u6b82\0\u6bc4\0\u6c06\0\u6c48\0\u0bdc"+
    "\0\u0bdc\0\u6c8a\0\u6ccc\0\u6d0e\0\u6d50\0\u0bdc\0\u0bdc\0\u0bdc"+
    "\0\u6d92\0\u6dd4\0\u6e16\0\u6e58\0\u6e9a\0\u6edc\0\u6f1e\0\u0bdc"+
    "\0\u6f60\0\u6fa2\0\u6fe4\0\u0bdc\0\u7026\0\u7068\0\u70aa\0\u70ec"+
    "\0\u712e\0\u7170\0\u04a4\0\u04a4\0\u71b2\0\u71f4\0\u7236\0\u7278"+
    "\0\u0bdc\0\u0bdc\0\u0bdc\0\u72ba\0\u72fc\0\u733e\0\u0bdc\0\u0bdc"+
    "\0\u7380\0\u73c2\0\u7404\0\u7446\0\u7488\0\u74ca\0\u750c\0\u754e"+
    "\0\u7590\0\u0bdc\0\u75d2\0\u7614\0\u0bdc\0\u7656\0\u7698\0\u76da"+
    "\0\u771c\0\u775e\0\u77a0\0\u0bdc\0\u77e2\0\u7824\0\u7866\0\u0bdc"+
    "\0\u0bdc\0\u0bdc\0\u0bdc\0\u78a8\0\u0bdc\0\u78ea\0\u792c\0\u796e"+
    "\0\u79b0\0\u79f2\0\u7a34\0\u0bdc\0\u0bdc\0\u0bdc\0\u7a76\0\u0bdc"+
    "\0\u7ab8\0\u7afa\0\u7b3c\0\u0bdc\0\u7b7e\0\u7bc0\0\u7c02\0\u7c44"+
    "\0\u7c86\0\u7cc8\0\u7d0a\0\u7d4c\0\u7d8e\0\u7dd0\0\u7e12\0\u0bdc"+
    "\0\u0bdc\0\u0bdc\0\u7e54\0\u7e96\0\u04a4\0\u7ed8\0\u0bdc\0\u7f1a"+
    "\0\u0bdc";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[681];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\30\21\1\22\51\21\1\23\3\24\1\25\1\26\1\27"+
    "\1\30\1\31\1\32\1\33\1\34\1\35\1\36\1\37"+
    "\1\40\1\41\1\42\1\43\1\44\2\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\2\64\1\66"+
    "\1\64\1\67\1\70\1\71\1\64\1\72\1\73\1\74"+
    "\1\75\1\76\1\77\1\100\1\101\1\64\1\102\1\103"+
    "\1\104\1\105\1\106\1\107\1\110\1\111\1\112\1\113"+
    "\1\64\5\114\1\115\1\114\1\116\60\114\1\117\4\114"+
    "\1\120\4\114\12\121\1\122\55\121\1\123\11\121\7\124"+
    "\1\125\60\124\1\126\3\124\1\127\1\130\4\124\2\131"+
    "\2\132\3\131\1\133\60\131\1\134\4\131\1\135\4\131"+
    "\2\7\2\136\76\7\35\137\32\140\4\137\1\140\5\137"+
    "\1\140\35\141\32\142\4\141\1\142\5\141\1\142\35\23"+
    "\32\143\4\23\1\143\5\23\1\143\1\144\3\24\14\144"+
    "\1\145\14\144\32\146\4\144\1\146\5\144\1\146\35\147"+
    "\32\150\4\147\1\150\5\147\1\150\1\23\3\151\1\152"+
    "\1\153\1\151\1\30\1\154\1\155\1\151\1\156\1\35"+
    "\1\157\1\160\1\40\1\161\1\162\1\163\1\164\2\165"+
    "\1\166\1\47\1\167\1\170\1\171\1\172\1\54\32\64"+
    "\1\102\1\151\1\173\1\174\1\64\1\175\1\176\1\177"+
    "\1\200\1\113\1\64\15\201\1\202\64\201\3\203\1\204"+
    "\11\203\1\205\64\203\2\206\1\207\1\210\4\206\1\211"+
    "\21\206\1\212\1\211\45\206\1\213\30\21\1\214\61\21"+
    "\1\215\17\21\1\0\2\21\1\216\46\21\103\0\3\24"+
    "\127\0\1\217\50\0\5\220\1\221\1\220\1\222\60\220"+
    "\1\223\4\220\1\224\4\220\35\0\32\225\4\0\1\225"+
    "\5\0\1\225\31\0\1\226\1\227\60\0\1\230\17\0"+
    "\1\231\50\0\12\232\1\221\55\232\1\233\11\232\1\0"+
    "\1\234\33\0\1\235\1\236\1\0\1\237\1\0\1\240"+
    "\2\0\1\241\5\0\1\242\2\0\1\243\1\244\1\0"+
    "\1\245\51\0\1\246\66\0\1\247\12\0\1\250\70\0"+
    "\1\251\10\0\1\252\1\253\72\0\3\254\3\0\1\255"+
    "\65\0\1\256\4\0\1\27\6\0\1\257\71\0\1\254"+
    "\1\0\3\45\10\0\1\260\2\0\1\261\22\0\1\262"+
    "\36\0\1\254\1\0\3\45\13\0\1\261\66\0\1\263"+
    "\75\0\1\264\5\0\1\265\1\266\1\267\100\0\1\270"+
    "\1\271\100\0\1\272\1\273\101\0\1\274\72\0\3\64"+
    "\7\0\1\64\1\275\13\64\1\276\3\64\1\277\1\300"+
    "\7\64\4\0\1\64\5\0\1\64\5\0\1\26\4\0"+
    "\1\232\10\0\3\64\2\0\1\301\4\0\21\64\1\302"+
    "\10\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\1\303\12\64\1\304\2\64\1\305\13\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\4\64\1\306\3\64"+
    "\1\307\5\64\1\310\13\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\2\64\1\311\10\64\1\312\1\313"+
    "\1\314\7\64\1\315\1\64\1\316\2\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\10\64\1\317\5\64"+
    "\1\320\5\64\1\321\5\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\13\64\1\322\2\64\1\323\13\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\32\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\5\64"+
    "\1\324\6\64\1\325\1\326\4\64\1\327\7\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\10\64\1\330"+
    "\21\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\1\331\3\64\1\332\25\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\21\64\1\333\10\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\21\64\1\334\2\64"+
    "\1\335\5\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\4\64\1\336\25\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\23\64\1\337\2\64\1\340\3\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\7\64"+
    "\1\341\11\64\1\342\10\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\15\64\1\343\4\64\1\344\7\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\1\345"+
    "\31\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\7\64\1\346\22\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\16\64\1\347\13\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\10\64\1\350\21\64\4\0"+
    "\1\64\5\0\1\64\31\0\1\351\73\0\3\64\7\0"+
    "\32\64\4\0\1\352\5\0\1\64\31\0\1\353\44\0"+
    "\1\354\3\0\5\114\1\0\1\114\1\355\60\114\1\356"+
    "\4\114\1\357\11\114\1\360\1\114\1\361\25\114\32\362"+
    "\1\114\1\356\2\114\1\362\1\114\1\363\3\114\1\362"+
    "\107\114\1\360\1\114\1\364\60\114\1\356\4\114\1\365"+
    "\4\114\12\121\1\0\55\121\1\366\23\121\1\367\55\121"+
    "\1\367\11\121\7\124\1\370\60\124\1\371\3\124\1\0"+
    "\1\372\13\124\1\373\25\124\32\362\1\124\1\371\2\124"+
    "\1\362\1\360\1\363\3\124\1\362\111\124\1\364\60\124"+
    "\1\371\3\124\1\360\1\374\4\124\2\131\2\132\3\131"+
    "\1\375\60\131\1\376\4\131\1\377\6\131\2\132\3\131"+
    "\1\375\25\131\32\u0100\1\131\1\376\2\131\1\u0100\1\131"+
    "\1\377\3\131\1\u0100\2\131\2\132\3\131\1\u0101\25\131"+
    "\32\362\1\131\1\376\2\131\1\362\1\131\1\363\3\131"+
    "\1\362\2\131\2\132\100\131\2\132\3\131\1\364\60\131"+
    "\1\376\4\131\1\u0102\4\131\2\7\2\136\31\7\32\u0103"+
    "\4\7\1\u0103\5\7\1\u0103\2\0\2\u0104\17\0\3\u0105"+
    "\1\0\1\u0106\5\0\32\u0105\4\0\1\u0105\5\0\1\u0105"+
    "\2\0\2\u0107\17\0\3\u0108\1\0\1\u0109\5\0\32\u0108"+
    "\4\0\1\u0108\5\0\1\u0108\2\0\2\u010a\17\0\3\u010b"+
    "\1\0\1\u010c\5\0\32\u010b\4\0\1\u010b\5\0\1\u010b"+
    "\32\0\1\u010d\72\0\3\146\7\0\32\146\4\0\1\146"+
    "\5\0\1\146\23\0\3\150\7\0\32\150\4\0\1\150"+
    "\5\0\1\150\23\0\3\165\10\0\1\u010e\25\0\1\u010f"+
    "\40\0\3\165\54\0\15\201\1\0\64\201\22\0\1\u0110"+
    "\61\0\1\203\121\0\1\u0111\57\0\2\206\1\207\1\210"+
    "\4\206\1\207\21\206\2\207\45\206\1\u0112\2\0\1\207"+
    "\131\0\1\u0113\47\0\10\21\1\0\17\21\1\0\2\21"+
    "\1\0\46\21\31\0\1\u0114\101\0\1\u0114\22\0\1\u0115"+
    "\56\0\1\u0116\50\0\5\220\1\221\1\220\1\222\25\220"+
    "\32\0\1\220\1\223\2\220\1\0\1\220\1\0\3\220"+
    "\1\0\107\220\1\221\1\220\1\0\60\220\1\223\4\220"+
    "\1\224\4\220\23\0\3\225\7\0\32\225\4\0\1\225"+
    "\5\0\1\225\102\232\56\0\1\u0117\70\0\1\u0118\5\0"+
    "\1\u0119\101\0\1\u011a\76\0\1\u011b\103\0\1\u011c\65\0"+
    "\1\u011d\104\0\1\u011e\120\0\1\u011f\73\0\1\u0120\52\0"+
    "\3\254\13\0\1\261\41\0\3\u0121\11\0\1\u0122\16\0"+
    "\1\u0123\70\0\2\u0124\73\0\1\u0125\1\0\1\u0125\2\0"+
    "\3\u0126\77\0\3\u0127\7\0\6\u0127\116\0\1\u0128\52\0"+
    "\1\u0129\1\u012a\101\0\1\u012b\101\0\1\u012c\73\0\3\64"+
    "\7\0\22\64\1\u012d\7\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\3\64\1\u012e\26\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\21\64\1\u012f\10\64"+
    "\4\0\1\64\5\0\1\64\30\0\1\u0130\74\0\3\64"+
    "\7\0\4\64\1\u0131\25\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\13\64\1\u0132\6\64\1\u0133\1\u0134"+
    "\6\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\1\u0135\15\64\1\u0136\13\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\15\64\1\u0137\14\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\2\64\1\u0138\2\64"+
    "\1\u0139\24\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\4\64\1\u013a\25\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\7\64\1\u013b\22\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\22\64\1\u013c\7\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\17\64"+
    "\1\u013d\12\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\3\64\1\u013e\26\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\1\u013f\31\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\10\64\1\u0140\12\64\1\u0141"+
    "\6\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\15\64\1\u0142\14\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\21\64\1\u0143\10\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\15\64\1\u0144\14\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\16\64\1\u0145"+
    "\13\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\23\64\1\u0146\6\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\17\64\1\u0147\12\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\2\64\1\u0148\17\64\1\u0149"+
    "\1\u014a\6\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\22\64\1\u014b\7\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\22\64\1\u014c\7\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\14\64\1\u014d\15\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\26\64"+
    "\1\u014e\3\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\10\64\1\u014f\5\64\1\u0150\13\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\1\64\1\u0151\30\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\20\64"+
    "\1\u0152\2\64\1\u0153\6\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\1\u0154\31\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\10\64\1\u0155\21\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\21\64\1\u0156"+
    "\10\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\1\u0157\27\64\1\u0158\1\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\22\64\1\u0159\7\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\4\64\1\u015a\25\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\21\64"+
    "\1\u015b\10\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\10\64\1\u015c\21\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\21\64\1\u015d\10\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\4\64\1\u015e\25\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\2\64"+
    "\1\u015f\1\u0160\1\64\1\u0161\1\64\1\u0162\3\64\1\u0163"+
    "\1\u0164\1\u0165\14\64\4\0\1\64\5\0\1\64\5\114"+
    "\1\360\1\114\1\361\25\114\32\0\1\114\1\356\2\114"+
    "\1\0\1\114\1\0\3\114\1\0\5\114\1\360\1\114"+
    "\1\0\60\114\1\356\4\114\1\365\4\114\20\0\1\u0166"+
    "\2\0\3\362\7\0\32\362\1\u0167\3\0\1\362\5\0"+
    "\1\362\12\121\1\0\55\121\1\0\11\121\7\124\1\373"+
    "\25\124\32\0\1\124\1\371\2\124\1\0\1\360\1\0"+
    "\3\124\1\0\7\124\1\0\60\124\1\371\3\124\1\360"+
    "\1\374\4\124\2\131\2\132\3\131\1\u0101\25\131\32\0"+
    "\1\131\1\376\2\131\1\0\1\131\1\0\3\131\1\0"+
    "\2\131\2\132\3\131\1\0\60\131\1\376\4\131\1\u0102"+
    "\6\131\2\u0168\3\131\1\375\13\131\3\u0100\1\131\1\u0169"+
    "\5\131\32\u0100\1\131\1\376\2\131\1\u0100\1\131\1\377"+
    "\3\131\1\u0100\2\7\2\u016a\17\7\3\u0103\1\7\1\u016b"+
    "\5\7\32\u0103\4\7\1\u0103\5\7\1\u0103\2\0\2\u0104"+
    "\100\0\2\u0107\100\0\2\u010a\121\0\2\u016c\100\0\3\u016d"+
    "\7\0\6\u016d\103\0\1\u016e\113\0\1\u016f\75\0\1\u0170"+
    "\102\0\1\u0171\107\0\1\u0172\73\0\1\u0173\106\0\1\u0174"+
    "\67\0\1\u0175\70\0\1\u0176\122\0\1\u0177\102\0\1\u0178"+
    "\23\0\3\u0121\30\0\1\u0123\67\0\1\u0179\141\0\1\u017a"+
    "\42\0\3\u0126\113\0\1\u017b\43\0\1\u0129\3\0\1\u017c"+
    "\4\0\1\u017d\22\0\32\u017e\4\0\1\u017e\5\0\1\u017e"+
    "\23\0\3\64\7\0\23\64\1\u017f\6\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\1\u0180\31\64\4\0"+
    "\1\64\5\0\1\64\30\0\1\u0129\74\0\3\64\7\0"+
    "\1\u0181\31\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\13\64\1\u0182\16\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\4\64\1\u0183\25\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\2\64\1\u0184\27\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\22\64"+
    "\1\u0185\7\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\15\64\1\u0186\14\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\22\64\1\u0187\1\u0188\6\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\13\64\1\u0189"+
    "\16\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\1\u018a\7\64\1\u018b\21\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\16\64\1\u018c\13\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\4\64\1\u018d\25\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\23\64"+
    "\1\u018e\6\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\3\64\1\u018f\1\64\1\u0190\2\64\1\u0191\11\64"+
    "\1\u0192\3\64\1\u0193\3\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\13\64\1\u0194\16\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\23\64\1\u013a\6\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\4\64"+
    "\1\u0195\25\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\1\u0196\31\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\4\64\1\u0197\25\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\2\64\1\u0198\27\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\1\64\1\u0199"+
    "\30\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\16\64\1\u019a\13\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\13\64\1\u019b\16\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\13\64\1\u019c\16\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\23\64\1\u019d"+
    "\6\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\4\64\1\u019e\25\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\4\64\1\u019f\25\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\23\64\1\u01a0\6\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\4\64\1\u01a1"+
    "\25\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\15\64\1\u01a2\7\64\1\u01a3\4\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\23\64\1\u01a4\6\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\13\64\1\u01a5"+
    "\16\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\24\64\1\u01a6\5\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\24\64\1\u01a7\5\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\23\64\1\u01a8\6\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\23\64\1\u01a9"+
    "\6\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\16\64\1\u01aa\13\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\10\64\1\u01ab\21\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\4\64\1\u01ac\25\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\13\64\1\u01ad"+
    "\16\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\13\64\1\u01ae\16\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\13\64\1\u01af\16\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\10\64\1\u01b0\21\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\10\64\1\u01b1"+
    "\13\64\1\u01b2\5\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\1\u01b3\31\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\10\64\1\u01b4\21\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\4\64\1\u01b5\25\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\1\u01b6"+
    "\31\64\4\0\1\64\5\0\1\64\32\0\1\u01b7\47\0"+
    "\2\131\2\u0168\3\131\1\375\60\131\1\376\4\131\1\377"+
    "\4\131\2\7\2\u016a\76\7\54\0\1\u01b8\62\0\1\u01b9"+
    "\101\0\1\u01ba\114\0\1\u01bb\67\0\1\u01bc\100\0\1\u01bd"+
    "\45\0\1\u01be\12\0\1\u01bf\24\0\1\u01c0\101\0\1\u01c1"+
    "\110\0\1\u01c2\76\0\1\u01c3\75\0\1\u01c4\75\0\1\u01c5"+
    "\122\0\1\u01c6\60\0\32\u01c7\4\0\1\u01c7\5\0\1\u01c7"+
    "\35\0\32\u01c8\4\0\1\u01c8\5\0\1\u01c8\2\0\1\u01c9"+
    "\1\u01ca\17\0\3\u017e\7\0\32\u017e\4\0\1\u017e\5\0"+
    "\1\u017e\23\0\3\64\7\0\21\64\1\u01cb\10\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\30\64\1\u01cc"+
    "\1\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\12\64\1\u01cd\17\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\1\u01ce\31\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\7\64\1\u01cf\22\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\22\64\1\u01d0\7\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\4\64"+
    "\1\u01d1\25\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\23\64\1\u01d2\6\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\10\64\1\u01d3\21\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\1\u01d4\31\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\24\64\1\u01d5"+
    "\5\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\15\64\1\u01d6\14\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\10\64\1\u01d7\21\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\30\64\1\u01d8\1\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\4\64\1\u01d9"+
    "\25\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\16\64\1\u01da\13\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\5\64\1\u01db\24\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\26\64\1\u01dc\3\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\7\64\1\u01dd"+
    "\22\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\15\64\1\u01de\14\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\13\64\1\u01df\16\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\1\u01e0\31\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\23\64\1\u01e1\6\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\1\u01e2"+
    "\31\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\4\64\1\u01e3\25\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\24\64\1\u01e4\5\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\1\u01e5\3\64\1\u01e6\25\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\21\64"+
    "\1\u01e7\10\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\23\64\1\u01e8\6\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\22\64\1\u01e9\7\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\23\64\1\u01ea\6\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\1\u01eb"+
    "\31\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\4\64\1\u01ec\25\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\10\64\1\u01ed\21\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\10\64\1\u01ee\21\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\21\64\1\u01ef"+
    "\10\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\10\64\1\u01f0\21\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\2\64\1\u01f1\27\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\26\64\1\u01f2\3\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\23\64\1\u01f3"+
    "\6\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\23\64\1\u01f4\6\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\4\64\1\u01f5\25\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\3\64\1\u01f6\26\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\1\u01f7\31\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\21\64"+
    "\1\u01f8\10\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\13\64\1\u01f9\16\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\15\64\1\u01fa\14\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\13\64\1\u01fb\16\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\15\64"+
    "\1\u01fc\14\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\23\64\1\u01fd\6\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\14\64\1\u01fe\15\64\4\0\1\64"+
    "\5\0\1\64\35\0\32\u01ff\4\0\1\u01ff\5\0\1\u01ff"+
    "\1\0\2\u0200\1\u0201\163\0\1\u0202\72\0\1\u0203\24\0"+
    "\1\u0204\12\0\1\u0205\24\0\1\u0206\110\0\1\u0207\111\0"+
    "\1\u01c2\22\0\1\u01be\12\0\1\u01bf\130\0\1\u0208\75\0"+
    "\1\u0209\43\0\1\u01c2\12\0\1\u020a\137\0\1\u020b\107\0"+
    "\1\u020c\77\0\1\u020d\70\0\1\u020e\41\0\1\u020f\15\0"+
    "\3\u01c7\7\0\32\u01c7\4\0\1\u01c7\5\0\1\u01c7\12\0"+
    "\1\u020f\10\0\3\u01c8\7\0\32\u01c8\4\0\1\u01c8\5\0"+
    "\1\u01c8\2\0\1\u01c9\122\0\3\64\7\0\1\u0210\31\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\1\64"+
    "\1\u0211\30\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\15\64\1\u0212\14\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\21\64\1\u0213\10\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\13\64\1\u0214\16\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\4\64"+
    "\1\u0215\25\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\5\64\1\u0216\24\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\2\64\1\u0217\27\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\21\64\1\u0218\10\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\10\64"+
    "\1\u0219\21\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\10\64\1\u021a\21\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\3\64\1\u021b\26\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\13\64\1\u021c\16\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\2\64"+
    "\1\u021d\27\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\10\64\1\u021e\21\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\13\64\1\u021f\16\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\14\64\1\u0220\15\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\3\64"+
    "\1\u0221\26\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\15\64\1\u0222\14\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\1\u0223\31\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\5\64\1\u0224\24\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\17\64\1\u0225"+
    "\12\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\23\64\1\u0226\6\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\2\64\1\u0227\27\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\2\64\1\u0228\27\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\21\64\1\u0229"+
    "\10\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\15\64\1\u022a\14\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\2\64\1\u022b\27\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\7\64\1\u022c\22\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\22\64\1\u022d"+
    "\7\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\32\64\4\0\1\u022e\5\0\1\64\23\0\3\64\7\0"+
    "\4\64\1\u022f\25\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\2\64\1\u0230\27\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\23\64\1\u0231\6\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\4\64\1\u0232"+
    "\25\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\7\64\1\u0233\22\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\4\64\1\u0234\25\64\4\0\1\64\5\0"+
    "\1\64\2\0\1\u0200\100\0\1\u0202\12\0\1\u0235\152\0"+
    "\1\u0236\15\0\1\u0204\12\0\1\u0205\122\0\1\u0237\105\0"+
    "\1\u01c2\101\0\1\u0238\120\0\1\u0239\64\0\1\u0236\37\0"+
    "\1\u020c\12\0\1\u023a\66\0\3\u023b\152\0\1\u023c\27\0"+
    "\1\u01c9\1\u01ca\121\0\3\64\7\0\2\64\1\u023d\27\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\13\64"+
    "\1\u023e\16\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\24\64\1\u023f\5\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\4\64\1\u0240\25\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\23\64\1\u0241\6\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\13\64"+
    "\1\u0242\16\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\4\64\1\u0243\25\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\23\64\1\u0244\6\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\13\64\1\u0245\16\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\22\64"+
    "\1\u0246\7\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\30\64\1\u0247\1\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\7\64\1\u0248\22\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\16\64\1\u0249\13\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\4\64"+
    "\1\u024a\25\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\4\64\1\u024b\25\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\2\64\1\u024c\27\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\3\64\1\u024d\26\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\1\u024e"+
    "\31\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\1\u024f\31\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\4\64\1\u0250\25\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\23\64\1\u0251\6\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\4\64\1\u0252\25\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\22\64"+
    "\1\u0253\7\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\32\64\4\0\1\u0254\5\0\1\64\23\0\3\64"+
    "\7\0\32\64\4\0\1\u0255\5\0\1\64\23\0\3\64"+
    "\7\0\23\64\1\u0256\6\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\32\64\4\0\1\u0257\5\0\1\64"+
    "\23\0\3\64\7\0\32\64\4\0\1\u0258\5\0\1\64"+
    "\23\0\3\64\7\0\16\64\1\u0259\13\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\22\64\1\u025a\7\64"+
    "\4\0\1\64\5\0\1\64\1\0\1\u0236\12\0\1\u025b"+
    "\137\0\1\u0204\105\0\1\u01be\24\0\1\u0239\12\0\1\u025c"+
    "\66\0\3\u023b\3\0\1\u025d\25\0\32\u025e\3\u025f\1\0"+
    "\1\u025e\2\0\1\u025f\2\0\1\u025e\60\0\1\u0260\44\0"+
    "\3\64\7\0\23\64\1\u0261\6\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\4\64\1\u0262\25\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\4\64\1\u0263"+
    "\25\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\1\u0264\31\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\1\u0265\31\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\2\64\1\u0266\27\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\4\64\1\u0267\25\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\15\64\1\u0268"+
    "\14\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\15\64\1\u0269\14\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\32\64\4\0\1\u026a\5\0\1\64\23\0"+
    "\3\64\7\0\4\64\1\u026b\25\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\16\64\1\u026c\13\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\2\64\1\u026d"+
    "\27\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\2\64\1\u026e\27\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\4\64\1\u026f\25\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\32\64\4\0\1\u0270\5\0"+
    "\1\64\23\0\3\64\7\0\32\64\4\0\1\u0271\5\0"+
    "\1\64\23\0\3\64\7\0\32\64\4\0\1\u0272\5\0"+
    "\1\64\23\0\3\64\7\0\10\64\1\u0273\21\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\2\64\1\u0274"+
    "\27\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\32\64\4\0\1\u0275\5\0\1\64\23\0\3\64\7\0"+
    "\3\64\1\u0276\26\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\17\64\1\u0277\12\64\4\0\1\64\5\0"+
    "\1\64\35\0\32\u0278\4\0\1\u0278\5\0\1\u0278\1\0"+
    "\3\u0279\17\0\3\u025e\7\0\32\u025e\3\u025f\1\0\1\u025e"+
    "\2\0\1\u025f\2\0\1\u025e\1\0\3\u0279\31\0\32\u025e"+
    "\3\u025f\1\0\1\u025e\2\0\1\u025f\2\0\1\u025e\1\0"+
    "\3\u0260\26\0\1\274\72\0\3\64\7\0\21\64\1\u027a"+
    "\10\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\2\64\1\u027b\27\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\7\64\1\u027c\22\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\23\64\1\u027d\6\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\16\64\1\u027e"+
    "\13\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\16\64\1\u027f\13\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\5\64\1\u0280\24\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\4\64\1\u0281\25\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\4\64\1\u0282"+
    "\25\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\3\64\1\u0283\26\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\16\64\1\u0284\13\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\32\64\4\0\1\u0285\5\0"+
    "\1\64\23\0\3\64\7\0\16\64\1\u0286\13\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\16\64\1\u0287"+
    "\13\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\32\64\4\0\1\u0288\5\0\1\64\23\0\3\64\7\0"+
    "\1\u0289\31\64\4\0\1\64\5\0\1\64\1\0\3\u028a"+
    "\17\0\3\u0278\7\0\32\u0278\4\0\1\u0278\5\0\1\u0278"+
    "\1\0\3\u0279\3\0\1\u028b\115\0\3\64\7\0\4\64"+
    "\1\u028c\25\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\7\64\1\u028d\22\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\22\64\1\u028e\7\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\15\64\1\u028f\14\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\5\64"+
    "\1\u0290\24\64\4\0\1\64\5\0\1\64\23\0\3\64"+
    "\7\0\15\64\1\u0291\14\64\4\0\1\64\5\0\1\64"+
    "\23\0\3\64\7\0\15\64\1\u0292\14\64\4\0\1\64"+
    "\5\0\1\64\23\0\3\64\7\0\14\64\1\u0293\15\64"+
    "\4\0\1\64\5\0\1\64\23\0\3\64\7\0\32\64"+
    "\4\0\1\u0294\5\0\1\64\23\0\3\64\7\0\2\64"+
    "\1\u0295\27\64\4\0\1\64\5\0\1\64\1\0\3\u028a"+
    "\31\0\32\u0296\3\u0297\1\0\1\u0296\2\0\1\u0297\2\0"+
    "\1\u0296\35\0\32\u0298\4\0\1\u0298\5\0\1\u0298\23\0"+
    "\3\64\7\0\2\64\1\u0299\27\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\2\64\1\u029a\27\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\32\64\4\0"+
    "\1\u029b\5\0\1\64\23\0\3\64\7\0\17\64\1\u029c"+
    "\12\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\4\64\1\u029d\25\64\4\0\1\64\5\0\1\64\1\0"+
    "\3\u029e\11\0\1\u029f\5\0\3\u0296\7\0\32\u0296\3\u0297"+
    "\1\0\1\u0296\2\0\1\u0297\2\0\1\u0296\1\0\3\u029e"+
    "\11\0\1\u029f\17\0\32\u0296\3\u0297\1\0\1\u0296\2\0"+
    "\1\u0297\2\0\1\u0296\1\0\3\u029e\11\0\1\u029f\5\0"+
    "\3\u0298\7\0\32\u0298\4\0\1\u0298\5\0\1\u0298\23\0"+
    "\3\64\7\0\4\64\1\u02a0\25\64\4\0\1\64\5\0"+
    "\1\64\23\0\3\64\7\0\4\64\1\u02a1\25\64\4\0"+
    "\1\64\5\0\1\64\23\0\3\64\7\0\32\64\4\0"+
    "\1\u02a2\5\0\1\64\23\0\3\64\7\0\10\64\1\u02a3"+
    "\21\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\32\64\4\0\1\u02a4\5\0\1\64\1\0\3\u029e\11\0"+
    "\1\u029f\106\0\1\u02a5\102\0\3\64\7\0\13\64\1\u02a6"+
    "\16\64\4\0\1\64\5\0\1\64\23\0\3\64\7\0"+
    "\32\64\4\0\1\u02a7\5\0\1\64\23\0\3\64\7\0"+
    "\4\64\1\u02a8\25\64\4\0\1\64\5\0\1\64\23\0"+
    "\3\64\7\0\21\64\1\u02a9\10\64\4\0\1\64\5\0"+
    "\1\64";

  private static int [] zzUnpacktrans() {
    int [] result = new int[32604];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\2\1\11\0\2\1\1\11\3\1\1\11\5\1"+
    "\1\11\2\1\1\11\6\1\1\11\4\1\1\11\25\1"+
    "\3\11\2\1\2\11\1\1\2\11\1\1\1\11\4\1"+
    "\1\11\4\1\1\11\7\1\1\11\1\1\1\11\2\1"+
    "\1\11\2\1\1\11\1\1\13\11\2\1\13\11\2\1"+
    "\1\11\3\1\1\11\2\1\1\11\1\1\1\0\3\1"+
    "\1\0\1\11\3\0\1\1\4\11\14\0\6\11\1\1"+
    "\1\11\1\1\1\11\3\0\1\11\1\0\1\1\2\11"+
    "\1\1\2\11\1\1\1\11\4\1\1\0\47\1\1\11"+
    "\1\1\2\11\3\0\1\11\2\1\2\11\1\1\1\0"+
    "\1\11\3\0\2\1\3\0\4\1\1\11\2\0\1\11"+
    "\2\0\1\11\2\0\1\11\2\0\2\11\1\0\2\11"+
    "\1\0\1\11\13\0\1\1\1\0\1\1\1\0\2\1"+
    "\2\0\3\11\3\1\1\0\65\1\1\0\2\11\1\1"+
    "\1\11\3\1\13\0\1\11\5\0\70\1\10\0\1\11"+
    "\11\0\1\11\65\1\2\11\1\1\3\0\1\11\4\0"+
    "\1\11\5\0\45\1\1\11\4\0\1\11\2\0\36\1"+
    "\2\11\4\0\27\1\2\0\20\1\2\0\12\1\3\0"+
    "\5\1\2\0\5\1\1\11\4\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[681];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  private boolean zzEOFDone;

  /* user code: */
	private final LinkedList<Object> commentList = new LinkedList<>();
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=514632
	// stores nested HEREDOC and NOWDOC ids
	private final Stack<String> heredocIds = new Stack<>();
	private boolean asp_tags = false;
	private boolean short_tags_allowed = true;
	// XXX: "heredocIds" and "stack" are never reset
	private final StateStack stack = new StateStack();
	protected int commentStartPosition;

	private AST ast;

	public void setAST(AST ast) {
		this.ast = ast;
	}

	@Override
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP5_5;
	}

	@Override
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	@Override
	public void resetCommentList() {
		commentList.clear();
	}

	/**
	 * Will only be filled when ast != null
	 */
	@Override
	public LinkedList<Object> getCommentList() {
		return commentList;
	}

	/**
	 * Will only be added when ast != null
	 */
	protected void addComment(int type) {
		if (ast != null) {
			int leftPosition = getTokenStartPosition();
			Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
			commentList.add(comment);
		}
	}

	@Override
	public void setUseAspTagsAsPHP(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}

	@Override
	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}

	private void pushState(int state) {
		stack.pushStack(zzLexicalState);
		yybegin(state);
	}

	private void popState() {
		yybegin(stack.popStack());
	}

	@Override
	public int getCurrentLine() {
		return yyline;
	}

	protected int getTokenStartPosition() {
		return zzStartRead - _zzPushbackPos;
	}

	protected int getTokenLength() {
		return zzMarkedPos - zzStartRead;
	}

	@Override
	public int getLength() {
		return zzEndRead - _zzPushbackPos;
	}

	private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}

	private void handleLineCommentEnd() {
		addComment(Comment.TYPE_SINGLE_LINE);
	}

	private void handleMultilineCommentEnd() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
	}

	protected void handleVarComment() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private Symbol createFullSymbol(int symbolNumber) {
		Symbol symbol = createSymbol(symbolNumber);
		symbol.value = yytext();
		return symbol;
	}

	protected Symbol createSymbol(int symbolNumber) {
		int leftPosition = getTokenStartPosition();
		return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
	}

	public int[] getParameters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
				zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
				zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	/**
	 * Parses a PHPDoc block comment. Underlying reader (zzReader) can be closed
	 * in the process (when EOF is reached).
	 *
	 * @return true when PHPDoc was parsed, false otherwise (false also implies
	 *         that underlying lexer was unavailable)
	 */
	protected boolean parsePHPDoc() {
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if (documentorLexer == null) {
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParameters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParameters());
		return true;
	}

	protected IDocumentorLexer getDocumentorLexer(java.io.Reader reader) {
		return null;
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to previous values, but leaves
	 * the lexical state unchanged. Be careful, method {@link #next_token()}
	 * also caches those properties using internal variables (zzCurrentPosL,
	 * zzMarkedPosL, zzBufferL, zzEndReadL) that should be accordingly resetted
	 * by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 *
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		this.yychar = this.zzStartRead - this._zzPushbackPos;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		// XXX: check if there's no side-effect to reset zzAtBOL
		// when zzAtEOF is false and zzMarkedPos is equal to zzStartRead.
		// One possible case would be that IDocumentorLexer#parse() matches
		// no text at all without being at EOF (i.e. the document lexer returns
		// a zero-length token), which of course would be totally broken...
		this.zzAtBOL = this.zzAtEOF ? false : (parameters[6] != 0);
	}


  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private boolean useOldString = false;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    if (useOldString) {
      String saveOldString = oldString;
      oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
      if (saveOldString != null) {
        oldString = saveOldString + oldString;
      }
    }

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    String saveOldString = oldString;
    oldString = null;

    /* first: make room (if you can) */
    if (zzRefill()) {
      oldString = saveOldString;
      return YYEOF;
    }

    oldString = saveOldString;

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      _zzPushbackPos = 0;
      startPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      oldString = null;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
    
  yyclose();    }
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
          { 	return createSymbol(sym.EOF);
 }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 195: break;
          case 2:
            { return createSymbol(ParserConstants.T_INLINE_HTML);
            }
          // fall through
          case 196: break;
          case 3:
            { // do nothing
            }
          // fall through
          case 197: break;
          case 4:
            { 
            }
          // fall through
          case 198: break;
          case 5:
            { return createSymbol(ParserConstants.T_NOT);
            }
          // fall through
          case 199: break;
          case 6:
            { yybegin(ST_DOUBLE_QUOTES);
	return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 200: break;
          case 7:
            { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
	// yymore();
            }
          // fall through
          case 201: break;
          case 8:
            { return createSymbol(ParserConstants.T_DOLLAR);
            }
          // fall through
          case 202: break;
          case 9:
            { return createSymbol(ParserConstants.T_PRECENT);
            }
          // fall through
          case 203: break;
          case 10:
            { return createSymbol(ParserConstants.T_REFERENCE);
            }
          // fall through
          case 204: break;
          case 11:
            { yybegin(ST_SINGLE_QUOTE);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          // fall through
          case 205: break;
          case 12:
            { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
            }
          // fall through
          case 206: break;
          case 13:
            { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
            }
          // fall through
          case 207: break;
          case 14:
            { return createSymbol(ParserConstants.T_TIMES);
            }
          // fall through
          case 208: break;
          case 15:
            { return createSymbol(ParserConstants.T_PLUS);
            }
          // fall through
          case 209: break;
          case 16:
            { return createSymbol(ParserConstants.T_COMMA);
            }
          // fall through
          case 210: break;
          case 17:
            { return createSymbol(ParserConstants.T_MINUS);
            }
          // fall through
          case 211: break;
          case 18:
            { return createSymbol(ParserConstants.T_NEKUDA);
            }
          // fall through
          case 212: break;
          case 19:
            { return createSymbol(ParserConstants.T_DIV);
            }
          // fall through
          case 213: break;
          case 20:
            { return createFullSymbol(ParserConstants.T_LNUMBER);
            }
          // fall through
          case 214: break;
          case 21:
            { return createSymbol(ParserConstants.T_NEKUDOTAIM);
            }
          // fall through
          case 215: break;
          case 22:
            { return createSymbol(ParserConstants.T_SEMICOLON);
            }
          // fall through
          case 216: break;
          case 23:
            { return createSymbol(ParserConstants.T_RGREATER);
            }
          // fall through
          case 217: break;
          case 24:
            { return createSymbol(ParserConstants.T_EQUAL);
            }
          // fall through
          case 218: break;
          case 25:
            { return createSymbol(ParserConstants.T_LGREATER);
            }
          // fall through
          case 219: break;
          case 26:
            { return createSymbol(ParserConstants.T_QUESTION_MARK);
            }
          // fall through
          case 220: break;
          case 27:
            { return createSymbol(ParserConstants.T_AT);
            }
          // fall through
          case 221: break;
          case 28:
            { return createFullSymbol(ParserConstants.T_STRING);
            }
          // fall through
          case 222: break;
          case 29:
            { return createSymbol(ParserConstants.T_OPEN_RECT);
            }
          // fall through
          case 223: break;
          case 30:
            { return createSymbol(ParserConstants.T_NS_SEPARATOR);
            }
          // fall through
          case 224: break;
          case 31:
            { return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          // fall through
          case 225: break;
          case 32:
            { return createSymbol(ParserConstants.T_KOVA);
            }
          // fall through
          case 226: break;
          case 33:
            { yybegin(ST_BACKQUOTE);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 227: break;
          case 34:
            { pushState(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          // fall through
          case 228: break;
          case 35:
            { return createSymbol(ParserConstants.T_OR);
            }
          // fall through
          case 229: break;
          case 36:
            { if (!stack.isEmpty()) {
		popState();
	}
	return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          // fall through
          case 230: break;
          case 37:
            { return createSymbol(ParserConstants.T_TILDA);
            }
          // fall through
          case 231: break;
          case 38:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 232: break;
          case 39:
            { return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 233: break;
          case 40:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          // fall through
          case 234: break;
          case 41:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 235: break;
          case 42:
            { yypushback(1);
	yybegin(ST_HEREDOC);
            }
          // fall through
          case 236: break;
          case 43:
            { yypushback(1);
	yybegin(ST_NOWDOC);
            }
          // fall through
          case 237: break;
          case 44:
            { yypushback(1);
	popState();
            }
          // fall through
          case 238: break;
          case 45:
            { popState();
	return createFullSymbol(ParserConstants.T_STRING);
            }
          // fall through
          case 239: break;
          case 46:
            { yypushback(1);
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 240: break;
          case 47:
            { yybegin(ST_IN_SCRIPTING);
	return createFullSymbol(ParserConstants.T_STRING_VARNAME);
            }
          // fall through
          case 241: break;
          case 48:
            { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 242: break;
          case 49:
            { return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 243: break;
          case 50:
            { /* treat numbers (almost) as strings inside encapsulated strings */
	return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          // fall through
          case 244: break;
          case 51:
            { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          // fall through
          case 245: break;
          case 52:
            { return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 246: break;
          case 53:
            { return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          // fall through
          case 247: break;
          case 54:
            { return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          // fall through
          case 248: break;
          case 55:
            { // yymore();
            }
          // fall through
          case 249: break;
          case 56:
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
	// yymore();
            }
          // fall through
          case 250: break;
          case 57:
            { System.out.print(yytext());
            }
          // fall through
          case 251: break;
          case 58:
            { if (asp_tags) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 252: break;
          case 59:
            { if (short_tags_allowed) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 253: break;
          case 60:
            { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
            }
          // fall through
          case 254: break;
          case 61:
            { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
            }
          // fall through
          case 255: break;
          case 62:
            { return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 256: break;
          case 63:
            { return createSymbol(ParserConstants.T_MOD_EQUAL);
            }
          // fall through
          case 257: break;
          case 64:
            { if (asp_tags) {
		yybegin(YYINITIAL);
		return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 258: break;
          case 65:
            { return createSymbol(ParserConstants.T_BOOLEAN_AND);
            }
          // fall through
          case 259: break;
          case 66:
            { return createSymbol(ParserConstants.T_AND_EQUAL);
            }
          // fall through
          case 260: break;
          case 67:
            { return createSymbol(ParserConstants.T_MUL_EQUAL);
            }
          // fall through
          case 261: break;
          case 68:
            { return createSymbol(ParserConstants.T_INC);
            }
          // fall through
          case 262: break;
          case 69:
            { return createSymbol(ParserConstants.T_PLUS_EQUAL);
            }
          // fall through
          case 263: break;
          case 70:
            { return createSymbol(ParserConstants.T_DEC);
            }
          // fall through
          case 264: break;
          case 71:
            { return createSymbol(ParserConstants.T_MINUS_EQUAL);
            }
          // fall through
          case 265: break;
          case 72:
            { pushState(ST_LOOKING_FOR_PROPERTY);
	return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          // fall through
          case 266: break;
          case 73:
            { return createFullSymbol(ParserConstants.T_DNUMBER);
            }
          // fall through
          case 267: break;
          case 74:
            { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
            }
          // fall through
          case 268: break;
          case 75:
            { handleCommentStart();
	yybegin(ST_COMMENT);
            }
          // fall through
          case 269: break;
          case 76:
            { return createSymbol(ParserConstants.T_DIV_EQUAL);
            }
          // fall through
          case 270: break;
          case 77:
            { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
            }
          // fall through
          case 271: break;
          case 78:
            { return createSymbol(ParserConstants.T_SL);
            }
          // fall through
          case 272: break;
          case 79:
            { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
            }
          // fall through
          case 273: break;
          case 80:
            { return createSymbol(ParserConstants.T_IS_EQUAL);
            }
          // fall through
          case 274: break;
          case 81:
            { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
            }
          // fall through
          case 275: break;
          case 82:
            { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
            }
          // fall through
          case 276: break;
          case 83:
            { return createSymbol(ParserConstants.T_SR);
            }
          // fall through
          case 277: break;
          case 84:
            { yybegin(YYINITIAL);
	return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
            }
          // fall through
          case 278: break;
          case 85:
            { return createSymbol(ParserConstants.T_AS);
            }
          // fall through
          case 279: break;
          case 86:
            { return createSymbol(ParserConstants.T_DO);
            }
          // fall through
          case 280: break;
          case 87:
            { return createSymbol(ParserConstants.T_IF);
            }
          // fall through
          case 281: break;
          case 88:
            { return createSymbol(ParserConstants.T_LOGICAL_OR);
            }
          // fall through
          case 282: break;
          case 89:
            { return createSymbol(ParserConstants.T_XOR_EQUAL);
            }
          // fall through
          case 283: break;
          case 90:
            { return createSymbol(ParserConstants.T_OR_EQUAL);
            }
          // fall through
          case 284: break;
          case 91:
            { return createSymbol(ParserConstants.T_BOOLEAN_OR);
            }
          // fall through
          case 285: break;
          case 92:
            { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 286: break;
          case 93:
            { pushState(ST_LOOKING_FOR_VARNAME);
	return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
            }
          // fall through
          case 287: break;
          case 94:
            { pushState(ST_IN_SCRIPTING);
	yypushback(yylength() - 1);
	return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
            }
          // fall through
          case 288: break;
          case 95:
            { return createSymbol(ParserConstants.T_CHARACTER);
            }
          // fall through
          case 289: break;
          case 96:
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	String heredoc = heredocIds.peek();
	if (yytext.equals(heredoc)) {
		yypushback(nb_pushback);
		heredocIds.pop();
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_END_HEREDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		yybegin(ST_HEREDOC);
	}
            }
          // fall through
          case 290: break;
          case 97:
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	String nowdoc = heredocIds.peek();
	if (yytext.equals(nowdoc)) {
		yypushback(nb_pushback);
		heredocIds.pop();
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_END_HEREDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		yybegin(ST_NOWDOC);
	}
            }
          // fall through
          case 291: break;
          case 98:
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		nb_pushback = 2;
	} else {
		nb_pushback = 1;
	}
	yypushback(nb_pushback);
	heredocIds.pop();
	yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_END_HEREDOC);
            }
          // fall through
          case 292: break;
          case 99:
            { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          // fall through
          case 293: break;
          case 100:
            { handleMultilineCommentEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 294: break;
          case 101:
            { handlePHPDocEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 295: break;
          case 102:
            { if (asp_tags || yytext().charAt(0) != '%') { /* asp comment? */
		handleLineCommentEnd();
		yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
	}
            }
          // fall through
          case 296: break;
          case 103:
            { String yytext = yytext();
	if ((yytext.charAt(1) == '%' && asp_tags)
		|| (yytext.charAt(1) == '?')) {
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_OPEN_TAG_WITH_ECHO);
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 297: break;
          case 104:
            { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
            }
          // fall through
          case 298: break;
          case 105:
            { if (parsePHPDoc()) {
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=316077
	// Reset the internal variables caching the values
	// previously resetted by parsePHPDoc().
	// Actually it would be enough to only reset zzEndReadL,
	// but do it cleanly...
	// Also be careful that those internal variables could
	// change from one version of JFlex to another.
	zzCurrentPosL = zzCurrentPos;
	zzMarkedPosL = zzMarkedPos;
	zzBufferL = zzBuffer;
	zzEndReadL = zzEndRead;
} else {
	handleCommentStart();
	yybegin(ST_DOCBLOCK);
}
            }
          // fall through
          case 299: break;
          case 106:
            { return createFullSymbol(ParserConstants.T_BNUMBER);
            }
          // fall through
          case 300: break;
          case 107:
            { return createSymbol(ParserConstants.T_SL_EQUAL);
            }
          // fall through
          case 301: break;
          case 108:
            { return createSymbol(ParserConstants.T_IS_IDENTICAL);
            }
          // fall through
          case 302: break;
          case 109:
            { return createSymbol(ParserConstants.T_SR_EQUAL);
            }
          // fall through
          case 303: break;
          case 110:
            { return createSymbol(ParserConstants.T_LOGICAL_AND);
            }
          // fall through
          case 304: break;
          case 111:
            { return createFullSymbol(ParserConstants.T_EXIT);
            }
          // fall through
          case 305: break;
          case 112:
            { return createSymbol(ParserConstants.T_FOR);
            }
          // fall through
          case 306: break;
          case 113:
            { return createSymbol(ParserConstants.T_NEW);
            }
          // fall through
          case 307: break;
          case 114:
            { return createSymbol(ParserConstants.T_TRY);
            }
          // fall through
          case 308: break;
          case 115:
            { return createSymbol(ParserConstants.T_USE);
            }
          // fall through
          case 309: break;
          case 116:
            { return createSymbol(ParserConstants.T_VAR);
            }
          // fall through
          case 310: break;
          case 117:
            { return createSymbol(ParserConstants.T_LOGICAL_XOR);
            }
          // fall through
          case 311: break;
          case 118:
            { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 312: break;
          case 119:
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	int textLength = yytext.length();
	String heredoc = heredocIds.peek();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && yytext.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		char c = yytext.charAt(textLength - heredocLength - 1);
		if (c == '\n' || c == '\r') {
			nb_pushback += heredocLength;
			// we need to remove the closing label from the symbol value
			yypushback(nb_pushback);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
	// we must (at least) push the newline character back
	yypushback(1);
            }
          // fall through
          case 313: break;
          case 120:
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	int textLength = yytext.length();
	String nowdoc = heredocIds.peek();
	int nowdocLength = nowdoc.length();
	if (textLength > nowdocLength && yytext.substring(textLength - nowdocLength, textLength).equals(nowdoc)) {
		char c = yytext.charAt(textLength - nowdocLength - 1);
		if (c == '\n' || c == '\r') {
			nb_pushback += nowdocLength;
			// we need to remove the closing label from the symbol value
			yypushback(nb_pushback);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
	// we must (at least) push the newline character back
	yypushback(1);
            }
          // fall through
          case 314: break;
          case 121:
            { handleCommentStart();
	handleMultilineCommentEnd();
            }
          // fall through
          case 315: break;
          case 122:
            { return createSymbol(ParserConstants.T_CASE);
            }
          // fall through
          case 316: break;
          case 123:
            { return createSymbol(ParserConstants.T_ECHO);
            }
          // fall through
          case 317: break;
          case 124:
            { return createSymbol(ParserConstants.T_ELSE);
            }
          // fall through
          case 318: break;
          case 125:
            { return createSymbol(ParserConstants.T_EVAL);
            }
          // fall through
          case 319: break;
          case 126:
            { return createSymbol(ParserConstants.T_GOTO);
            }
          // fall through
          case 320: break;
          case 127:
            { return createSymbol(ParserConstants.T_LIST);
            }
          // fall through
          case 321: break;
          case 128:
            { return createSymbol(ParserConstants.T_INT_CAST);
            }
          // fall through
          case 322: break;
          case 129:
            { String yytext = yytext();
	int removeChars = (yytext.charAt(0) == 'b') ? 4 : 3;
	String hereOrNowDoc = yytext.substring(removeChars).trim();    // for 'b<<<' or '<<<'
	int heredoc_len = hereOrNowDoc.length();

	Symbol sym = createFullSymbol(ParserConstants.T_START_HEREDOC);
	sym.value = hereOrNowDoc;

	if (hereOrNowDoc.charAt(0) == '\'') {
		heredocIds.push(hereOrNowDoc.substring(1, heredoc_len - 1));
		yybegin(ST_START_NOWDOC);
	} else if (hereOrNowDoc.charAt(0) == '"') {
		heredocIds.push(hereOrNowDoc.substring(1, heredoc_len - 1));
		yybegin(ST_START_HEREDOC);
	} else {
		heredocIds.push(hereOrNowDoc);
		yybegin(ST_START_HEREDOC);
	}
	return sym;
            }
          // fall through
          case 323: break;
          case 130:
            { return createSymbol(ParserConstants.T_ARRAY);
            }
          // fall through
          case 324: break;
          case 131:
            { return createSymbol(ParserConstants.T_BREAK);
            }
          // fall through
          case 325: break;
          case 132:
            { return createSymbol(ParserConstants.T_CATCH);
            }
          // fall through
          case 326: break;
          case 133:
            { return createSymbol(ParserConstants.T_CLASS);
            }
          // fall through
          case 327: break;
          case 134:
            { return createSymbol(ParserConstants.T_CLONE);
            }
          // fall through
          case 328: break;
          case 135:
            { return createSymbol(ParserConstants.T_CONST);
            }
          // fall through
          case 329: break;
          case 136:
            { return createSymbol(ParserConstants.T_EMPTY);
            }
          // fall through
          case 330: break;
          case 137:
            { return createSymbol(ParserConstants.T_ENDIF);
            }
          // fall through
          case 331: break;
          case 138:
            { return createSymbol(ParserConstants.T_FINAL);
            }
          // fall through
          case 332: break;
          case 139:
            { return createSymbol(ParserConstants.T_ISSET);
            }
          // fall through
          case 333: break;
          case 140:
            { return createSymbol(ParserConstants.T_PRINT);
            }
          // fall through
          case 334: break;
          case 141:
            { return createSymbol(ParserConstants.T_THROW);
            }
          // fall through
          case 335: break;
          case 142:
            { return createSymbol(ParserConstants.T_TRAIT);
            }
          // fall through
          case 336: break;
          case 143:
            { return createSymbol(ParserConstants.T_UNSET);
            }
          // fall through
          case 337: break;
          case 144:
            { return createSymbol(ParserConstants.T_WHILE);
            }
          // fall through
          case 338: break;
          case 145:
            { return createSymbol(ParserConstants.T_YIELD);
            }
          // fall through
          case 339: break;
          case 146:
            { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 340: break;
          case 147:
            { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
            }
          // fall through
          case 341: break;
          case 148:
            { return createSymbol(ParserConstants.T_BOOL_CAST);
            }
          // fall through
          case 342: break;
          case 149:
            { return createSymbol(ParserConstants.T_DOUBLE_CAST);
            }
          // fall through
          case 343: break;
          case 150:
            { /* not a keyword, used to recognize constants.*/
	return createFullSymbol(ParserConstants.T_DEFINE);
            }
          // fall through
          case 344: break;
          case 151:
            { return createSymbol(ParserConstants.T_ELSEIF);
            }
          // fall through
          case 345: break;
          case 152:
            { return createSymbol(ParserConstants.T_ENDFOR);
            }
          // fall through
          case 346: break;
          case 153:
            { return createSymbol(ParserConstants.T_GLOBAL);
            }
          // fall through
          case 347: break;
          case 154:
            { return createSymbol(ParserConstants.T_PUBLIC);
            }
          // fall through
          case 348: break;
          case 155:
            { return createSymbol(ParserConstants.T_RETURN);
            }
          // fall through
          case 349: break;
          case 156:
            { return createSymbol(ParserConstants.T_STATIC);
            }
          // fall through
          case 350: break;
          case 157:
            { return createSymbol(ParserConstants.T_SWITCH);
            }
          // fall through
          case 351: break;
          case 158:
            { return createSymbol(ParserConstants.T_ARRAY_CAST);
            }
          // fall through
          case 352: break;
          case 159:
            { return createSymbol(ParserConstants.T_UNSET_CAST);
            }
          // fall through
          case 353: break;
          case 160:
            { return createSymbol(ParserConstants.T_DECLARE);
            }
          // fall through
          case 354: break;
          case 161:
            { return createSymbol(ParserConstants.T_DEFAULT);
            }
          // fall through
          case 355: break;
          case 162:
            { return createSymbol(ParserConstants.T_EXTENDS);
            }
          // fall through
          case 356: break;
          case 163:
            { return createSymbol(ParserConstants.T_FINALLY);
            }
          // fall through
          case 357: break;
          case 164:
            { return createSymbol(ParserConstants.T_FOREACH);
            }
          // fall through
          case 358: break;
          case 165:
            { return createSymbol(ParserConstants.T_INCLUDE);
            }
          // fall through
          case 359: break;
          case 166:
            { return createSymbol(ParserConstants.T_PRIVATE);
            }
          // fall through
          case 360: break;
          case 167:
            { return createSymbol(ParserConstants.T_REQUIRE);
            }
          // fall through
          case 361: break;
          case 168:
            { return createSymbol(ParserConstants.T_DIR);
            }
          // fall through
          case 362: break;
          case 169:
            { return createSymbol(ParserConstants.T_STRING_CAST);
            }
          // fall through
          case 363: break;
          case 170:
            { return createSymbol(ParserConstants.T_OBJECT_CAST);
            }
          // fall through
          case 364: break;
          case 171:
            { return createSymbol(ParserConstants.T_ABSTRACT);
            }
          // fall through
          case 365: break;
          case 172:
            { return createSymbol(ParserConstants.T_CALLABLE);
            }
          // fall through
          case 366: break;
          case 173:
            { return createSymbol(ParserConstants.T_CONTINUE);
            }
          // fall through
          case 367: break;
          case 174:
            { return createSymbol(ParserConstants.T_ENDWHILE);
            }
          // fall through
          case 368: break;
          case 175:
            { return createSymbol(ParserConstants.T_FUNCTION);
            }
          // fall through
          case 369: break;
          case 176:
            { return createSymbol(ParserConstants.T_FILE);
            }
          // fall through
          case 370: break;
          case 177:
            { return createSymbol(ParserConstants.T_LINE);
            }
          // fall through
          case 371: break;
          case 178:
            { return createSymbol(ParserConstants.T_ENDSWITCH);
            }
          // fall through
          case 372: break;
          case 179:
            { return createSymbol(ParserConstants.T_INSTEADOF);
            }
          // fall through
          case 373: break;
          case 180:
            { return createSymbol(ParserConstants.T_INTERFACE);
            }
          // fall through
          case 374: break;
          case 181:
            { return createSymbol(ParserConstants.T_NAMESPACE);
            }
          // fall through
          case 375: break;
          case 182:
            { return createSymbol(ParserConstants.T_PROTECTED);
            }
          // fall through
          case 376: break;
          case 183:
            { return createSymbol(ParserConstants.T_CLASS_C);
            }
          // fall through
          case 377: break;
          case 184:
            { return createSymbol(ParserConstants.T_ENDDECLARE);
            }
          // fall through
          case 378: break;
          case 185:
            { return createSymbol(ParserConstants.T_ENDFOREACH);
            }
          // fall through
          case 379: break;
          case 186:
            { return createSymbol(ParserConstants.T_IMPLEMENTS);
            }
          // fall through
          case 380: break;
          case 187:
            { return createSymbol(ParserConstants.T_INSTANCEOF);
            }
          // fall through
          case 381: break;
          case 188:
            { return createSymbol(ParserConstants.T_METHOD_C);
            }
          // fall through
          case 382: break;
          case 189:
            { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
            }
          // fall through
          case 383: break;
          case 190:
            { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
            }
          // fall through
          case 384: break;
          case 191:
            { return createSymbol(ParserConstants.T_FUNC_C);
            }
          // fall through
          case 385: break;
          case 192:
            { handleCommentStart();
	handleVarComment();
	//return createFullSymbol(ParserConstants.T_VAR_COMMENT);
            }
          // fall through
          case 386: break;
          case 193:
            { return createSymbol(ParserConstants.T_NS_C);
            }
          // fall through
          case 387: break;
          case 194:
            { return createSymbol(ParserConstants.T_HALT_COMPILER);
            }
          // fall through
          case 388: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String[] argv) {
    if (argv.length == 0) {
      System.out.println("Usage : java PHPAstLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          // Side-effect: is encodingName valid?
          java.nio.charset.Charset.forName(encodingName);
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        PHPAstLexer scanner = null;
        java.io.FileInputStream stream = null;
        java.io.Reader reader = null;
        try {
          stream = new java.io.FileInputStream(argv[i]);
          reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new PHPAstLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
        finally {
          if (reader != null) {
            try {
              reader.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
          if (stream != null) {
            try {
              stream.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
        }
      }
    }
  }


}
