/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.RepositoryBundleContainer;
import org.eclipse.pde.internal.ui.shared.target.EditRepositoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.SelectRepositoryContentPage;
import org.eclipse.pde.ui.target.ITargetLocationWizard;

public class RepositoryLocationWizard
extends Wizard
implements ITargetLocationWizard {
    private EditRepositoryContainerPage repositoryPage;
    private ITargetLocation wizardLocation;
    private ITargetDefinition target;
    private RepositoryBundleContainer bundleContainer;
    private SelectRepositoryContentPage selectionPage;

    public RepositoryLocationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    @Override
    public void setTarget(ITargetDefinition target) {
        this.target = target;
    }

    public void addPages() {
        this.repositoryPage = new EditRepositoryContainerPage(this.bundleContainer);
        this.addPage(this.repositoryPage);
        this.selectionPage = new SelectRepositoryContentPage(this.repositoryPage);
        this.addPage(this.selectionPage);
        this.setWindowTitle(this.repositoryPage.getDefaultTitle());
    }

    @Override
    public ITargetLocation[] getLocations() {
        if (this.wizardLocation == null) {
            return new ITargetLocation[0];
        }
        return new ITargetLocation[]{this.wizardLocation};
    }

    public boolean performFinish() {
        this.wizardLocation = this.selectionPage.getBundleContainer();
        if (this.target != null && this.bundleContainer != null) {
            ITargetLocation[] locations = this.target.getTargetLocations();
            int i = 0;
            while (i < locations.length) {
                ITargetLocation location = locations[i];
                if (location == this.bundleContainer) {
                    locations[i] = this.wizardLocation;
                }
                ++i;
            }
            this.target.setTargetLocations(locations);
        }
        return true;
    }

    public void setBundleContainer(RepositoryBundleContainer bundleContainer) {
        this.bundleContainer = bundleContainer;
    }
}

