/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.bc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.function.Supplier;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.internal.bc.i18n.BcMessages;

final class BcEncodedStream {
    private final LicensedProduct product;
    private final InputStream input;
    private final OutputStream output;

    BcEncodedStream(LicensedProduct product, InputStream input, OutputStream output) {
        this.product = product;
        this.input = input;
        this.output = output;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void produce(PGPSecretKey key, String password) throws LicensingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ArmoredOutputStream armored = new ArmoredOutputStream(this.output);
                try {
                    block20: {
                        ClosableGenerator<PGPCompressedDataGenerator> generator = new ClosableGenerator<PGPCompressedDataGenerator>(new PGPCompressedDataGenerator(2), PGPCompressedDataGenerator::close);
                        try {
                            try (BCPGOutputStream stream = new BCPGOutputStream(generator.get().open((OutputStream)armored));){
                                PGPSignatureGenerator signer = this.signer(key, password);
                                signer.generateOnePassVersion(false).encode((OutputStream)stream);
                                this.updateSignatureGenerator(signer, stream);
                                signer.generate().encode((OutputStream)stream);
                            }
                            if (generator == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (generator == null) throw throwable;
                            generator.close();
                            throw throwable;
                        }
                        generator.close();
                    }
                    if (armored == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (armored == null) throw throwable;
                    armored.close();
                    throw throwable;
                }
                armored.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException | PGPException e) {
            throw new LicensingException(String.format(BcMessages.getString("BcStreamCodec_enconde_error"), this.product), e);
        }
    }

    private PGPSignatureGenerator signer(PGPSecretKey key, String password) throws PGPException {
        PGPSignatureGenerator signer = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(key.getPublicKey().getAlgorithm(), 10));
        PGPPrivateKey privateKey = this.privateKey(key, password);
        signer.init(0, privateKey);
        this.traceUser(key, signer);
        return signer;
    }

    private void traceUser(PGPSecretKey key, PGPSignatureGenerator signer) {
        Iterator it = key.getPublicKey().getUserIDs();
        if (!it.hasNext()) {
            return;
        }
        PGPSignatureSubpacketGenerator generator = new PGPSignatureSubpacketGenerator();
        generator.setSignerUserID(false, (String)it.next());
        signer.setHashedSubpackets(generator.generate());
    }

    private PGPPrivateKey privateKey(PGPSecretKey key, String password) throws PGPException {
        PGPDigestCalculatorProvider calcProvider = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build();
        PBESecretKeyDecryptor decryptor = new JcePBESecretKeyDecryptorBuilder(calcProvider).setProvider("BC").build(password.toCharArray());
        return key.extractPrivateKey(decryptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSignatureGenerator(PGPSignatureGenerator signer, BCPGOutputStream stream) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ClosableGenerator<PGPLiteralDataGenerator> generator = new ClosableGenerator<PGPLiteralDataGenerator>(new PGPLiteralDataGenerator(), PGPLiteralDataGenerator::close);
            try {
                try (OutputStream literalDataStream = generator.get().open((OutputStream)stream, 'b', "ignored", new Date(), new byte[1024]);){
                    int ch;
                    while ((ch = this.input.read()) >= 0) {
                        literalDataStream.write(ch);
                        signer.update((byte)ch);
                    }
                }
                if (generator == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (generator == null) throw throwable;
                generator.close();
                throw throwable;
            }
            generator.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static final class ClosableGenerator<G>
    implements Closeable,
    Supplier<G> {
        private final G generator;
        private final Usher<G> usher;

        ClosableGenerator(G generator, Usher<G> usher) {
            this.generator = generator;
            this.usher = usher;
        }

        @Override
        public void close() throws IOException {
            this.usher.close(this.generator);
        }

        @Override
        public G get() {
            return this.generator;
        }
    }

    @FunctionalInterface
    private static interface Usher<G> {
        public void close(G var1) throws IOException;
    }
}

