/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.lpg.AbstractFormattingHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UMLFormattingHelper
extends AbstractFormattingHelper {
    public static final UMLFormattingHelper INSTANCE = new UMLFormattingHelper();

    protected UMLFormattingHelper() {
    }

    public String formatName(Object object) {
        if (object instanceof Element) {
            String name = null;
            if (object instanceof NamedElement) {
                name = ((NamedElement)object).getName();
            }
            if (name == null) {
                name = "<" + this.formatEClassName((EObject)((Element)object)) + ">";
            }
            return this.formatString(name);
        }
        return super.formatName(object);
    }

    protected String getSeparator() {
        return "::";
    }

    public String formatQualifiedName(Object object) {
        if (object instanceof NamedElement) {
            NamedElement named = (NamedElement)object;
            String qualifiedName = named.getQualifiedName();
            if (qualifiedName != null) {
                return this.formatString(qualifiedName);
            }
            ArrayList<String> path = new ArrayList<String>();
            NamedElement element = named;
            while (element != null) {
                path.add(this.formatName(element));
                element = element.getOwner();
            }
            Collections.reverse(path);
            return this.formatPath(path);
        }
        return super.formatQualifiedName(object);
    }

    public String formatPath(List<String> pathName, String name) {
        StringBuilder s = new StringBuilder();
        if (pathName != null) {
            int iMax = pathName.size();
            int i = 0;
            while (i < iMax) {
                s.append(this.formatString(pathName.get(i)));
                s.append(this.getSeparator());
                ++i;
            }
        }
        s.append(this.formatString(name));
        return s.toString();
    }
}

