/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.ui.ClipboardCopier;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CopyTaskDetailsAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.copy";
    private Mode mode;

    public CopyTaskDetailsAction(Mode mode) {
        super("");
        this.setMode(mode);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
        this.setText(mode.message);
    }

    public void run() {
        ClipboardCopier.getDefault().copy(this.getStructuredSelection(), new ClipboardCopier.TextProvider(){

            public String getTextForElement(Object element) {
                return CopyTaskDetailsAction.getTextForTask(element, CopyTaskDetailsAction.this.getMode());
            }
        });
    }

    public static String getTextForTask(Object object) {
        return CopyTaskDetailsAction.getTextForTask(object, Mode.ID_SUMMARY_URL);
    }

    /*
     * WARNING - void declaration
     */
    public static String getTextForTask(Object object, Mode mode) {
        StringBuilder sb = new StringBuilder();
        switch (mode) {
            case KEY: {
                void task;
                Object object2 = object;
                if (!(object2 instanceof ITask)) break;
                ITask iTask = (ITask)object2;
                ITask cfr_ignored_0 = (ITask)object2;
                if (task.getTaskKey() == null) break;
                sb.append(task.getTaskKey());
                break;
            }
            case URL: {
                String taskUrl;
                if (!(object instanceof IRepositoryElement) || !TasksUiInternal.isValidUrl(taskUrl = CopyTaskDetailsAction.getUrl((IRepositoryElement)object))) break;
                sb.append(taskUrl);
                break;
            }
            case ID_SUMMARY: {
                void element;
                Object object3 = object;
                if (object3 instanceof ITask) {
                    void task;
                    ITask taskUrl = (ITask)object3;
                    ITask cfr_ignored_1 = (ITask)object3;
                    if (task.getTaskKey() != null) {
                        sb.append(StringUtils.capitalize((String)TasksUiInternal.getTaskPrefix(task.getConnectorKind())));
                        sb.append(task.getTaskKey());
                        sb.append(": ");
                    }
                    sb.append(task.getSummary());
                    break;
                }
                Object object4 = object;
                if (!(object4 instanceof IRepositoryElement)) break;
                IRepositoryElement iRepositoryElement = (IRepositoryElement)object4;
                IRepositoryElement cfr_ignored_2 = (IRepositoryElement)object4;
                sb.append(element.getSummary());
                break;
            }
            case ID_SUMMARY_URL: {
                void element;
                Object object5 = object;
                if (object5 instanceof ITask) {
                    void task;
                    ITask iTask = (ITask)object5;
                    ITask cfr_ignored_3 = (ITask)object5;
                    if (task.getTaskKey() != null) {
                        sb.append(task.getTaskKey());
                        sb.append(": ");
                    }
                    sb.append(task.getSummary());
                    String taskUrl = CopyTaskDetailsAction.getUrl((IRepositoryElement)object);
                    if (!TasksUiInternal.isValidUrl(taskUrl)) break;
                    sb.append(ClipboardCopier.LINE_SEPARATOR);
                    sb.append(taskUrl);
                    break;
                }
                if (object instanceof IRepositoryQuery) {
                    RepositoryQuery query = (RepositoryQuery)object;
                    sb.append(query.getSummary());
                    if (!TasksUiInternal.isValidUrl(query.getUrl())) break;
                    sb.append(ClipboardCopier.LINE_SEPARATOR);
                    sb.append(query.getUrl());
                    break;
                }
                Object object6 = object;
                if (!(object6 instanceof IRepositoryElement)) break;
                IRepositoryElement query = (IRepositoryElement)object6;
                IRepositoryElement cfr_ignored_4 = (IRepositoryElement)object6;
                sb.append(element.getSummary());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String getUrl(IRepositoryElement element) {
        IRepositoryElement iRepositoryElement = element;
        if (iRepositoryElement instanceof ITask) {
            void task;
            ITask iTask = (ITask)iRepositoryElement;
            ITask cfr_ignored_0 = (ITask)iRepositoryElement;
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(task.getConnectorKind());
            TaskRepository repository = TasksUiInternal.getRepository((IRepositoryElement)task);
            URL location = connector.getBrowserUrl(repository, element);
            if (location != null) {
                return location.toString();
            }
            if (task.getUrl() != null) {
                return task.getUrl();
            }
            return connector.getTaskUrl(task.getRepositoryUrl(), task.getTaskId());
        }
        if (element.getUrl() != null) {
            return element.getUrl();
        }
        return null;
    }

    public static enum Mode {
        KEY(Messages.CopyTaskDetailsAction_ID_Menu_Label),
        URL(Messages.CopyTaskDetailsAction_Url_Menu_Label),
        ID_SUMMARY(Messages.CopyTaskDetailsAction_ID_Summary_Menu_Label),
        ID_SUMMARY_URL(Messages.CopyTaskDetailsAction_ID_Summary_and_Url_Menu_Label);

        @Deprecated
        public static Mode SUMMARY;
        @Deprecated
        public static Mode SUMMARY_URL;
        private String message;

        static {
            SUMMARY = ID_SUMMARY;
            SUMMARY_URL = ID_SUMMARY_URL;
        }

        private Mode(String message) {
            this.message = message;
        }
    }
}

